/*
 * Decompiled with CFR 0.152.
 */
package jdk.net;

public class SocketFlow {
    private static final int UNSET = -1;
    public static final int NORMAL_PRIORITY = 1;
    public static final int HIGH_PRIORITY = 2;
    private int priority = 1;
    private long bandwidth = -1L;
    private Status status = Status.NO_STATUS;

    private SocketFlow() {
    }

    public static SocketFlow create() {
        return new SocketFlow();
    }

    public SocketFlow priority(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid priority");
        }
        this.priority = n;
        return this;
    }

    public SocketFlow bandwidth(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("invalid bandwidth");
        }
        this.bandwidth = l;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public long bandwidth() {
        return this.bandwidth;
    }

    public Status status() {
        return this.status;
    }

    public static enum Status {
        NO_STATUS,
        OK,
        NO_PERMISSION,
        NOT_CONNECTED,
        NOT_SUPPORTED,
        ALREADY_CREATED,
        IN_PROGRESS,
        OTHER;

    }
}

