/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.ntlm;

import com.sun.security.ntlm.Client;
import com.sun.security.ntlm.NTLMException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.Random;
import sun.misc.BASE64Decoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.ntlm.B64Encoder;
import sun.net.www.protocol.http.ntlm.NTLMAuthenticationCallback;
import sun.security.action.GetPropertyAction;

public class NTLMAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 170L;
    private static final NTLMAuthenticationCallback NTLMAuthCallback = NTLMAuthenticationCallback.getNTLMAuthenticationCallback();
    private String hostname;
    private static String defaultDomain = AccessController.doPrivileged(new GetPropertyAction("http.auth.ntlm.domain", "domain"));
    PasswordAuthentication pw;
    Client client;

    public static boolean supportsTransparentAuth() {
        return false;
    }

    public static boolean isTrustedSite(URL uRL) {
        return NTLMAuthCallback.isTrustedSite(uRL);
    }

    private void init0() {
        this.hostname = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string;
                try {
                    string = InetAddress.getLocalHost().getHostName().toUpperCase();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
                return string;
            }
        });
        int n = this.hostname.indexOf(46);
        if (n != -1) {
            this.hostname = this.hostname.substring(0, n);
        }
    }

    public NTLMAuthentication(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', AuthScheme.NTLM, uRL, "");
        this.init(passwordAuthentication);
    }

    private void init(PasswordAuthentication passwordAuthentication) {
        String string;
        String string2;
        this.pw = passwordAuthentication;
        String string3 = passwordAuthentication.getUserName();
        int n = string3.indexOf(92);
        if (n == -1) {
            string2 = string3;
            string = defaultDomain;
        } else {
            string = string3.substring(0, n).toUpperCase();
            string2 = string3.substring(n + 1);
        }
        char[] cArray = passwordAuthentication.getPassword();
        this.init0();
        try {
            this.client = new Client(System.getProperty("ntlm.version"), this.hostname, string2, string, cArray);
        }
        catch (NTLMException nTLMException) {
            try {
                this.client = new Client(null, this.hostname, string2, string, cArray);
            }
            catch (NTLMException nTLMException2) {
                throw new AssertionError((Object)"Really?");
            }
        }
    }

    public NTLMAuthentication(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', AuthScheme.NTLM, string, n, "");
        this.init(passwordAuthentication);
    }

    @Override
    public boolean supportsPreemptiveAuthorization() {
        return false;
    }

    @Override
    public String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    public boolean isAuthorizationStale(String string) {
        return false;
    }

    @Override
    public synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            String string2;
            if (string.length() < 6) {
                string2 = this.buildType1Msg();
            } else {
                String string3 = string.substring(5);
                string2 = this.buildType3Msg(string3);
            }
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    private String buildType1Msg() {
        byte[] byArray = this.client.type1();
        String string = "NTLM " + new B64Encoder().encode(byArray);
        return string;
    }

    private String buildType3Msg(String string) throws GeneralSecurityException, IOException {
        byte[] byArray = new BASE64Decoder().decodeBuffer(string);
        byte[] byArray2 = new byte[8];
        new Random().nextBytes(byArray2);
        byte[] byArray3 = this.client.type3(byArray, byArray2);
        String string2 = "NTLM " + new B64Encoder().encode(byArray3);
        return string2;
    }
}

