/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.BaseTypeIdImpl;

public class RowMultiSetImpl
extends BaseTypeIdImpl {
    private String[] _columnNames;
    private TypeDescriptor[] _types;

    public RowMultiSetImpl() {
    }

    public RowMultiSetImpl(String[] stringArray, TypeDescriptor[] typeDescriptorArray) {
        this._columnNames = stringArray;
        this._types = typeDescriptorArray;
        if (stringArray == null || typeDescriptorArray == null || stringArray.length != typeDescriptorArray.length) {
            throw new IllegalArgumentException("Bad args: columnNames = " + stringArray + ". types = " + typeDescriptorArray);
        }
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public TypeDescriptor[] getTypes() {
        return this._types;
    }

    public String getSQLTypeName() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._columnNames.length;
        stringBuffer.append("TABLE ( ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('\"');
            stringBuffer.append(this._columnNames[i]);
            stringBuffer.append('\"');
            stringBuffer.append(' ');
            stringBuffer.append(this._types[i].getSQLstring());
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public int getJDBCTypeId() {
        return 1111;
    }

    public int getTypeFormatId() {
        return 469;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2 = objectInput.readInt();
        this._columnNames = new String[n2];
        this._types = new TypeDescriptor[n2];
        for (n = 0; n < n2; ++n) {
            this._columnNames[n] = objectInput.readUTF();
        }
        for (n = 0; n < n2; ++n) {
            this._types[n] = (TypeDescriptor)objectInput.readObject();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = this._columnNames.length;
        objectOutput.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutput.writeUTF(this._columnNames[n]);
        }
        for (n = 0; n < n2; ++n) {
            objectOutput.writeObject(this._types[n]);
        }
    }
}

