/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.plugins.communicate.tool;

import cn.com.voltronic.plugins.communicate.tool.CRCUtil;
import cn.com.voltronic.plugins.communicate.tool.CheckSumUtil;
import cn.com.voltronic.plugins.communicate.tool.CommConnector;
import cn.com.voltronic.plugins.communicate.tool.CommunicateException;
import cn.com.voltronic.plugins.communicate.tool.CommunicateHandler;
import cn.com.voltronic.plugins.communicate.tool.ShowMsgPane;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AACheckBox;
import cn.com.voltronic.solar.view.component.AAJMenuItem;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AAPanel;
import cn.com.voltronic.solar.view.component.AARadioButton;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -3383025242036434390L;
    public static volatile boolean isScroll = true;
    private CommConnector comm = null;
    private CommunicateHandler _handler = null;
    private volatile boolean isStop;
    private volatile int sendCount;
    private volatile int returnCount;
    private JPopupMenu popupMenu;
    private JTextField commandText;
    private AACheckBox jCheckBox;
    private AAButton checksumButton;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JPanel jPanel2;
    private AAPanel jPanel3;
    private AARadioButton jRadioButton1;
    private AARadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinner1;
    public static JTextPane jTextPane1;
    private AALabel lookupLabel;
    private AALabel saveLabel;
    private AAButton refreshButton;
    private AAButton sendButton;
    private AAButton stopButton;
    private ButtonGroup commandButtonGroup = new ButtonGroup();
    private AARadioButton comRadioButton;
    private AARadioButton secComRadioButton;
    private JComboBox secComboBox;
    private JTextField secLengthTField;
    private JTextField secCommandTField;
    private AAButton secChecksumButton;
    private AACheckBox secCheckBox;

    static {
        try {
            Properties props = new Properties();
            props.put("foregroundColor", "255 255 255");
            props.put("frameColor", "130 130 130");
            props.put("gridColor", "210 210 210");
            props.put("logoString", "");
            props.put("tooltipBackgroundColor", "102 102 102");
            props.put("tooltipForegroundColor", "255 255 255");
            props.put("selectionBackgroundColor", "230 230 230");
            props.put("menuSelectionForegroundColor", "0 0 0");
            props.put("menuSelectionBackgroundColor", "230 230 230");
            props.put("menuSelectionBackgroundColorLight", "255 255 255");
            props.put("menuSelectionBackgroundColorDark", "230 230 230");
            props.put("menuBackgroundColor", "90 90 90");
            props.put("menuColorLight", "69 69 69");
            props.put("menuColorDark", "102 102 102");
            props.put("menuForegroundColor", "255 255 255");
            props.put("controlColor", "102 102 102");
            props.put("controlColorLight", "102 102 102");
            props.put("controlColorDark", "69 69 69");
            props.put("buttonForegroundColor", "255 255 255");
            props.put("buttonColor", "102 102 102");
            props.put("buttonBackgroundColor", "102 102 102");
            props.put("buttonColorLight", "230 230 230");
            props.put("buttonColorDark", "102 102 102");
            props.put("rolloverColor", "102 102 102");
            props.put("rolloverColorLight", "102 102 102");
            props.put("rolloverColorDark", "69 69 69");
            props.put("windowTitleForegroundColor", "0 0 0");
            props.put("windowTitleBackgroundColor", "69 69 69");
            props.put("windowTitleColorLight", "197 197 197");
            props.put("windowTitleColorDark", "69 69 69");
            props.put("windowBorderColor", "10 10 10");
            props.put("tabAreaBackgroundColor", "102 102 102");
            props.put("inputForegroundColor", "255 255 255");
            props.put("inputBackgroundColor", "102 102 102");
            props.put("focusColor", "255 255 255");
            props.put("focusCellColor", "255 255 255");
            props.put("backgroundColor", "102 102 102");
            props.put("backgroundColorLight", "255 255 255");
            props.put("backgroundColorDark", "102 102 102");
            SmartLookAndFeel.setCurrentTheme((Properties)props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MainFrame() {
        this.comm = CommConnector.getInstance();
        this.initComponents();
        this.setTitle("Communication Assistant");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(System.getProperty("user.dir")) + File.separator + "images" + File.separator + "desk.gif"));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.lookupLabel = new AALabel();
        this.saveLabel = new AALabel();
        this.commandText = new JTextField();
        this.jCheckBox = new AACheckBox();
        this.checksumButton = new AAButton();
        this.secComboBox = new JComboBox();
        this.secLengthTField = new JTextField();
        this.secCommandTField = new JTextField();
        this.secCommandTField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (Character.isLetter(e.getKeyChar())) {
                    int position = MainFrame.this.secCommandTField.getCaretPosition();
                    MainFrame.this.secCommandTField.setText(MainFrame.this.secCommandTField.getText().toUpperCase());
                    MainFrame.this.secCommandTField.setCaretPosition(position);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.secChecksumButton = new AAButton();
        this.secCheckBox = new AACheckBox();
        this.comRadioButton = new AARadioButton("Command");
        this.secComRadioButton = new AARadioButton("SEC Command");
        this.commandButtonGroup.add(this.comRadioButton);
        this.commandButtonGroup.add(this.secComRadioButton);
        this.comRadioButton.setSelected(true);
        this.comRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.commandRadioButtonActionHandler(evt);
            }
        });
        this.secComRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.commandRadioButtonActionHandler(evt);
            }
        });
        this.secChecksumButton.setText("CheckSum");
        this.secChecksumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String commandTextV;
                String command = commandTextV = MainFrame.this.secCommandTField.getText().trim();
                if (commandTextV.indexOf(44) == -1) {
                    String checkSumText = "";
                    if (commandTextV.indexOf("EY") != -1) {
                        checkSumText = "^P010" + commandTextV;
                    } else if (commandTextV.indexOf("EM") != -1) {
                        checkSumText = "^P012" + commandTextV;
                    } else if (commandTextV.indexOf("ED") != -1) {
                        checkSumText = "^P014" + commandTextV;
                    } else if (commandTextV.indexOf("EH") != -1) {
                        checkSumText = "^P016" + commandTextV;
                    }
                    String re = CheckSumUtil.getValidate(checkSumText);
                    MainFrame.this.secCommandTField.setText(String.valueOf(command) + re);
                }
            }
        });
        this.secCheckBox.setText("Use CRC");
        this.secLengthTField.setEditable(false);
        this.secComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"^P", "^S"}));
        this.secComboBox.setEnabled(false);
        this.secLengthTField.setEnabled(false);
        this.secCommandTField.setEnabled(false);
        this.secChecksumButton.setEnabled(false);
        this.secCheckBox.setEnabled(false);
        this.jPanel3 = new AAPanel();
        this.jScrollPane1 = new JScrollPane();
        jTextPane1 = new JTextPane();
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.jRadioButton1 = new AARadioButton();
        this.jRadioButton2 = new AARadioButton();
        this.refreshButton = new AAButton();
        this.sendButton = new AAButton();
        this.stopButton = new AAButton();
        this.jSpinner1 = new JSpinner();
        this.popupMenu = new JPopupMenu();
        AAJMenuItem clearItem = new AAJMenuItem("Clear");
        final AAJMenuItem srcollItem = new AAJMenuItem("Stop scrolling");
        this.popupMenu.add(clearItem);
        this.popupMenu.add(srcollItem);
        clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jTextPane1.setText("");
            }
        });
        srcollItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (isScroll) {
                    isScroll = false;
                    srcollItem.setText("Scrolling");
                } else {
                    isScroll = true;
                    srcollItem.setText("Stop scrolling");
                }
            }
        });
        this.setDefaultCloseOperation(3);
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.refreshButton.setEnabled(false);
                MainFrame.this.jComboBox1.setModel(new DefaultComboBoxModel<String>(MainFrame.this.getDevices()));
                Object obj = MainFrame.this.jComboBox1.getSelectedItem();
                if (obj != null) {
                    String select = obj.toString();
                    if (select.startsWith("USB")) {
                        MainFrame.this.jComboBox2.setEnabled(false);
                    } else {
                        MainFrame.this.jComboBox2.setEnabled(true);
                    }
                }
                MainFrame.this.refreshButton.setEnabled(true);
            }
        });
        this.lookupLabel.setText("Com. port:");
        this.saveLabel.setText("Command:");
        this.commandText.setText("QPI");
        this.commandText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (Character.isLetter(e.getKeyChar())) {
                    int position = MainFrame.this.commandText.getCaretPosition();
                    MainFrame.this.commandText.setText(MainFrame.this.commandText.getText().toUpperCase());
                    MainFrame.this.commandText.setCaretPosition(position);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.checksumButton.setText("CheckSum");
        this.checksumButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String commandTextV = MainFrame.this.commandText.getText();
                if (commandTextV.indexOf(44) == -1) {
                    String re = CheckSumUtil.getValidate(commandTextV);
                    MainFrame.this.commandText.setText(String.valueOf(commandTextV) + re);
                } else {
                    String[] arr = commandTextV.split(",");
                    StringBuffer sb = new StringBuffer();
                    String[] stringArray = arr;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        sb.append(String.valueOf(str) + CheckSumUtil.getValidate(str)).append(",");
                        ++n2;
                    }
                    String reV = sb.toString();
                    MainFrame.this.commandText.setText(reV.substring(0, reV.length() - 1));
                }
            }
        });
        this.jCheckBox.setText("Use CRC");
        this.jCheckBox.setSelected(false);
        this.jPanel3.setTitle("Output window");
        this.jPanel3.setLayout(new BorderLayout());
        jTextPane1.setEditable(false);
        jTextPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isMetaDown()) {
                    MainFrame.this.triggerEvent(e);
                }
            }
        });
        this.jScrollPane1.setViewportView(jTextPane1);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.getDevices()));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.jComboBox1.getSelectedItem() != null) {
                    String mask = MainFrame.this.jComboBox1.getSelectedItem().toString();
                    if (mask.startsWith("USB")) {
                        MainFrame.this.jComboBox2.setEnabled(false);
                    } else {
                        MainFrame.this.jComboBox2.setEnabled(true);
                    }
                }
            }
        });
        String[] botelv = new String[]{"1200", "2400", "4800", "9600", "19200"};
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(botelv));
        this.jComboBox2.setSelectedItem("2400");
        String select = "";
        if (this.jComboBox1.getSelectedItem() != null) {
            select = this.jComboBox1.getSelectedItem().toString();
        }
        if (select.startsWith("USB")) {
            this.jComboBox2.setEnabled(false);
        } else {
            this.jComboBox2.setEnabled(true);
        }
        this.jRadioButton1.setText("Once");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.jRadioButton1.setSelected(true);
                MainFrame.this.jRadioButton2.setSelected(false);
                MainFrame.this.stopButton.setEnabled(false);
                MainFrame.this.jSpinner1.setEnabled(false);
            }
        });
        this.jRadioButton2.setSelected(true);
        this.jRadioButton2.setText("Continuous, interval");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.jRadioButton1.setSelected(false);
                MainFrame.this.jRadioButton2.setSelected(true);
                MainFrame.this.stopButton.setEnabled(true);
                MainFrame.this.jSpinner1.setEnabled(true);
            }
        });
        this.jSpinner1 = this.getJSpinner(1, 600, 1, 2);
        this.sendButton.setText("Send");
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.sendCommand(e);
            }
        });
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.stopSend(e);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.comRadioButton, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lookupLabel, -2, 75, -2))).addComponent(this.secComRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jComboBox1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refreshButton)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.secComboBox, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secLengthTField, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secCommandTField, -1, 166, Short.MAX_VALUE)).addComponent(this.commandText, -1, 320, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.secChecksumButton, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.checksumButton, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.secCheckBox, -2, -1, -2).addComponent(this.jCheckBox, -2, -1, -2))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sendButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopButton))).addGap(40, 40, 40)).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refreshButton).addComponent(this.jComboBox2, -2, -1, -2).addComponent(this.lookupLabel).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checksumButton).addComponent(this.comRadioButton).addComponent(this.commandText, -2, -1, -2)).addComponent(this.jCheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.secLengthTField, -2, -1, -2).addComponent(this.secCommandTField, -2, -1, -2).addComponent(this.secChecksumButton).addComponent(this.secComRadioButton).addComponent(this.secComboBox, -2, -1, -2)).addComponent(this.secCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.sendButton).addComponent(this.stopButton)).addGap(18, 18, 18).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.setSize(650, 500);
    }

    public void sendCommand(ActionEvent e) {
        if (this.comRadioButton.isSelected()) {
            this.commandSendhandler();
        } else if (this.secComRadioButton.isSelected()) {
            this.secCommandSendhandler();
        }
    }

    private void commandSendhandler() {
        String command = this.commandText.getText().trim();
        this.sendHandler(command);
    }

    private void secCommandSendhandler() {
        String secCommand = this.secCommandTField.getText().trim();
        if (this.secCheckBox.isSelected()) {
            secCommand = String.valueOf(secCommand) + "  ";
        }
        String type = this.secComboBox.getItemAt(this.secComboBox.getSelectedIndex()).toString();
        String command = "";
        if (type.equals("^P")) {
            command = MainFrame.addPollHeader(secCommand);
            this.secLengthTField.setText(command.substring(2, 5));
        } else if (type.equals("^S")) {
            command = MainFrame.addSetHeader(secCommand);
            this.secLengthTField.setText(command.substring(2, 5));
        }
        command = command.trim();
        this.secSendHandler(command);
    }

    private void sendHandler(String command) {
        this.sendButton.setEnabled(false);
        this.jRadioButton1.setEnabled(false);
        this.jRadioButton2.setEnabled(false);
        this.jSpinner1.setEnabled(false);
        this.jCheckBox.setEnabled(false);
        this.sendCount = 0;
        this.returnCount = 0;
        String portName = this.jComboBox1.getSelectedItem().toString().trim();
        String baudRate = this.jComboBox2.getSelectedItem().toString().trim();
        this._handler = this.comm.connDeviceByName(portName, baudRate);
        if (command.indexOf(44) == -1) {
            int millis = Integer.parseInt(this.jSpinner1.getValue().toString());
            String[] arr = new String[]{command};
            SendCommand send = new SendCommand(arr, millis);
            send.start();
        } else {
            int millis = Integer.parseInt(this.jSpinner1.getValue().toString());
            SendCommand send = new SendCommand(command.split(","), millis);
            send.start();
        }
    }

    private void secSendHandler(String command) {
        this.sendButton.setEnabled(false);
        this.jRadioButton1.setEnabled(false);
        this.jRadioButton2.setEnabled(false);
        this.jSpinner1.setEnabled(false);
        this.jCheckBox.setEnabled(false);
        this.sendCount = 0;
        this.returnCount = 0;
        String portName = this.jComboBox1.getSelectedItem().toString().trim();
        String baudRate = this.jComboBox2.getSelectedItem().toString().trim();
        this._handler = this.comm.connDeviceByName(portName, baudRate);
        int millis = Integer.parseInt(this.jSpinner1.getValue().toString());
        String[] arr = new String[]{command};
        SendCommand send = new SendCommand(arr, millis);
        send.start();
    }

    private void commandRadioButtonActionHandler(ActionEvent e) {
        if (e.getSource() == this.secComRadioButton) {
            this.commandText.setEditable(false);
            this.checksumButton.setEnabled(false);
            this.jCheckBox.setSelected(this.jCheckBox.isSelected());
            this.jCheckBox.setEnabled(false);
            this.secComboBox.setEnabled(true);
            this.secCommandTField.setEditable(true);
            this.secCommandTField.setEnabled(true);
            this.secChecksumButton.setEnabled(true);
            this.secCheckBox.setEnabled(true);
        } else if (e.getSource() == this.comRadioButton) {
            this.secComboBox.setEnabled(false);
            this.secCommandTField.setEditable(false);
            this.secCommandTField.setEnabled(false);
            this.secChecksumButton.setEnabled(false);
            this.secCheckBox.setSelected(false);
            this.secCheckBox.setEnabled(false);
            this.commandText.setEditable(true);
            this.checksumButton.setEnabled(true);
            this.jCheckBox.setEnabled(true);
            this.jCheckBox.setSelected(this.jCheckBox.isSelected());
        }
    }

    public void stopSend(ActionEvent e) {
        this.isStop = true;
        if (this.sendCount != 0) {
            int re = this.returnCount * 100 / this.sendCount;
            ShowMsgPane.showMsg("The number of successful return", String.valueOf(this.returnCount), "Number of times to send commands", String.valueOf(this.sendCount), "Success rate", String.valueOf(re) + "%");
        } else {
            ShowMsgPane.showMsgRed("God, I collapsed!");
        }
    }

    public String[] getDevices() {
        List<Object> deviceList = new ArrayList();
        deviceList = this.comm.autoSearchLocalcomms();
        String[] arr = new String[deviceList.size()];
        int i = 0;
        while (i < deviceList.size()) {
            arr[i] = (String)deviceList.get(i);
            ++i;
        }
        return arr;
    }

    private JSpinner getJSpinner(int min, int max, int step, int value) {
        SpinnerNumberModel model = new SpinnerNumberModel();
        model.setMinimum(Integer.valueOf(min));
        model.setMaximum(Integer.valueOf(max));
        model.setStepSize(step);
        model.setValue(value);
        JSpinner jSpinner = new JSpinner(model);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(jSpinner);
        numberEditor.getTextField().setEditable(false);
        jSpinner.setEditor(numberEditor);
        return jSpinner;
    }

    private void triggerEvent(MouseEvent e) {
        this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame();
            }
        });
    }

    private static String addSetHeader(String senddata) {
        int len = senddata.length();
        return "^S" + String.format("%03d", len + 1) + senddata;
    }

    private static String addPollHeader(String senddata) {
        int len = senddata.length();
        return "^P" + String.format("%03d", len + 1) + senddata;
    }

    class SendCommand
    extends Thread {
        String[] command = null;
        int millis = 0;

        public SendCommand(String[] command, int millis) {
            this.command = command;
            this.millis = millis;
        }

        @Override
        public void run() {
            boolean useCRC = MainFrame.this.jCheckBox.isSelected();
            if (MainFrame.this.comRadioButton.isSelected()) {
                useCRC = MainFrame.this.jCheckBox.isSelected();
            } else if (MainFrame.this.secComRadioButton.isSelected()) {
                useCRC = MainFrame.this.secCheckBox.isSelected();
            }
            while (!MainFrame.this.isStop) {
                if (MainFrame.this._handler != null) {
                    int i = 0;
                    while (i < this.command.length) {
                        try {
                            MainFrame mainFrame = MainFrame.this;
                            mainFrame.sendCount = mainFrame.sendCount + 1;
                            ShowMsgPane.showMsg("message.send", this.command[i]);
                            long date1 = System.currentTimeMillis();
                            String result = MainFrame.this._handler.excuteCommand(this.command[i], true, useCRC);
                            long date2 = System.currentTimeMillis();
                            ShowMsgPane.showMsg(String.valueOf(date2 - date1), "message.return", result);
                            if (result != null && !"".equals(result) && !result.equals(this.command[i])) {
                                if (useCRC) {
                                    if (CRCUtil.checkCRC(result)) {
                                        MainFrame mainFrame2 = MainFrame.this;
                                        mainFrame2.returnCount = mainFrame2.returnCount + 1;
                                    }
                                } else {
                                    MainFrame mainFrame3 = MainFrame.this;
                                    mainFrame3.returnCount = mainFrame3.returnCount + 1;
                                }
                            }
                        }
                        catch (CommunicateException e) {
                            ShowMsgPane.showMsgRed(e.getMessage());
                            e.printStackTrace();
                        }
                        if (MainFrame.this.isStop) break;
                        ++i;
                    }
                    if (MainFrame.this.jRadioButton1.isSelected()) {
                        MainFrame.this.isStop = true;
                        continue;
                    }
                    try {
                        Thread.sleep(this.millis * 1000);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                ShowMsgPane.showMsgRed("Communication exception: null handler");
                MainFrame.this.isStop = true;
            }
            MainFrame.this.isStop = false;
            MainFrame.this.jRadioButton1.setEnabled(true);
            MainFrame.this.jRadioButton2.setEnabled(true);
            if (MainFrame.this.jRadioButton1.isSelected()) {
                MainFrame.this.jSpinner1.setEnabled(false);
            } else {
                MainFrame.this.jSpinner1.setEnabled(true);
            }
            MainFrame.this.jCheckBox.setEnabled(true);
            MainFrame.this.sendButton.setEnabled(true);
            if (MainFrame.this._handler != null) {
                MainFrame.this._handler.close();
            }
            if (MainFrame.this.comm != null) {
                MainFrame.this.comm.close();
            }
            if (MainFrame.this.secComRadioButton.isSelected()) {
                MainFrame.this.commandText.setEditable(false);
                MainFrame.this.checksumButton.setEnabled(false);
                MainFrame.this.jCheckBox.setSelected(false);
                MainFrame.this.jCheckBox.setEnabled(false);
                MainFrame.this.secCommandTField.setEditable(true);
                MainFrame.this.secCommandTField.setEnabled(true);
                MainFrame.this.secChecksumButton.setEnabled(true);
                MainFrame.this.secCheckBox.setEnabled(true);
            } else if (MainFrame.this.comRadioButton.isSelected()) {
                MainFrame.this.secCommandTField.setEditable(false);
                MainFrame.this.secCommandTField.setEnabled(false);
                MainFrame.this.secChecksumButton.setEnabled(false);
                MainFrame.this.secCheckBox.setSelected(false);
                MainFrame.this.secCheckBox.setEnabled(false);
                MainFrame.this.commandText.setEditable(true);
                MainFrame.this.checksumButton.setEnabled(true);
                MainFrame.this.jCheckBox.setEnabled(true);
                MainFrame.this.jCheckBox.setSelected(MainFrame.this.jCheckBox.isSelected());
            }
        }
    }
}

