/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.beanbag.P18BeanBag;
import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.AbstractComUSBProcessor;
import cn.com.voltronic.solar.comusbprocessor.ParallSubProcessor;
import cn.com.voltronic.solar.control.P18ComUSBControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class P18ComUSBProcessor
extends AbstractComUSBProcessor {
    private static Logger logger = Logger.getLogger(P18ComUSBProcessor.class);
    public static Lock lock = new ReentrantLock();
    public int _preparalleltype = 0;
    public boolean bfirsttime = true;
    private Object query_day = new Integer(1);
    private Object query_month = new Integer(1);
    private Object query_year = new Integer(1);
    private Object query_tatal = new Integer(1);
    private static final String ACTION_QUERY_MACHINE_INFO = "qryMachineInfo";
    private static final String ACTION_QUERY_CONFIG_DATA = "qryConfigData";
    private static final String GAP = ",";
    private static final double UNIT_10 = 10.0;
    private Map<String, String> batteryType = new HashMap<String, String>();
    private Map<String, String> inputVoltageType = new HashMap<String, String>();
    private Map<String, String> outputSourceType = new HashMap<String, String>();
    private Map<String, String> chargerSourceType = new HashMap<String, String>();
    private Map<String, String> machineType = new HashMap<String, String>();
    private Map<String, String> topologyType = new HashMap<String, String>();
    private Map<String, String> solarPriorityType = new HashMap<String, String>();
    private Map<String, String> workModeType = new HashMap<String, String>();
    private Map<String, String> outputModelType = new HashMap<String, String>();
    private Map<String, String> enable = new HashMap<String, String>();
    private Map<String, String> regulationType = new HashMap<String, String>();

    public P18ComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
        this.init();
    }

    private void init() {
        this.batteryType.put("0", "AGM");
        this.batteryType.put("1", "Flooded");
        this.batteryType.put("2", "User");
        this.inputVoltageType.put("0", "Appliance");
        this.inputVoltageType.put("1", "UPS");
        this.outputSourceType.put("0", "Solar-Utility-Battery");
        this.outputSourceType.put("1", "Solar-Battery-Utility");
        this.chargerSourceType.put("0", "Solar first");
        this.chargerSourceType.put("1", "Solar and Utility");
        this.chargerSourceType.put("2", "Solar only");
        this.machineType.put("0", "Off-grid");
        this.machineType.put("1", "Hybrid");
        this.topologyType.put("0", "Transformerless");
        this.topologyType.put("1", "Transformer");
        this.solarPriorityType.put("0", "Battery-Load-Utility");
        this.solarPriorityType.put("1", "Load-Battery-Utility");
        this.workModeType.put("00", "Power On Mode");
        this.workModeType.put("01", "Standby Mode");
        this.workModeType.put("02", "Bypass Mode");
        this.workModeType.put("03", "Battery Mode");
        this.workModeType.put("04", "Fault Mode");
        this.workModeType.put("05", "Hybrid Mode");
        this.workModeType.put("06", "Charge Mode");
        this.outputModelType.put("0", "Single");
        this.outputModelType.put("1", "Parallel output");
        this.outputModelType.put("2", "Phase R of 3 phase output");
        this.outputModelType.put("3", "Phase S of 3 phase output");
        this.outputModelType.put("4", "Phase T of 3 phase output");
        this.outputModelType.put("5", "Phase 1 of 2 phase output");
        this.outputModelType.put("6", "Phase 2 of 2 phase output");
        this.enable.put("0", "Disable");
        this.enable.put("1", "Enable");
        this.regulationType.put("00", "India");
        this.regulationType.put("01", "Germany");
        this.regulationType.put("02", "South America");
    }

    @Override
    public String getDeviceMode() {
        return null;
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P18BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P18ComUSBControlModule(this.getHandler(), (ConfigData)this._beanbag.getBean("configdata"), (Capability)this._beanbag.getBean("capability"));
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        info.setMoreInfo(this._protocol.getMoreInfo());
        info.setMpptTrackNumber(this._protocol.getMpptTrackNumber());
        try {
            info.setSerialno(this._protocol.getSerialNo());
        }
        catch (Exception e) {
            logger.error((Object)("initProtocol Func -->" + e.getMessage()));
        }
    }

    @Override
    public boolean pollQuery() {
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(this._protocol.getSerialNo());
        if (this.currenttime != null) {
            workInfo.setCurrentTime(this.currenttime.getTime());
        }
        if (this.bfirsttime) {
            this._preparalleltype = this._paralleltype;
            this.bfirsttime = false;
        } else if (this._preparalleltype != this._paralleltype) {
            this.close();
            return false;
        }
        if (this._paralleltype != 0) {
            try {
                lock.lock();
                boolean bl = this.pollQueryParallel();
                return bl;
            }
            catch (Exception e) {
                return false;
            }
            finally {
                lock.unlock();
            }
        }
        try {
            this.pGS(workInfo, handler);
            this.pMOD(workInfo, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void pGS(WorkInfo workInfo, IComUSBHandler handler) {
        String pGS = handler.excuteCommand("GS", true);
        if (this.isEmpty(pGS)) {
            return;
        }
        String[] gs = pGS.split(GAP);
        double gridVoltage = VolUtil.parseDouble(gs[0]) / 10.0;
        double gridFrequency = VolUtil.parseDouble(gs[1]) / 10.0;
        double acOutputVoltage = VolUtil.parseDouble(gs[2]) / 10.0;
        double acOutputFrequency = VolUtil.parseDouble(gs[3]) / 10.0;
        int acOutputApperentPower = VolUtil.parseInt(gs[4]);
        int acOutputActivePower = VolUtil.parseInt(gs[5]);
        int outputLoadPercent = VolUtil.parseInt(gs[6]);
        double batteryVoltage = VolUtil.parseDouble(gs[7]) / 10.0;
        double batteryVoltageFromSCC1 = VolUtil.parseDouble(gs[8]) / 10.0;
        double batteryVoltageFromSCC2 = VolUtil.parseDouble(gs[9]) / 10.0;
        double disChargingCurrent = VolUtil.parseDouble(gs[10]);
        double chargingCurrent = VolUtil.parseDouble(gs[11]);
        int batteryCapacity = VolUtil.parseInt(gs[12]);
        int heatSinkTemperature = VolUtil.parseInt(gs[13]);
        int mpptChargerTemperature1 = VolUtil.parseInt(gs[14]);
        int mpptChargerTemperature2 = VolUtil.parseInt(gs[15]);
        int pvInputPower1 = VolUtil.parseInt(gs[16]);
        int pvInputPower2 = VolUtil.parseInt(gs[17]);
        double pvInputVoltage1 = VolUtil.parseDouble(gs[18]) / 10.0;
        double pvInputVoltage2 = VolUtil.parseDouble(gs[19]) / 10.0;
        String settingValueState = gs[20];
        String pv1WorkStatus = gs[21];
        String pv2WorkStatus = gs[22];
        String loadConnection = gs[23];
        String batteryStatus = gs[24];
        String invDirection = gs[25];
        String lineDirection = gs[26];
        String localParallelID = gs[27];
        this.setParallKey(VolUtil.parseInt(localParallelID));
        workInfo.setGridVoltageR(gridVoltage);
        workInfo.setGridFrequency(gridFrequency);
        workInfo.setAcOutputVoltageR(acOutputVoltage);
        workInfo.setAcOutputFrequency(acOutputFrequency);
        workInfo.setAcOutputApperentPowerR(acOutputApperentPower);
        workInfo.setAcOutputActivePowerR(acOutputActivePower);
        workInfo.setOutputLoadPercent(outputLoadPercent);
        workInfo.setBatteryVoltage(batteryVoltage);
        workInfo.setBatteryVoltageFromSCC1(batteryVoltageFromSCC1);
        workInfo.setBatteryVoltageFromSCC2(batteryVoltageFromSCC2);
        workInfo.setDisChargingCurrent(disChargingCurrent);
        workInfo.setChargingCurrent(chargingCurrent);
        workInfo.setBatteryCapacity(batteryCapacity);
        workInfo.setHeatSinkTemperature(heatSinkTemperature);
        workInfo.setMpptChargerTemperature1(mpptChargerTemperature1);
        workInfo.setMpptChargerTemperature2(mpptChargerTemperature2);
        workInfo.setMaxTemperature(workInfo.getHeatSinkTemperature());
        workInfo.setPvInputPower1(pvInputPower1);
        workInfo.setPvInputPower2(pvInputPower2);
        workInfo.setPvInputVoltage1(pvInputVoltage1);
        workInfo.setPvInputVoltage2(pvInputVoltage2);
        workInfo.setPv1WorkStatus(pv1WorkStatus);
        workInfo.setPv2WorkStatus(pv2WorkStatus);
        if (workInfo.getPv1WorkStatus().equals("2") || workInfo.getPv2WorkStatus().equals("2")) {
            workInfo.setPvLoss(false);
        } else {
            workInfo.setPvLoss(true);
        }
        if (loadConnection.equals("0")) {
            workInfo.setHasLoad(false);
        } else {
            workInfo.setHasLoad(true);
        }
        workInfo.setBatteryStatus(batteryStatus);
        workInfo.setInvDirection(invDirection);
        workInfo.setLineDirection(lineDirection);
    }

    protected void pMOD(WorkInfo workInfo, IComUSBHandler handler) {
        String pMOD = handler.excuteCommand("MOD", true);
        if (this.isEmpty(pMOD)) {
            return;
        }
        String workMode = this.workModeType.get(pMOD);
        workInfo.setWorkMode(workMode);
    }

    protected void pGMN(MachineInfo machineInfo, IComUSBHandler handler) {
        String pGMN = handler.excuteCommand("GMN", true);
        if (this.isEmpty(pGMN)) {
            return;
        }
        String machineModel = this.machineType.get(pGMN);
        machineInfo.setMachineModel(machineModel);
    }

    public boolean pollQueryParallel() {
        boolean result = true;
        boolean bParentLoss = true;
        int parall_i = 0;
        ArrayList<String> curList = new ArrayList<String>();
        ArrayList<String> delList = new ArrayList<String>();
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            parall_i = 0;
            while (parall_i < this._parallelnum) {
                String[] prin;
                int existent;
                String qPRIn = handler.excuteCommand("PRI" + parall_i, true);
                if (!this.isEmpty(qPRIn) && (existent = VolUtil.parseInt((prin = qPRIn.split(GAP))[0])) != 0) {
                    ParallSubProcessor processor;
                    int validLength = VolUtil.parseInt(prin[1]);
                    String serial = prin[2];
                    serial = serial.substring(0, validLength);
                    curList.add(serial);
                    if (this.subMap.containsKey(serial)) {
                        processor = (ParallSubProcessor)this.subMap.get(serial);
                        processor.setParallKey(parall_i);
                        this.pPGSn(parall_i, processor, handler);
                        String oldKey = processor.processorKey();
                        if (!processor.reGenProcesorKey().equalsIgnoreCase(oldKey)) {
                            GlobalProcessors.removeProcessor(oldKey);
                            GlobalProcessors.addProcessor(processor.processorKey(), processor);
                        }
                    } else if (serial.equalsIgnoreCase(this.getSerialNo())) {
                        this.setParallKey(parall_i);
                        this.pPGSn(parall_i, this, handler);
                        String oldKey = this.processorKey();
                        if (!this.reGenProcesorKey().equalsIgnoreCase(oldKey)) {
                            GlobalProcessors.removeProcessor(oldKey);
                            GlobalProcessors.addProcessor(this.processorKey(), this);
                        }
                        bParentLoss = false;
                    } else {
                        processor = new ParallSubProcessor(this, new P18BeanBag());
                        processor.setDeviceName(this.getDeviceName());
                        processor.setSerialNo(serial);
                        processor.setParallKey(parall_i);
                        this.pPGSn(parall_i, processor, handler);
                        this.subMap.put(serial, processor);
                        processor.saveDevice();
                        GlobalProcessors.addProcessor(processor.processorKey(), processor);
                    }
                }
                ++parall_i;
            }
            for (Map.Entry entry : this.subMap.entrySet()) {
                if (curList.indexOf(entry.getKey()) >= 0) continue;
                ((ParallSubProcessor)entry.getValue()).close();
                delList.add((String)entry.getKey());
            }
            for (String key : delList) {
                this.subMap.remove(key);
            }
            if (bParentLoss) {
                this.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean pollQueryStatus() {
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(this._protocol.getSerialNo());
        this.pFWS(workInfo, handler);
        workInfo.setNoBattery(false);
        return true;
    }

    private void pFWS(WorkInfo workInfo, IComUSBHandler handler) {
        String pFWS = handler.excuteCommand("FWS", true);
        if (this.isEmpty(pFWS)) {
            return;
        }
        String[] ws = pFWS.split(GAP);
        this.warnsHandler(ws[1], "2001", workInfo);
        this.warnsHandler(ws[2], "2002", workInfo);
        this.warnsHandler(ws[3], "2003", workInfo);
        this.warnsHandler(ws[4], "2004", workInfo);
        this.warnsHandler(ws[5], "2005", workInfo);
        this.warnsHandler(ws[6], "2006", workInfo);
        this.warnsHandler(ws[7], "2007", workInfo);
        this.warnsHandler(ws[8], "2008", workInfo);
        this.warnsHandler(ws[9], "2009", workInfo);
        this.warnsHandler(ws[10], "2010", workInfo);
        this.warnsHandler(ws[11], "2011", workInfo);
        this.warnsHandler(ws[12], "2012", workInfo);
        this.warnsHandler(ws[13], "2013", workInfo);
        this.warnsHandler(ws[14], "2014", workInfo);
        this.warnsHandler(ws[15], "2015", workInfo);
        this.warnsHandler(ws[16], "2016", workInfo);
        workInfo.setLineLoss(ws[1].equals("1"));
        workInfo.setOverLoad(ws[8].equals("1"));
        this.setFaults(workInfo, ws[0]);
    }

    private void setFaults(WorkInfo workInfo, String faultCode) {
        if (VolUtil.parseInt(faultCode) > 0) {
            workInfo.setFault(true);
            DataBeforeFault data = new DataBeforeFault();
            data.setProdid(workInfo.getProdid());
            data.setSerialno(workInfo.getSerialno());
            data.setTrandate(workInfo.getCurrentTime());
            data.setWorkMode(workInfo.getWorkMode());
            data.setGridVoltage(workInfo.getGridCurrentR());
            data.setGridFrequency(workInfo.getGridFrequency());
            data.setAcoutputvoltager(workInfo.getAcOutputVoltageR());
            data.setAcoutputfrequency(workInfo.getAcOutputFrequency());
            data.setAcoutputapperentpowerr(workInfo.getAcOutputActivePowerR());
            data.setAcoutputactivepowerr(workInfo.getAcOutputActivePowerR());
            data.setBatteryVoltage(workInfo.getPBatteryVoltage());
            data.setBatteryDischargeCurrent(workInfo.getDisChargingCurrent());
            data.setBatteryChargingCurrent(workInfo.getChargingCurrent());
            data.setBatteryCapacity(workInfo.getBatteryCapacity());
            data.setPvinputpower1(workInfo.getPvInputPower1());
            data.setPvinputpower2(workInfo.getPvInputPower1());
            data.setPvinputvoltage1(workInfo.getPvInputVoltage1());
            data.setPvinputvoltage2(workInfo.getPvInputVoltage2());
            this.faultsHandler(faultCode, workInfo, data);
        }
    }

    private void pPGSn(int parallelKey, AbstractProcessor processor, IComUSBHandler handler) {
        String pPGSn = handler.excuteCommand("PGS" + parallelKey, true);
        if (this.isEmpty(pPGSn)) {
            return;
        }
        String[] pgs = pPGSn.split(GAP);
        String workMode = this.workModeType.get("0" + pgs[1]);
        String faultCode = pgs[2];
        double gridVoltage = VolUtil.parseDouble(pgs[3]) / 10.0;
        double gridFrequency = VolUtil.parseDouble(pgs[4]) / 10.0;
        double acoutputvoltage = VolUtil.parseDouble(pgs[5]) / 10.0;
        double acoutputfrequency = VolUtil.parseDouble(pgs[6]) / 10.0;
        int acoutputapperentpower = VolUtil.parseInt(pgs[7]);
        int acoutputactivepower = VolUtil.parseInt(pgs[8]);
        int totalAcoutputapperentpower = VolUtil.parseInt(pgs[9]);
        int totalAcoutputactivepower = VolUtil.parseInt(pgs[10]);
        int outputLoadPercent = VolUtil.parseInt(pgs[11]);
        int totalOutputLoadPercent = VolUtil.parseInt(pgs[12]);
        double batteryVoltage = VolUtil.parseDouble(pgs[13]) / 10.0;
        double batteryDischargeCurrent = VolUtil.parseDouble(pgs[14]);
        double batteryChargingCurrent = VolUtil.parseDouble(pgs[15]);
        double totalBatteryChargingCurrent = VolUtil.parseDouble(pgs[16]);
        int batteryCapacity = VolUtil.parseInt(pgs[17]);
        int pvinputpower1 = VolUtil.parseInt(pgs[18]);
        int pvinputpower2 = VolUtil.parseInt(pgs[19]);
        double pvinputvoltage1 = VolUtil.parseDouble(pgs[20]) / 10.0;
        double pvinputvoltage2 = VolUtil.parseDouble(pgs[21]) / 10.0;
        String pv1WorkStatus = pgs[22];
        String pv2WorkStatus = pgs[23];
        String loadConnection = pgs[24];
        String batteryStatus = pgs[25];
        String invDirection = pgs[26];
        String lineDirection = pgs[27];
        int pallTemperature = 0;
        if (pgs.length - 27 - 1 > 0) {
            pallTemperature = VolUtil.parseInt(pgs[28]);
        }
        Calendar calendar = Calendar.getInstance();
        WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workinfo");
        workInfo.setProdid(this._protocol.getProtocolID());
        workInfo.setSerialno(processor.getSerialNo());
        workInfo.setCurrentTime(calendar.getTime());
        workInfo.setWorkMode(workMode);
        workInfo.setGridVoltageR(gridVoltage);
        workInfo.setGridFrequency(gridFrequency);
        workInfo.setAcOutputVoltageR(acoutputvoltage);
        workInfo.setAcOutputFrequency(acoutputfrequency);
        workInfo.setAcOutputApperentPowerR(acoutputapperentpower);
        workInfo.setAcOutputActivePowerR(acoutputactivepower);
        workInfo.setTotalACOutputApparentPower(totalAcoutputapperentpower);
        workInfo.setTotalACOutputActivePower(totalAcoutputactivepower);
        workInfo.setOutputLoadPercent(outputLoadPercent);
        workInfo.setTotalOutputLoadPercent(totalOutputLoadPercent);
        workInfo.setBatteryVoltage(batteryVoltage);
        workInfo.setDisChargingCurrent(batteryDischargeCurrent);
        workInfo.setChargingCurrent(batteryChargingCurrent);
        workInfo.setTotalBatteryChargingCurrent(totalBatteryChargingCurrent);
        workInfo.setBatteryCapacity(batteryCapacity);
        workInfo.setPvInputPower1(pvinputpower1);
        workInfo.setPvInputPower2(pvinputpower2);
        workInfo.setPvInputVoltage1(pvinputvoltage1);
        workInfo.setPvInputVoltage2(pvinputvoltage2);
        workInfo.setPv1WorkStatus(pv1WorkStatus);
        workInfo.setPv2WorkStatus(pv2WorkStatus);
        if (pgs.length - 27 - 1 > 0) {
            workInfo.setPallTemperature(pallTemperature);
            workInfo.setMaxTemperature(workInfo.getPallTemperature());
        }
        if (workInfo.getPv1WorkStatus().equals("2") || workInfo.getPv2WorkStatus().equals("2")) {
            workInfo.setPvLoss(false);
        } else {
            workInfo.setPvLoss(true);
        }
        if (loadConnection.equals("0")) {
            workInfo.setHasLoad(false);
        } else {
            workInfo.setHasLoad(true);
        }
        WorkInfo hsWorkInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        workInfo.setLineLoss(hsWorkInfo.isLineLoss());
        if (workInfo.isLineLoss()) {
            this.warnsHandler("1", "2001", workInfo);
        } else {
            this.warnsHandler("0", "2001", workInfo);
        }
        workInfo.setNoBattery(false);
        workInfo.setBatteryStatus(batteryStatus);
        workInfo.setInvDirection(invDirection);
        workInfo.setLineDirection(lineDirection);
        String qPRIn = handler.excuteCommand("PRI" + parallelKey, true);
        if (this.isEmpty(qPRIn)) {
            return;
        }
        String[] prin = qPRIn.split(GAP);
        String chargerSourcePriority = this.chargerSourceType.get(prin[3]);
        double maxChargingCurrent = VolUtil.parseDouble(prin[4]);
        double maxAcChargingCurrent = VolUtil.parseDouble(prin[5]);
        String outputModel = prin[6];
        processor.setOutputmode(VolUtil.parseInt(outputModel));
        ConfigData configdata = (ConfigData)processor.getBeanBag().getBean("configdata");
        if (processor instanceof ParallSubProcessor) {
            configdata.setSubOutputMode(processor.getSerialNo(), this.outputModelType.get(prin[6]));
            configdata.setChargerSourcePriority(processor.getSerialNo(), chargerSourcePriority);
            configdata.setMaxChargingCurrent(processor.getSerialNo(), maxChargingCurrent);
            configdata.setMaxAcChargingCurrent(processor.getSerialNo(), maxAcChargingCurrent);
        } else {
            configdata.setOutputModel(this.outputModelType.get(prin[6]));
            configdata.setChargerSourcePriority(chargerSourcePriority);
            configdata.setMaxChargingCurrent(maxChargingCurrent);
            configdata.setMaxAcChargingCurrent(maxAcChargingCurrent);
        }
        this.setFaults(workInfo, faultCode);
    }

    @Override
    public boolean queryCapability() {
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            this.pFLAG(capability, handler);
        }
        catch (Exception e) {
            logger.error((Object)("queryCapability Func -->" + e.getMessage()));
            return false;
        }
        return true;
    }

    private void pFLAG(Capability capability, IComUSBHandler handler) {
        String pFLAG = handler.excuteCommand("FLAG", true);
        if (this.isEmpty(pFLAG)) {
            return;
        }
        String[] flag = pFLAG.split(GAP);
        capability.setCapableA(flag[0].equals("0"));
        capability.setCapableB(flag[1].equals("1"));
        capability.setCapableC(flag[2].equals("1"));
        capability.setCapableD(flag[3].equals("1"));
        capability.setCapableE(flag[4].equals("1"));
        capability.setCapableF(flag[5].equals("1"));
        capability.setCapableG(flag[6].equals("1"));
        capability.setCapableH(flag[7].equals("1"));
    }

    @Override
    public boolean queryConfigData() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            this.pPIRI(handler, ACTION_QUERY_CONFIG_DATA);
            this.pMCHGCR(handler);
            this.pMUCHGCR(handler);
            this.pACCT(handler);
            this.pACLT(handler);
        }
        catch (Exception e) {
            logger.error((Object)("queryConfigData Func -->" + e.getMessage()));
            return false;
        }
        return true;
    }

    private void pMCHGCR(IComUSBHandler handler) {
        ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
        String pMCHGCR = handler.excuteCommand("MCHGCR", true);
        if (this.isEmpty(pMCHGCR)) {
            return;
        }
        String[] mchgcr = pMCHGCR.split(GAP);
        int i = 0;
        while (i < mchgcr.length) {
            mchgcr[i] = String.valueOf(VolUtil.parseDouble(mchgcr[i]));
            ++i;
        }
        configdata.setMaxChargingCurrentComBox(mchgcr);
    }

    private void pMUCHGCR(IComUSBHandler handler) {
        ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
        String pMUCHGCR = handler.excuteCommand("MUCHGCR", true);
        if (this.isEmpty(pMUCHGCR)) {
            return;
        }
        String[] muchgcr = pMUCHGCR.split(GAP);
        int i = 0;
        while (i < muchgcr.length) {
            muchgcr[i] = String.valueOf(VolUtil.parseDouble(muchgcr[i]));
            ++i;
        }
        configdata.setMaxAcChargingCurrentCombox(muchgcr);
    }

    private void pACCT(IComUSBHandler handler) {
        ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
        String pACCT = handler.excuteCommand("ACCT", true);
        if (this.isEmpty(pACCT)) {
            return;
        }
        String[] acct = pACCT.split(GAP);
        configdata.setAcChargeStarttime(acct[0]);
        configdata.setAcChargeEndtime(acct[1]);
    }

    private void pACLT(IComUSBHandler handler) {
        ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
        String pACLT = handler.excuteCommand("ACLT", true);
        if (this.isEmpty(pACLT)) {
            return;
        }
        String[] aclt = pACLT.split(GAP);
        configdata.setAcoutputStarttime(aclt[0]);
        configdata.setAcoutputEndtime(aclt[1]);
    }

    @Override
    public boolean queryDefaultData() {
        DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            this.pDI(defaultData, handler);
        }
        catch (Exception e) {
            logger.error((Object)("queryDefaultData Func -->" + e.getMessage()));
            return false;
        }
        return true;
    }

    private void pDI(DefaultData defaultData, IComUSBHandler handler) {
        String pDI = handler.excuteCommand("DI", true);
        if (this.isEmpty(pDI)) {
            return;
        }
        String[] di = pDI.split(GAP);
        double acOutputVoltage = VolUtil.parseDouble(di[0]) / 10.0;
        double acOutputFrequency = VolUtil.parseDouble(di[1]) / 10.0;
        String acInputVoltageRange = this.inputVoltageType.get(di[2]);
        double batteryUnderVoltage = VolUtil.parseDouble(di[3]) / 10.0;
        double batteryFloatVoltage = VolUtil.parseDouble(di[4]) / 10.0;
        double batteryBulkVoltage = VolUtil.parseDouble(di[5]) / 10.0;
        double batteryRechargeVoltage = VolUtil.parseDouble(di[6]) / 10.0;
        double batteryRedischargeVoltage = VolUtil.parseDouble(di[7]) / 10.0;
        double maxChargingCurrent = VolUtil.parseDouble(di[8]);
        double maxACChargingCurrent = VolUtil.parseDouble(di[9]);
        String batType = this.batteryType.get(di[10]);
        String outputSourcePriority = this.outputSourceType.get(di[11]);
        String chargerSourcePriority = this.chargerSourceType.get(di[12]);
        String solarPowerPriority = this.solarPriorityType.get(di[13]);
        String mchType = this.machineType.get(di[14]);
        String outputModel = this.outputModelType.get(di[15]);
        defaultData.setAcOutputVoltage(acOutputVoltage);
        defaultData.setAcOutputFrequency(acOutputFrequency);
        defaultData.setAcInputVoltageRange(acInputVoltageRange);
        defaultData.setBatteryUnderVoltage(batteryUnderVoltage);
        defaultData.setBatteryFloatVoltage(batteryFloatVoltage);
        defaultData.setBatteryBulkVoltage(batteryBulkVoltage);
        defaultData.setBatteryRechargeVoltage(batteryRechargeVoltage);
        defaultData.setBatteryRedischargeVoltage(batteryRedischargeVoltage);
        defaultData.setMaxChargingCurrent(maxChargingCurrent);
        defaultData.setMaxACChargingCurrent(maxACChargingCurrent);
        defaultData.setBatteryType(batType);
        defaultData.setOutputSourcePriority(outputSourcePriority);
        defaultData.setChargerSourcePriority(chargerSourcePriority);
        defaultData.setSolarPowerPriority(solarPowerPriority);
        defaultData.setMachineType(mchType);
        defaultData.setOutputModel(outputModel);
        defaultData.setCapableA(this.enable.get(di[16]));
        defaultData.setCapableD(this.enable.get(di[17]));
        defaultData.setCapableE(this.enable.get(di[18]));
        defaultData.setCapableF(this.enable.get(di[19]));
        defaultData.setCapableG(this.enable.get(di[20]));
        defaultData.setCapableH(this.enable.get(di[21]));
        defaultData.setCapableB(this.enable.get(di[22]));
        defaultData.setCapableC(this.enable.get(di[23]));
    }

    @Override
    public boolean queryMachineInfo() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        this.pVFW(handler);
        this.pPIRI(handler, ACTION_QUERY_MACHINE_INFO);
        return true;
    }

    private void pVFW(IComUSBHandler handler) {
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        String pVFW = handler.excuteCommand("VFW", true);
        if (this.isEmpty(pVFW)) {
            return;
        }
        String[] version = pVFW.split(GAP);
        machineInfo.setMainFirmwareVersion(version[0]);
        machineInfo.setSlaveFirmwareVersion1(version[1]);
        machineInfo.setSlaveFirmwareVersion2(version[2]);
    }

    private void pPIRI(IComUSBHandler handler, String action) {
        String pPIRI = handler.excuteCommand("PIRI", true);
        if (this.isEmpty(pPIRI)) {
            return;
        }
        String[] piri = pPIRI.split(GAP);
        double acInputRatingVoltage = VolUtil.parseDouble(piri[0]) / 10.0;
        double acInputRatingCurrent = VolUtil.parseDouble(piri[1]) / 10.0;
        double acOutputRatingVoltage = VolUtil.parseDouble(piri[2]) / 10.0;
        double acOutputRatingFrequency = VolUtil.parseDouble(piri[3]) / 10.0;
        double acOutputRatingCurrent = VolUtil.parseDouble(piri[4]) / 10.0;
        int acOutputRatingApparentPower = VolUtil.parseInt(piri[5]);
        int acOutputRatingActivePower = VolUtil.parseInt(piri[6]);
        double batteryRatingVoltage = VolUtil.parseDouble(piri[7]) / 10.0;
        double batteryRechargeVoltage = VolUtil.parseDouble(piri[8]) / 10.0;
        double batteryRedischargeVoltage = VolUtil.parseDouble(piri[9]) / 10.0;
        double batteryUnderVoltage = VolUtil.parseDouble(piri[10]) / 10.0;
        double batteryBulkVoltage = VolUtil.parseDouble(piri[11]) / 10.0;
        double batteryFloatVoltage = VolUtil.parseDouble(piri[12]) / 10.0;
        String batType = this.batteryType.get(piri[13]);
        double maxACChargingCurrent = VolUtil.parseDouble(piri[14]);
        double maxChargingCurrent = VolUtil.parseDouble(piri[15]);
        String inputVoltageRange = this.inputVoltageType.get(piri[16]);
        String outputSourcePriority = this.outputSourceType.get(piri[17]);
        String chargerSourcePriority = this.chargerSourceType.get(piri[18]);
        int maxParallelNum = VolUtil.parseInt(piri[19]);
        String mchType = this.machineType.get(piri[20]);
        String topology = this.topologyType.get(piri[21]);
        String outputModelSetting = this.outputModelType.get(piri[22]);
        String solarPowerPriority = this.solarPriorityType.get(piri[23]);
        int mpptTrackNumber = VolUtil.parseInt(piri[24]);
        String regulationsState = "India";
        try {
            regulationsState = this.regulationType.get(piri[25]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int outputmode = VolUtil.parseInt(piri[22]);
        this._protocol.setOutputMode(outputmode);
        this._outputmode = outputmode;
        if (outputmode != 0) {
            this._paralleltype = 1;
            this._parallelnum = VolUtil.parseInt(piri[19]);
        } else {
            this._paralleltype = 0;
        }
        if (action.equals(ACTION_QUERY_MACHINE_INFO)) {
            MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
            machineInfo.setAcInputRatingVoltage(acInputRatingVoltage);
            machineInfo.setAcInputRatingCurrent(acInputRatingCurrent);
            machineInfo.setAcOutputRatingVoltage(acOutputRatingVoltage);
            machineInfo.setAcOutputRatingFrequency(acOutputRatingFrequency);
            machineInfo.setAcOutputRatingCurrent(acOutputRatingCurrent);
            machineInfo.setAcOutputRatingApparentPower(acOutputRatingApparentPower);
            machineInfo.setAcOutputRatingActivePower(acOutputRatingActivePower);
            machineInfo.setBatteryRatingVoltage(batteryRatingVoltage);
            machineInfo.setMachineType(mchType);
            machineInfo.setTopology(topology);
            machineInfo.setBatteryRechargeVoltage(batteryRechargeVoltage);
            machineInfo.setBatteryRedischargeVoltage(batteryRedischargeVoltage);
            machineInfo.setBatteryUnderVoltage(batteryUnderVoltage);
            machineInfo.setBatteryBulkVoltage(batteryBulkVoltage);
            machineInfo.setBatteryFloatVoltage(batteryFloatVoltage);
            machineInfo.setBatteryType(batType);
            machineInfo.setMaxACChargingCurrent(maxACChargingCurrent);
            machineInfo.setMaxChargingCurrent(maxChargingCurrent);
            machineInfo.setInputVoltageRange(inputVoltageRange);
            machineInfo.setOutputSourcePriority(outputSourcePriority);
            machineInfo.setChargerSourcePriority(chargerSourcePriority);
            machineInfo.setMaxParallelNum(maxParallelNum);
            machineInfo.setOutputModel(outputModelSetting);
            machineInfo.setSolarPowerPriority(solarPowerPriority);
            machineInfo.setMpptTrackNumber(mpptTrackNumber);
        } else if (action.equals(ACTION_QUERY_CONFIG_DATA)) {
            ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
            Capability capability = (Capability)this.getBeanBag().getBean("capability");
            configdata.setAcOutputRatingVoltage(acOutputRatingVoltage);
            configdata.setAcOutputRatingFrequency(acOutputRatingFrequency);
            configdata.setBatteryRatingVoltage(batteryRatingVoltage);
            configdata.setBatteryRechargeVoltage(batteryRechargeVoltage);
            configdata.setBatteryRedischargeVoltage(batteryRedischargeVoltage);
            configdata.setBatteryUnderVoltage(batteryUnderVoltage);
            configdata.setBatteryBulkVoltage(batteryBulkVoltage);
            configdata.setBatteryFloatVoltage(batteryFloatVoltage);
            if (configdata.getBatteryRatingVoltage() > 40.0) {
                configdata.setMinBatteryUnderVoltage(40.0);
                configdata.setMaxBatteryUnderVoltage(48.01);
                configdata.setMinBatteryBulkVoltage(48.0);
                configdata.setMaxBatteryBulkVoltage(58.41);
                configdata.setMinBatteryFloatVoltage(48.0);
                configdata.setMaxBatteryFloatVoltage(58.41);
            } else if (configdata.getBatteryRatingVoltage() > 20.0) {
                configdata.setMinBatteryUnderVoltage(20.0);
                configdata.setMaxBatteryUnderVoltage(24.01);
                configdata.setMinBatteryBulkVoltage(24.0);
                configdata.setMaxBatteryBulkVoltage(29.21);
                configdata.setMinBatteryFloatVoltage(24.0);
                configdata.setMaxBatteryFloatVoltage(29.21);
            } else {
                configdata.setMinBatteryUnderVoltage(10.2);
                configdata.setMaxBatteryUnderVoltage(12.01);
                configdata.setMinBatteryBulkVoltage(12.0);
                configdata.setMaxBatteryBulkVoltage(14.61);
                configdata.setMinBatteryFloatVoltage(12.0);
                configdata.setMaxBatteryFloatVoltage(14.61);
            }
            configdata.setBatteryType(batType);
            configdata.setMaxAcChargingCurrent(maxACChargingCurrent);
            configdata.setMaxChargingCurrent(maxChargingCurrent);
            configdata.setInputVoltageRange(inputVoltageRange);
            configdata.setOutputSourcePriority(outputSourcePriority);
            configdata.setChargerSourcePriority(chargerSourcePriority);
            configdata.setOutputModel(outputModelSetting);
            configdata.setSolarPowerPriority(solarPowerPriority);
            capability.setCapableI(piri[20].equals("1"));
            configdata.setRegulationsState(regulationsState);
        }
    }

    @Override
    public Calendar queryCurrentTime() {
        Calendar cal = null;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        String pT = handler.excuteCommand("T", true);
        if (this.isEmpty(pT)) {
            return cal;
        }
        if (pT.trim().length() != 14) {
            return cal;
        }
        Date date = DateUtils.parseDate(pT, "yyyyMMddHHmmss");
        if (date != null) {
            cal = Calendar.getInstance();
            cal.setTime(date);
        }
        return cal;
    }

    @Override
    public void querySelfTestResult() {
    }

    @Override
    public boolean supportSelfTest() {
        return false;
    }

    @Override
    public boolean queryDeviceModel() {
        return false;
    }

    @Override
    public void queryEnergyBeginDate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyDay(Calendar trandate) throws Exception {
        Object object = this.query_day;
        synchronized (object) {
            double energyDay = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("queryEnergyDay handler is null...");
            }
            Calendar calendar = (Calendar)trandate.clone();
            String value = DateUtils.getFormatDate(calendar.getTime(), "yyyyMMdd");
            String qedStr = handler.excuteCommand("ED" + value, true);
            if (qedStr == null || "".equals(qedStr) || qedStr.equals("(NAK")) {
                throw new Exception("query day energy error");
            }
            energyDay = this.parseDoubleV(qedStr);
            return energyDay;
        }
    }

    @Override
    public double queryEnergyHour(Calendar trandate, int hour) throws Exception {
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyMonth(int year, int month) throws Exception {
        Object object = this.query_month;
        synchronized (object) {
            double energyMonth = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("queryEnergyMonth handler is null");
            }
            String monthStr = String.valueOf(month).length() < 2 ? "0" + month : String.valueOf(month);
            String value = year + monthStr;
            String qemStr = handler.excuteCommand("EM" + value, true);
            if (qemStr == null || "".equals(qemStr) || qemStr.equals("(NAK")) {
                throw new Exception("query month energy error");
            }
            energyMonth = this.parseDoubleV(qemStr);
            return energyMonth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyYear(int year) throws Exception {
        Object object = this.query_year;
        synchronized (object) {
            double energyYear = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("queryEnergyYear handler is null");
            }
            String value = "" + year;
            String qeyStr = handler.excuteCommand("EY" + value, true);
            if (qeyStr == null || "".equals(qeyStr) || qeyStr.equals("(NAK")) {
                throw new Exception("query year energy error");
            }
            energyYear = this.parseDoubleV(qeyStr);
            return energyYear;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyTotal() {
        Object object = this.query_tatal;
        synchronized (object) {
            double energyTotal = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                return energyTotal;
            }
            String qetStr = handler.excuteCommand("ET", true);
            energyTotal = !this.isEmpty(qetStr) ? VolUtil.parseDouble(qetStr) : 0.0;
            return energyTotal;
        }
    }

    @Override
    public float queryFWVersion() {
        return 0.0f;
    }
}

