/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.debug;

import cn.com.voltronic.solar.util.DateUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;

public class Debug {
    public static boolean DEBUG_JIAYI = false;
    public static boolean isDebug = false;
    public static final String URL = String.valueOf(System.getProperty("user.dir")) + File.separator + "log" + File.separator + "debug";

    static {
        File f = new File(URL);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setDebug(boolean isDebug) {
        Debug.isDebug = isDebug;
    }

    public static synchronized void debug(String filename, String message) {
        if (isDebug) {
            Debug.saveData(filename, message);
        }
    }

    public static synchronized void saveData(String filename, String message) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            try {
                File file;
                String command = filename;
                String nowDateString = DateUtils.getNowDate("yyyy-MM-dd");
                filename = String.valueOf(nowDateString) + " " + filename + ".log";
                if (command.startsWith("EH") || command.startsWith("ED")) {
                    filename = String.valueOf(nowDateString) + " " + "EH_ED.log";
                }
                if (!(file = new File(String.valueOf(URL) + File.separator + filename)).exists()) {
                    file.createNewFile();
                }
                fos = new FileOutputStream(file, true);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                bw = new BufferedWriter(osw);
                String nowTime = DateUtils.getFormatTimestamp(new Date());
                if (command.startsWith("EH") || command.startsWith("ED")) {
                    bw.write("[" + nowTime + "][" + command + "]" + message);
                } else {
                    bw.write("[" + nowTime + "]" + message);
                }
                bw.newLine();
                bw.flush();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

