/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.configure.CustomerConfig;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.protocol.P15;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.CRCUtil;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class P20
extends P15 {
    private String dspversion = "";
    private String mcuversion = "";

    @Override
    public String getProtocolID() {
        return "P20";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (!(handler instanceof IComUSBHandler)) {
            return false;
        }
        IComUSBHandler _handler = (IComUSBHandler)handler;
        String dataStr = "(NAK";
        int i = 0;
        while (i < 3) {
            if (!dataStr.equals("(NAK")) break;
            try {
                dataStr = _handler.excuteSimpleCommand("QPI");
                if (dataStr.length() > 5) {
                    if (CRCUtil.checkCRC(dataStr)) {
                        dataStr = dataStr.substring(0, dataStr.length() - 2);
                        _handler.setCrcCheck(true);
                    } else {
                        dataStr = "(NAK";
                        _handler.setCrcCheck(false);
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        if (dataStr.startsWith("(PI")) {
            if (!dataStr.endsWith("20")) {
                return false;
            }
            this.serialNo = _handler.getSerialNo();
            if (this.serialNo.isEmpty()) {
                return false;
            }
            this.mpptTrackNumber = _handler.getMpptTrackNumber();
            this.modelType = _handler.getModeType();
            this.deviceModel = _handler.getDeviceModel();
            this.modelName = _handler.getModelName();
            dataStr = "";
            i = 0;
            while (i < 5 && (StringUtils.isEmpty((String)dataStr) || dataStr.startsWith("(NAK") || dataStr.indexOf("MCU:") < 0 || dataStr.indexOf("DSP:") < 0)) {
                dataStr = _handler.excuteSimpleCommand("I");
                int index = dataStr.indexOf("DSP:");
                if (index > 0) {
                    this.dspversion = dataStr.substring(index + 4, index + 4 + 8);
                    index = dataStr.indexOf("MCU:");
                    this.mcuversion = dataStr.substring(index + 4, index + 4 + 8);
                } else {
                    dataStr = "";
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.gridVoltageR[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.gridFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        if (this.mpptTrackNumber == 1) {
            item.add(new AutoLabelItem("message.pvInputVoltage[:]", "{workInfo.getPvInputVoltage1}", "V"));
        } else {
            item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
        }
        if (this.mpptTrackNumber >= 2) {
            item.add(new AutoLabelItem("message.pvInputVoltage2[:]", "{workInfo.getPvInputVoltage2}", "V"));
        }
        if (this.mpptTrackNumber == 3) {
            item.add(new AutoLabelItem("message.pvInputVoltage3[:]", "{workInfo.getPvInputVoltage3}", "V"));
        }
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.setPVIPLV[:]", "{configData.getMinPvInputLowV}", "{configData.getMaxPvInputLowV}", "1", "{configData.getPvInputLowV}", "V", "setPVIPLV", 0, false));
        list.add(new AutoSpinnerItem("message.setPVIPHV[:]", "{configData.getMinPvInputHighV}", "{configData.getMaxPvInputHighV}", "1", "{configData.getPvInputHighV}", "V", "setPVIPHV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTLV[:]", "{configData.getMinMpptLowV}", "{configData.getMaxMpptLowV}", "1", "{configData.getMpptLowV}", "V", "setMPPTLV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTHV[:]", "{configData.getMinMpptHighV}", "{configData.getMaxMpptHighV}", "1", "{configData.getMpptHighV}", "V", "setMPPTHV", 0, false));
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.pepdP[:]", "message.enable", "message.disable", "{cappbility.isCapableP}", "CapableP", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.gridVoltageR", "{workInfo.getGridVoltageR}", true, false));
        list.add(new HistoryData("message.gridPowerR", "{workInfo.getGridPowerR}", true, false));
        list.add(new HistoryData("message.gridFrequency", "{workInfo.getGridFrequency}", true, true));
        if (this.mpptTrackNumber == 1) {
            list.add(new HistoryData("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", true, true));
        } else {
            list.add(new HistoryData("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", true, true));
        }
        if (this.mpptTrackNumber >= 2) {
            list.add(new HistoryData("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", true, true));
        }
        if (this.mpptTrackNumber == 3) {
            list.add(new HistoryData("message.pvInputVoltage3", "{workInfo.getPvInputVoltage3}", true, true));
        }
        list.add(new HistoryData("message.temperature", "{workInfo.getMaxTemperature}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{faultData.getGridVoltage}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{faultData.getGridFrequency}", true, true));
        if (this.mpptTrackNumber == 1) {
            list.add(new HistoryData("message.pvInputVoltage", "{faultData.getPvinputvoltage1}", true, true));
            list.add(new HistoryData("message.pvInputCurrent", "{faultData.getPvinputcurrent1}", true, true));
        } else {
            list.add(new HistoryData("message.pvInputVoltage1", "{faultData.getPvinputvoltage1}", true, true));
            list.add(new HistoryData("message.pvInputCurrent1", "{faultData.getPvinputcurrent1}", true, true));
        }
        if (this.mpptTrackNumber >= 2) {
            list.add(new HistoryData("message.pvInputVoltage2", "{faultData.getPvinputvoltage2}", true, true));
            list.add(new HistoryData("message.pvInputCurrent2", "{faultData.getPvinputcurrent2}", true, true));
        }
        if (this.mpptTrackNumber == 3) {
            list.add(new HistoryData("message.pvInputVoltage3", "{faultData.getPvinputvoltage3}", true, true));
            list.add(new HistoryData("message.pvInputCurrent3", "{faultData.getPvinputcurrent3}", true, true));
        }
        list.add(new HistoryData("message.temperature", "{faultData.getMaxTemperature}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.gridVoltageR", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.gridPowerR", "{workInfo.getGridPowerR}", 3000.0, "W", true));
        list.add(new HistoryChart("message.gridFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        if (this.mpptTrackNumber == 1) {
            list.add(new HistoryChart("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", 500.0, "V", true));
        } else {
            list.add(new HistoryChart("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", 500.0, "V", true));
        }
        if (this.mpptTrackNumber >= 2) {
            list.add(new HistoryChart("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", 500.0, "V", true));
        }
        if (this.mpptTrackNumber == 3) {
            list.add(new HistoryChart("message.pvInputVoltage3", "{workInfo.getPvInputVoltage3}", 500.0, "V", true));
        }
        list.add(new HistoryChart("message.temperature", "{workInfo.getMaxTemperature}", 180.0, "Degree", true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electrovalenceSet", 103, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.synchroEnergyData", 203, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryPower", 301, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryFaultData", 303, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.monitorPointInfo", 305, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.powerNumber", 306, ""), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Italian", 404, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", 406, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Russian", 407, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", 409, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Turkish", 410, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Japanese", 413, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        ArrayList<AutoMenuItem> items = new ArrayList<AutoMenuItem>();
        CustomerConfig custormerConfig = GlobalVariables.customerConfig;
        if (custormerConfig.isEnglish()) {
            items.add(new AutoMenuItem("English", 5021, ""));
        }
        if (custormerConfig.isTurkish()) {
            items.add(new AutoMenuItem("Turkish", 5022, ""));
        }
        if (custormerConfig.isRussian()) {
            items.add(new AutoMenuItem("Russian", 5023, ""));
        }
        if (items.size() < 2) {
            items = null;
        }
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), items));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }

    @Override
    public String getDSPVersion() {
        return this.dspversion;
    }

    @Override
    public String getMCUVersion() {
        return this.mcuversion;
    }
}

