/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class BeanFactoryUtils {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean isFactoryDereference(String string) {
        return string != null && string.startsWith("&");
    }

    public static String transformedBeanName(String string) {
        Assert.notNull((Object)string, (String)"'name' must not be null");
        String string2 = string;
        while (string2.startsWith("&")) {
            string2 = string2.substring("&".length());
        }
        return string2;
    }

    public static String originalBeanName(String string) {
        Assert.notNull((Object)string, (String)"'name' must not be null");
        int n = string.indexOf(GENERATED_BEAN_NAME_SEPARATOR);
        return n != -1 ? string.substring(0, n) : string;
    }

    public static int countBeansIncludingAncestors(ListableBeanFactory listableBeanFactory) {
        return BeanFactoryUtils.beanNamesIncludingAncestors(listableBeanFactory).length;
    }

    public static String[] beanNamesIncludingAncestors(ListableBeanFactory listableBeanFactory) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors(listableBeanFactory, class$java$lang$Object == null ? (class$java$lang$Object = BeanFactoryUtils.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory listableBeanFactory, Class clazz) {
        HierarchicalBeanFactory hierarchicalBeanFactory;
        Assert.notNull((Object)listableBeanFactory, (String)"ListableBeanFactory must not be null");
        String[] stringArray = listableBeanFactory.getBeanNamesForType(clazz);
        if (listableBeanFactory instanceof HierarchicalBeanFactory && (hierarchicalBeanFactory = (HierarchicalBeanFactory)((Object)listableBeanFactory)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] stringArray2 = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hierarchicalBeanFactory.getParentBeanFactory(), clazz);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(stringArray));
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = stringArray2[i];
                if (arrayList.contains(string) || hierarchicalBeanFactory.containsLocalBean(string)) continue;
                arrayList.add(string);
            }
            stringArray = StringUtils.toStringArray(arrayList);
        }
        return stringArray;
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory listableBeanFactory, Class clazz, boolean bl, boolean bl2) {
        HierarchicalBeanFactory hierarchicalBeanFactory;
        Assert.notNull((Object)listableBeanFactory, (String)"ListableBeanFactory must not be null");
        String[] stringArray = listableBeanFactory.getBeanNamesForType(clazz, bl, bl2);
        if (listableBeanFactory instanceof HierarchicalBeanFactory && (hierarchicalBeanFactory = (HierarchicalBeanFactory)((Object)listableBeanFactory)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] stringArray2 = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hierarchicalBeanFactory.getParentBeanFactory(), clazz, bl, bl2);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(stringArray));
            for (int i = 0; i < stringArray2.length; ++i) {
                String string = stringArray2[i];
                if (arrayList.contains(string) || hierarchicalBeanFactory.containsLocalBean(string)) continue;
                arrayList.add(string);
            }
            stringArray = StringUtils.toStringArray(arrayList);
        }
        return stringArray;
    }

    public static Map beansOfTypeIncludingAncestors(ListableBeanFactory listableBeanFactory, Class clazz) throws BeansException {
        HierarchicalBeanFactory hierarchicalBeanFactory;
        Assert.notNull((Object)listableBeanFactory, (String)"ListableBeanFactory must not be null");
        HashMap hashMap = new HashMap();
        hashMap.putAll(listableBeanFactory.getBeansOfType(clazz));
        if (listableBeanFactory instanceof HierarchicalBeanFactory && (hierarchicalBeanFactory = (HierarchicalBeanFactory)((Object)listableBeanFactory)).getParentBeanFactory() instanceof ListableBeanFactory) {
            Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hierarchicalBeanFactory.getParentBeanFactory(), clazz);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (hashMap.containsKey(string) || hierarchicalBeanFactory.containsLocalBean(string)) continue;
                hashMap.put(string, entry.getValue());
            }
        }
        return hashMap;
    }

    public static Map beansOfTypeIncludingAncestors(ListableBeanFactory listableBeanFactory, Class clazz, boolean bl, boolean bl2) throws BeansException {
        HierarchicalBeanFactory hierarchicalBeanFactory;
        Assert.notNull((Object)listableBeanFactory, (String)"ListableBeanFactory must not be null");
        HashMap hashMap = new HashMap();
        hashMap.putAll(listableBeanFactory.getBeansOfType(clazz, bl, bl2));
        if (listableBeanFactory instanceof HierarchicalBeanFactory && (hierarchicalBeanFactory = (HierarchicalBeanFactory)((Object)listableBeanFactory)).getParentBeanFactory() instanceof ListableBeanFactory) {
            Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hierarchicalBeanFactory.getParentBeanFactory(), clazz, bl, bl2);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (hashMap.containsKey(string) || hierarchicalBeanFactory.containsLocalBean(string)) continue;
                hashMap.put(string, entry.getValue());
            }
        }
        return hashMap;
    }

    public static Object beanOfTypeIncludingAncestors(ListableBeanFactory listableBeanFactory, Class clazz) throws BeansException {
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors(listableBeanFactory, clazz);
        if (map.size() == 1) {
            return map.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(clazz, "expected single bean but found " + map.size());
    }

    public static Object beanOfTypeIncludingAncestors(ListableBeanFactory listableBeanFactory, Class clazz, boolean bl, boolean bl2) throws BeansException {
        Map map = BeanFactoryUtils.beansOfTypeIncludingAncestors(listableBeanFactory, clazz, bl, bl2);
        if (map.size() == 1) {
            return map.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(clazz, "expected single bean but found " + map.size());
    }

    public static Object beanOfType(ListableBeanFactory listableBeanFactory, Class clazz) throws BeansException {
        Assert.notNull((Object)listableBeanFactory, (String)"ListableBeanFactory must not be null");
        Map map = listableBeanFactory.getBeansOfType(clazz);
        if (map.size() == 1) {
            return map.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(clazz, "expected single bean but found " + map.size());
    }

    public static Object beanOfType(ListableBeanFactory listableBeanFactory, Class clazz, boolean bl, boolean bl2) throws BeansException {
        Assert.notNull((Object)listableBeanFactory, (String)"ListableBeanFactory must not be null");
        Map map = listableBeanFactory.getBeansOfType(clazz, bl, bl2);
        if (map.size() == 1) {
            return map.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(clazz, "expected single bean but found " + map.size());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

