/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.factory.config.BeanReference;
import org.springframework.util.Assert;

public class RuntimeBeanReference
implements BeanReference {
    private final String beanName;
    private final boolean toParent;
    private Object source;

    public RuntimeBeanReference(String string) {
        this(string, false);
    }

    public RuntimeBeanReference(String string, boolean bl) {
        Assert.hasText((String)string, (String)"'beanName' must not be empty");
        this.beanName = string;
        this.toParent = bl;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean isToParent() {
        return this.toParent;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RuntimeBeanReference)) {
            return false;
        }
        RuntimeBeanReference runtimeBeanReference = (RuntimeBeanReference)object;
        return this.beanName.equals(runtimeBeanReference.beanName) && this.toParent == runtimeBeanReference.toParent;
    }

    public int hashCode() {
        int n = this.beanName.hashCode();
        n = 29 * n + (this.toParent ? 1 : 0);
        return n;
    }

    public String toString() {
        return '<' + this.getBeanName() + '>';
    }
}

