/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.plugins.communicate.tool;

import cn.com.voltronic.plugins.communicate.tool.CRCUtil;
import cn.com.voltronic.plugins.communicate.tool.CommunicateException;
import cn.com.voltronic.plugins.communicate.tool.CommunicateHandler;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPortHandler
extends CommunicateHandler {
    private CommPortIdentifier portId;
    private InputStream input = null;
    private OutputStream output = null;
    private SerialPort serialPort;

    public SerialPortHandler(CommPortIdentifier portId, SerialPort serialPort) throws IOException {
        try {
            serialPort.enableReceiveTimeout(1200);
        }
        catch (UnsupportedCommOperationException e) {
            e.printStackTrace();
        }
        this.portId = portId;
        this.serialPort = serialPort;
        this.input = serialPort.getInputStream();
        this.output = serialPort.getOutputStream();
    }

    @Override
    public synchronized String excuteSimpleCommand(String command, boolean isCRC) throws IOException {
        this.clearbuffer();
        byte[] crc = CRCUtil.getCRCByte(command);
        byte[] bytes = command.getBytes();
        this.output.write(bytes);
        if (isCRC) {
            this.output.write(crc);
        }
        this.output.write(13);
        this.output.flush();
        long end = System.currentTimeMillis() + 1000L;
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        while (System.currentTimeMillis() < end) {
            int ch = this.input.read();
            if (ch < 0) continue;
            if (ch != 13) {
                sb.append((char)ch);
                continue;
            }
            flag = true;
            break;
        }
        if (!flag) {
            throw new IOException();
        }
        String returnValue = sb.toString();
        return returnValue;
    }

    private void clearbuffer() {
        try {
            int buflen = this.input.available();
            while (buflen > 0) {
                this.input.read();
                --buflen;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String excuteCommand(String command, boolean isResponse, boolean isCRC) throws CommunicateException {
        try {
            this.clearbuffer();
            byte[] crc = CRCUtil.getCRCByte(command);
            byte[] bytes = command.getBytes();
            this.output.write(bytes);
            if (isCRC) {
                this.output.write(crc);
            }
            this.output.write(13);
            this.output.flush();
            if (isResponse) {
                long end = System.currentTimeMillis() + 3000L;
                StringBuilder sb = new StringBuilder();
                boolean flag = false;
                while (System.currentTimeMillis() < end) {
                    int ch = this.input.read();
                    if (ch < 0) continue;
                    if (ch != 13) {
                        sb.append((char)ch);
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (!flag) {
                    throw new CommunicateException("Communication time out");
                }
                String returnValue = sb.toString();
                return returnValue;
            }
            return null;
        }
        catch (IOException e) {
            throw new CommunicateException("Communication exception:" + e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serialPort != null) {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDeviceName() {
        String portName = this.portId.getName();
        int index = portName.lastIndexOf("/");
        if (index > 0) {
            portName = portName.substring(index + 1, portName.length());
        }
        return portName;
    }
}

