/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.java;

import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.MetadataParserImpl;
import java.io.IOException;
import java.util.Arrays;

public class ID3MetadataParser
extends MetadataParserImpl {
    private static final int ID3_VERSION_MIN = 2;
    private static final int ID3_VERSION_MAX = 4;
    private int COMMCount = 0;
    private int TXXXCount = 0;
    private int version = 3;
    private boolean unsynchronized = false;

    public ID3MetadataParser(Locator locator) {
        super(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse() {
        block32: {
            try {
                byte[] buf = this.getBytes(10);
                this.version = buf[3] & 0xFF;
                if (buf[0] != 73 || buf[1] != 68 || buf[2] != 51 || this.version < 2 || this.version > 4) break block32;
                int flags = buf[5] & 0xFF;
                if ((flags & 0x80) == 128) {
                    this.unsynchronized = true;
                }
                int tagSize = 0;
                int shift = 21;
                for (int i = 6; i < 10; ++i) {
                    tagSize += (buf[i] & 0x7F) << shift;
                    shift -= 7;
                }
                this.startRawMetadata(tagSize + 10);
                this.stuffRawMetadata(buf, 0, 10);
                this.readRawMetadata(tagSize);
                this.setParseRawMetadata(true);
                this.skipBytes(10);
                while (this.getStreamPosition() < tagSize) {
                    String value;
                    byte[] data;
                    String encoding;
                    String frameID = "";
                    int frameSize = 0;
                    byte[] idBytes = null;
                    if (2 == this.version) {
                        idBytes = this.getBytes(3);
                        frameSize = this.getU24();
                    } else {
                        idBytes = this.getBytes(4);
                        frameSize = this.getFrameSize();
                        this.skipBytes(2);
                    }
                    if (0 == idBytes[0]) {
                        if (Logger.canLog(1)) {
                            Logger.logMsg(1, "ID3MetadataParser", "parse", "ID3 parser: zero padding detected at " + this.getStreamPosition() + ", terminating");
                        }
                        break;
                    }
                    frameID = new String(idBytes);
                    if (Logger.canLog(1)) {
                        Logger.logMsg(1, "ID3MetadataParser", "parse", this.getStreamPosition() + "\\" + tagSize + ": frame ID " + frameID + ", size " + frameSize);
                    }
                    if (frameID.equals("APIC") || frameID.equals("PIC")) {
                        byte[] data2 = this.getBytes(frameSize);
                        if (this.unsynchronized) {
                            data2 = this.unsynchronizeBuffer(data2);
                        }
                        byte[] image = null;
                        image = frameID.equals("PIC") ? this.getImageFromPIC(data2) : this.getImageFromAPIC(data2);
                        if (image == null) continue;
                        this.addMetadataItem("image", image);
                        continue;
                    }
                    if (frameID.startsWith("T") && !frameID.equals("TXXX")) {
                        encoding = this.getEncoding();
                        data = this.getBytes(frameSize - 1);
                        if (this.unsynchronized) {
                            data = this.unsynchronizeBuffer(data);
                        }
                        value = new String(data, encoding);
                        String[] tag = this.getTagFromFrameID(frameID);
                        if (tag == null) continue;
                        for (int i = 0; i < tag.length; ++i) {
                            Object tagValue = this.convertValue(tag[i], value);
                            if (tagValue == null) continue;
                            this.addMetadataItem(tag[i], tagValue);
                        }
                        continue;
                    }
                    if (frameID.equals("COMM") || frameID.equals("COM")) {
                        String[] tag;
                        String value2;
                        encoding = this.getEncoding();
                        data = this.getBytes(3);
                        if (this.unsynchronized) {
                            data = this.unsynchronizeBuffer(data);
                        }
                        String language = new String(data);
                        data = this.getBytes(frameSize - 4);
                        if (this.unsynchronized) {
                            data = this.unsynchronizeBuffer(data);
                        }
                        if ((value2 = new String(data, encoding)) == null) continue;
                        int index = value2.indexOf(0);
                        String content = "";
                        String comment = "";
                        if (index == 0) {
                            comment = encoding.equals("UTF-16") ? value2.substring(2) : value2.substring(1);
                        } else {
                            content = value2.substring(0, index);
                            comment = encoding.equals("UTF-16") ? value2.substring(index + 2) : value2.substring(index + 1);
                        }
                        if ((tag = this.getTagFromFrameID(frameID)) == null) continue;
                        for (int i = 0; i < tag.length; ++i) {
                            this.addMetadataItem(tag[i] + "-" + this.COMMCount, content + "[" + language + "]=" + comment);
                            ++this.COMMCount;
                        }
                        continue;
                    }
                    if (frameID.equals("TXX") || frameID.equals("TXXX")) {
                        encoding = this.getEncoding();
                        data = this.getBytes(frameSize - 1);
                        if (this.unsynchronized) {
                            data = this.unsynchronizeBuffer(data);
                        }
                        if (null == (value = new String(data, encoding))) continue;
                        int index = value.indexOf(0);
                        String description = "";
                        String text = "";
                        if (index != 0) {
                            description = value.substring(0, index);
                        }
                        text = encoding.equals("UTF-16") ? value.substring(index + 2) : value.substring(index + 1);
                        String[] tag = this.getTagFromFrameID(frameID);
                        if (tag == null) continue;
                        for (int i = 0; i < tag.length; ++i) {
                            if (description.equals("")) {
                                this.addMetadataItem(tag[i] + "-" + this.TXXXCount, text);
                            } else {
                                this.addMetadataItem(tag[i] + "-" + this.TXXXCount, description + "=" + text);
                            }
                            ++this.TXXXCount;
                        }
                        continue;
                    }
                    this.skipBytes(frameSize);
                }
            }
            catch (Exception ex) {
                if (Logger.canLog(3)) {
                    Logger.logMsg(3, "ID3MetadataParser", "parse", "Exception while processing ID3v2 metadata: " + ex);
                }
            }
            finally {
                if (null != this.rawMetaBlob) {
                    this.setParseRawMetadata(false);
                    this.addRawMetadata("ID3");
                    this.disposeRawMetadata();
                }
                this.done();
            }
        }
    }

    private int getFrameSize() throws IOException {
        if (this.version == 4) {
            byte[] buf = this.getBytes(4);
            int size = 0;
            int shift = 21;
            for (int i = 0; i < 4; ++i) {
                size += (buf[i] & 0x7F) << shift;
                shift -= 7;
            }
            return size;
        }
        return this.getInteger();
    }

    private String getEncoding() throws IOException {
        byte encodingType = this.getNextByte();
        if (encodingType == 0) {
            return "ISO-8859-1";
        }
        if (encodingType == 1) {
            return "UTF-16";
        }
        if (encodingType == 2) {
            return "UTF-16BE";
        }
        if (encodingType == 3) {
            return "UTF-8";
        }
        throw new IllegalArgumentException();
    }

    private String[] getTagFromFrameID(String frameID) {
        if (frameID.equals("TPE2") || frameID.equals("TP2")) {
            return new String[]{"album artist"};
        }
        if (frameID.equals("TALB") || frameID.equals("TAL")) {
            return new String[]{"album"};
        }
        if (frameID.equals("TPE1") || frameID.equals("TP1")) {
            return new String[]{"artist"};
        }
        if (frameID.equals("COMM") || frameID.equals("COM")) {
            return new String[]{"comment"};
        }
        if (frameID.equals("TCOM") || frameID.equals("TCM")) {
            return new String[]{"composer"};
        }
        if (frameID.equals("TLEN") || frameID.equals("TLE")) {
            return new String[]{"duration"};
        }
        if (frameID.equals("TCON") || frameID.equals("TCO")) {
            return new String[]{"genre"};
        }
        if (frameID.equals("TIT2") || frameID.equals("TT2")) {
            return new String[]{"title"};
        }
        if (frameID.equals("TRCK") || frameID.equals("TRK")) {
            return new String[]{"track number", "track count"};
        }
        if (frameID.equals("TPOS") || frameID.equals("TPA")) {
            return new String[]{"disc number", "disc count"};
        }
        if (frameID.equals("TYER") || frameID.equals("TDRC")) {
            return new String[]{"year"};
        }
        if (frameID.equals("TXX") || frameID.equals("TXXX")) {
            return new String[]{"text"};
        }
        return null;
    }

    private byte[] getImageFromPIC(byte[] data) {
        int imgOffset;
        for (imgOffset = 5; 0 != data[imgOffset] && imgOffset < data.length; ++imgOffset) {
        }
        if (imgOffset == data.length) {
            return null;
        }
        String type = new String(data, 1, 3);
        if (Logger.canLog(1)) {
            Logger.logMsg(1, "ID3MetadataParser", "getImageFromPIC", "PIC type: " + type);
        }
        if (type.equalsIgnoreCase("PNG") || type.equalsIgnoreCase("JPG")) {
            return Arrays.copyOfRange(data, imgOffset + 1, data.length);
        }
        if (Logger.canLog(3)) {
            Logger.logMsg(3, "ID3MetadataParser", "getImageFromPIC", "Unsupported picture type found \"" + type + "\"");
        }
        return null;
    }

    private byte[] getImageFromAPIC(byte[] data) {
        int j;
        int upperBound;
        boolean isSignatureFound;
        boolean isImageJPEG = false;
        boolean isImagePNG = false;
        int maxIndex = data.length - 10;
        int offset = 0;
        for (int j2 = 0; j2 < maxIndex; ++j2) {
            if (data[j2] != 105 || data[j2 + 1] != 109 || data[j2 + 2] != 97 || data[j2 + 3] != 103 || data[j2 + 4] != 101 || data[j2 + 5] != 47) continue;
            if (data[j2 += 6] == 106 && data[j2 + 1] == 112 && data[j2 + 2] == 101 && data[j2 + 3] == 103) {
                isImageJPEG = true;
                offset = j2 + 4;
                break;
            }
            if (data[j2] != 112 || data[j2 + 1] != 110 || data[j2 + 2] != 103) continue;
            isImagePNG = true;
            offset = j2 + 3;
            break;
        }
        if (isImageJPEG) {
            isSignatureFound = false;
            upperBound = data.length - 1;
            for (j = offset; j < upperBound; ++j) {
                if (-1 != data[j] || -40 != data[j + 1]) continue;
                isSignatureFound = true;
                offset = j;
                break;
            }
            if (isSignatureFound) {
                return Arrays.copyOfRange(data, offset, data.length);
            }
        }
        if (isImagePNG) {
            isSignatureFound = false;
            upperBound = data.length - 7;
            for (j = offset; j < upperBound; ++j) {
                if (-119 != data[j] || 80 != data[j + 1] || 78 != data[j + 2] || 71 != data[j + 3] || 13 != data[j + 4] || 10 != data[j + 5] || 26 != data[j + 6] || 10 != data[j + 7]) continue;
                isSignatureFound = true;
                offset = j;
                break;
            }
            if (isSignatureFound) {
                return Arrays.copyOfRange(data, offset, data.length);
            }
        }
        return null;
    }

    private byte[] unsynchronizeBuffer(byte[] data) {
        byte[] udata = new byte[data.length];
        int udatalen = 0;
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) == 255 && data[i + 1] == 0 && data[i + 2] == 0 || (data[i] & 0xFF) == 255 && data[i + 1] == 0 && (data[i + 2] & 0xE0) == 224) {
                udata[udatalen] = data[i];
                udata[++udatalen] = data[i + 2];
                ++udatalen;
                i += 2;
                continue;
            }
            udata[udatalen] = data[i];
            ++udatalen;
        }
        return Arrays.copyOf(udata, udatalen);
    }
}

