/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.configure.ConfigureTools;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.MyMD5;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AACheckBox;
import cn.com.voltronic.solar.view.component.AAFrame;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ConfigFrame
extends AAFrame {
    private static final long serialVersionUID = 7122283504135397965L;
    private AAButton applyBut;
    private AAButton browserButton2;
    private AAButton cancelBut;
    private AALabel downloadLabel;
    private JTextField downloadTextField;
    private AALabel hostIPLabel;
    private JTextField hostIPTextField;
    private AALabel inputError4;
    private AALabel inputError5;
    private AALabel inputError8;
    private AAButton jButton1;
    private AACheckBox jCheckBox1;
    private AACheckBox jCheckBox2;
    private AACheckBox jCheckBox3;
    private AALabel jLabel5;
    private AALabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPasswordField jPasswordField1;
    private JTextField jTextField3;
    private AALabel portLabel;
    private JTextField portTextField;
    private JTextField saveTextField;
    private AALabel savepathLabel;
    private JFileChooser fDialog;
    private static ConfigFrame configview = null;
    private Color color = new Color(255, 0, 0);

    public ConfigFrame() {
        this.initComponents();
        this.setTitle("message.pvConfig");
        this.setIconImage(Constants.CONNECTEDIMG);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static ConfigFrame getInstance() {
        if (configview == null) {
            configview = new ConfigFrame();
        }
        configview.setInitValue();
        return configview;
    }

    private void setInitValue() {
        String downloadDir = GlobalVariables.upgradeConfig.getFromURL();
        String saveDir = GlobalVariables.upgradeConfig.getSavePath();
        boolean useProxy = GlobalVariables.upgradeConfig.isUseProxy();
        boolean autoDetect = GlobalVariables.upgradeConfig.isAutoUpgrade();
        boolean useAuth = GlobalVariables.upgradeConfig.isUseAuth();
        String username = GlobalVariables.upgradeConfig.getAuthName();
        String password = GlobalVariables.upgradeConfig.getAuthPassword();
        String proxy = GlobalVariables.upgradeConfig.getProxyIp();
        String port = GlobalVariables.upgradeConfig.getProxyPort();
        this.downloadTextField.setText(downloadDir);
        this.hostIPTextField.setText(proxy);
        this.portTextField.setText(port);
        this.jTextField3.setText(username);
        this.jPasswordField1.setText(MyMD5.restore(password));
        if ("".equalsIgnoreCase(saveDir)) {
            saveDir = String.valueOf(System.getProperty("user.dir")) + File.separator + "UpgradeFiles";
            try {
                GlobalVariables.upgradeConfig.setSavePath(saveDir);
                ConfigureTools.updateProperties(GlobalVariables.upgradeConfig);
                ConfigureTools.wrapProperties(GlobalVariables.upgradeConfig);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.saveTextField.setText(saveDir);
        if (autoDetect) {
            this.jCheckBox2.setSelected(true);
        } else {
            this.jCheckBox2.setSelected(false);
        }
        if (useProxy) {
            this.jCheckBox1.setSelected(true);
            this.hostIPLabel.setEnabled(true);
            this.portLabel.setEnabled(true);
            this.hostIPTextField.setEnabled(true);
            this.portTextField.setEnabled(true);
            if (useAuth) {
                this.jCheckBox3.setSelected(true);
                this.jLabel5.setEnabled(true);
                this.jLabel6.setEnabled(true);
                this.jTextField3.setEnabled(true);
                this.jPasswordField1.setEnabled(true);
            } else {
                this.jCheckBox3.setSelected(false);
                this.jLabel5.setEnabled(false);
                this.jLabel6.setEnabled(false);
                this.jTextField3.setEnabled(false);
                this.jPasswordField1.setEnabled(false);
            }
        } else {
            this.jCheckBox1.setSelected(false);
            this.hostIPLabel.setEnabled(false);
            this.portLabel.setEnabled(false);
            this.hostIPTextField.setEnabled(false);
            this.portTextField.setEnabled(false);
            this.jCheckBox3.setEnabled(false);
            this.jLabel5.setEnabled(false);
            this.jLabel6.setEnabled(false);
            this.jTextField3.setEnabled(false);
            this.jPasswordField1.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jCheckBox1 = new AACheckBox();
        this.downloadLabel = new AALabel();
        this.savepathLabel = new AALabel();
        this.downloadTextField = new JTextField();
        this.downloadTextField.setBackground(I18NListener.bgColor);
        this.downloadTextField.setForeground(I18NListener.fontColor);
        this.saveTextField = new JTextField();
        this.saveTextField.setEditable(false);
        this.saveTextField.setBackground(I18NListener.bgColor);
        this.saveTextField.setForeground(I18NListener.fontColor);
        this.browserButton2 = new AAButton();
        this.jCheckBox2 = new AACheckBox();
        this.jPanel1 = new JPanel();
        this.hostIPLabel = new AALabel();
        this.hostIPTextField = new JTextField();
        this.hostIPTextField.setBackground(I18NListener.bgColor);
        this.hostIPTextField.setForeground(I18NListener.fontColor);
        this.portTextField = new JTextField();
        this.portTextField.setBackground(I18NListener.bgColor);
        this.portTextField.setForeground(I18NListener.fontColor);
        this.portLabel = new AALabel();
        this.jCheckBox3 = new AACheckBox();
        this.jLabel5 = new AALabel();
        this.jLabel6 = new AALabel();
        this.jTextField3 = new JTextField();
        this.jTextField3.setBackground(I18NListener.bgColor);
        this.jTextField3.setForeground(I18NListener.fontColor);
        this.jPasswordField1 = new JPasswordField();
        this.jPasswordField1.setBackground(I18NListener.bgColor);
        this.jPasswordField1.setForeground(I18NListener.fontColor);
        this.inputError5 = new AALabel();
        this.inputError4 = new AALabel();
        this.jButton1 = new AAButton();
        this.inputError8 = new AALabel();
        this.jPanel2 = new JPanel();
        this.cancelBut = new AAButton();
        this.applyBut = new AAButton();
        this.setDefaultCloseOperation(2);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.downloadLabel.setText("message.downloadpath");
        this.savepathLabel.setText("message.savepath");
        this.browserButton2.setText("message.browser");
        this.jButton1.setText("message.connectiontest");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this.testConnection();
            }
        });
        this.browserButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = ConfigFrame.this.getSaveDialog();
                if (result == 0) {
                    String filepathStr = ConfigFrame.this.fDialog.getSelectedFile().getPath();
                    ConfigFrame.this.saveTextField.setText(filepathStr);
                }
            }
        });
        this.jCheckBox2.setText("message.upgradeAutoDetect");
        this.jCheckBox1.setText("message.useproxy");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigFrame.this.jCheckBox1.isSelected()) {
                    ConfigFrame.this.hostIPLabel.setEnabled(true);
                    ConfigFrame.this.portLabel.setEnabled(true);
                    ConfigFrame.this.hostIPTextField.setEnabled(true);
                    ConfigFrame.this.portTextField.setEnabled(true);
                    ConfigFrame.this.jCheckBox3.setEnabled(true);
                    if (ConfigFrame.this.jCheckBox3.isSelected()) {
                        ConfigFrame.this.jLabel5.setEnabled(true);
                        ConfigFrame.this.jLabel6.setEnabled(true);
                        ConfigFrame.this.jTextField3.setEnabled(true);
                        ConfigFrame.this.jPasswordField1.setEnabled(true);
                    }
                } else {
                    ConfigFrame.this.hostIPLabel.setEnabled(false);
                    ConfigFrame.this.portLabel.setEnabled(false);
                    ConfigFrame.this.hostIPTextField.setEnabled(false);
                    ConfigFrame.this.portTextField.setEnabled(false);
                    ConfigFrame.this.jCheckBox3.setEnabled(false);
                    ConfigFrame.this.jLabel5.setEnabled(false);
                    ConfigFrame.this.jLabel6.setEnabled(false);
                    ConfigFrame.this.jTextField3.setEnabled(false);
                    ConfigFrame.this.jPasswordField1.setEnabled(false);
                }
            }
        });
        this.jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigFrame.this.jCheckBox3.isSelected()) {
                    ConfigFrame.this.jLabel5.setEnabled(true);
                    ConfigFrame.this.jLabel6.setEnabled(true);
                    ConfigFrame.this.jTextField3.setEnabled(true);
                    ConfigFrame.this.jPasswordField1.setEnabled(true);
                } else {
                    ConfigFrame.this.jLabel5.setEnabled(false);
                    ConfigFrame.this.jLabel6.setEnabled(false);
                    ConfigFrame.this.jTextField3.setEnabled(false);
                    ConfigFrame.this.jPasswordField1.setEnabled(false);
                }
            }
        });
        this.hostIPTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                boolean success = VolUtil.checkIP(ConfigFrame.this.hostIPTextField.getText().trim());
                if (!success) {
                    ConfigFrame.this.inputError4.setText("message.inputerror");
                    ConfigFrame.this.hostIPTextField.requestFocus(true);
                } else {
                    ConfigFrame.this.inputError4.setText(" ");
                }
            }
        });
        this.portTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                boolean success = ConfigFrame.isNumeric(ConfigFrame.this.portTextField.getText().trim());
                if (!success) {
                    ConfigFrame.this.inputError5.setText("message.inputerror");
                    ConfigFrame.this.portTextField.requestFocus(true);
                } else {
                    ConfigFrame.this.inputError5.setText(" ");
                }
            }
        });
        this.hostIPLabel.setText("IP");
        this.portLabel.setText("message.proxyport");
        this.inputError4.setForeground(this.color);
        this.inputError4.setText(" ");
        this.inputError5.setForeground(this.color);
        this.inputError5.setText(" ");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jCheckBox3.setText("message.useAuth");
        this.jLabel5.setText("message.username");
        this.jLabel6.setText("message.password");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.portLabel).addComponent(this.hostIPLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.portTextField, -2, 150, -2).addComponent(this.hostIPTextField, -2, 150, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.inputError5).addComponent(this.inputError4))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox3).addGap(210, 210, 210)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPasswordField1, -2, 150, -2).addComponent(this.jTextField3, -2, 150, -2)).addGap(61, 61, 61)))).addContainerGap(148, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostIPLabel).addComponent(this.hostIPTextField, -2, -1, -2).addComponent(this.inputError4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2).addComponent(this.inputError5)).addGap(6, 6, 6).addComponent(this.jCheckBox3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jPasswordField1, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.inputError8.setForeground(this.color);
        this.inputError8.setVisible(false);
        this.inputError8.setText("message.inputerror");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(32, 32, 32).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.savepathLabel).addComponent(this.downloadLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.saveTextField).addComponent(this.downloadTextField, -1, 243, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browserButton2).addComponent(this.inputError8))).addComponent(this.jCheckBox2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(26, 26, 26).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.downloadLabel).addComponent(this.downloadTextField, -2, -1, -2).addComponent(this.inputError8)).addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.savepathLabel).addComponent(this.browserButton2).addComponent(this.saveTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1).addContainerGap(32, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.cancelBut.setText("message.close");
        this.cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.cancelButActionPerformed(evt);
            }
        });
        this.applyBut.setText("message.apply");
        this.applyBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.applyButActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(371, Short.MAX_VALUE).addComponent(this.applyBut).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelBut).addGap(13, 13, 13)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelBut).addComponent(this.applyBut)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void cancelButActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        configview = null;
    }

    public int getOpenDialog() {
        this.fDialog = new JFileChooser();
        this.fDialog.setFileSelectionMode(1);
        return this.fDialog.showOpenDialog(this);
    }

    private int getSaveDialog() {
        this.fDialog = new JFileChooser();
        this.fDialog.setFileSelectionMode(1);
        return this.fDialog.showSaveDialog(this);
    }

    private void applyButActionPerformed(ActionEvent evt) {
        try {
            String hostIp = this.hostIPTextField.getText().trim();
            String hostPort = this.portTextField.getText().trim();
            String username = this.jTextField3.getText().trim();
            String password = new String(this.jPasswordField1.getPassword()).trim();
            String downloadText = this.downloadTextField.getText().trim();
            String saveText = this.saveTextField.getText().trim();
            if (this.jCheckBox1.isSelected()) {
                if (!VolUtil.checkIP(hostIp) || !ConfigFrame.isNumeric(hostPort) || ConfigFrame.isNull(hostIp) || ConfigFrame.isNull(hostPort)) {
                    DisplayMessage.showErrorDialog("message.inputerror");
                    return;
                }
                if (this.jCheckBox3.isSelected() && (ConfigFrame.isNull(username) || ConfigFrame.isNull(password))) {
                    DisplayMessage.showErrorDialog("message.inputerror");
                    return;
                }
            }
            GlobalVariables.upgradeConfig.setFromURL(downloadText);
            GlobalVariables.upgradeConfig.setSavePath(saveText);
            if (this.jCheckBox2.isSelected()) {
                GlobalVariables.upgradeConfig.setAutoUpgrade(true);
            } else {
                GlobalVariables.upgradeConfig.setAutoUpgrade(false);
            }
            if (this.jCheckBox1.isSelected()) {
                GlobalVariables.upgradeConfig.setUseProxy(true);
                if (this.jCheckBox3.isSelected()) {
                    GlobalVariables.upgradeConfig.setUseAuth(true);
                } else {
                    GlobalVariables.upgradeConfig.setUseAuth(false);
                }
            } else {
                GlobalVariables.upgradeConfig.setUseProxy(false);
                GlobalVariables.upgradeConfig.setUseAuth(false);
            }
            GlobalVariables.upgradeConfig.setProxyIp(hostIp);
            GlobalVariables.upgradeConfig.setProxyPort(hostPort);
            GlobalVariables.upgradeConfig.setAuthName(username);
            GlobalVariables.upgradeConfig.setAuthPassword(MyMD5.transform(password));
            ConfigureTools.updateProperties(GlobalVariables.upgradeConfig);
            ConfigureTools.wrapProperties(GlobalVariables.upgradeConfig);
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
            DisplayMessage.showErrorDialog("message.operationfailure");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testConnection() {
        HttpURLConnection httpUrl = null;
        InputStream inputStream = null;
        URL url = null;
        String dir = this.downloadTextField.getText().trim();
        System.out.println(dir);
        try {
            try {
                url = new URL(dir);
                String proxy = this.hostIPTextField.getText().trim();
                String port = this.portTextField.getText().trim();
                boolean useProxy = this.jCheckBox1.isSelected();
                boolean useAuth = this.jCheckBox3.isSelected();
                if (useProxy) {
                    Properties systemProperties = System.getProperties();
                    systemProperties.setProperty("http.proxyHost", proxy);
                    systemProperties.setProperty("http.proxyPort", port);
                }
                httpUrl = (HttpURLConnection)url.openConnection();
                if (useProxy && useAuth) {
                    String password = String.valueOf(this.jTextField3.getText().trim()) + ":" + new String(this.jPasswordField1.getPassword()).trim();
                    String encoded = Base64.encode(password.getBytes());
                    httpUrl.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
                }
                httpUrl.setConnectTimeout(5000);
                httpUrl.connect();
                inputStream = httpUrl.getInputStream();
                DisplayMessage.showInfoDialog("message.connectionsuccess");
                return;
            }
            catch (FileNotFoundException ex) {
                DisplayMessage.showInfoDialog("message.connectionsuccess");
                if (httpUrl != null) {
                    httpUrl.disconnect();
                }
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            catch (IOException ex) {
                DisplayMessage.showErrorDialog("message.connectionfailure");
                if (httpUrl != null) {
                    httpUrl.disconnect();
                }
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (httpUrl != null) {
                httpUrl.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean isNumeric(String str) {
        if (str == null || "".equalsIgnoreCase(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        int num = Integer.parseInt(str);
        return num <= 65536 && num >= 1;
    }

    private static boolean isNull(String str) {
        return str == null || "".equalsIgnoreCase(str);
    }
}

