/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeakReferenceMonitor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor));
    private static final ReferenceQueue handleQueue = new ReferenceQueue();
    private static final Map trackedEntries = Collections.synchronizedMap(new HashMap());
    private static Thread monitoringThread = null;
    static /* synthetic */ Class class$org$springframework$util$WeakReferenceMonitor;

    public static void monitor(Object object, ReleaseListener releaseListener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Monitoring handle [" + object + "] with release listener [" + releaseListener + "]"));
        }
        WeakReference<Object> weakReference = new WeakReference<Object>(object, handleQueue);
        WeakReferenceMonitor.addEntry(weakReference, releaseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(Reference reference, ReleaseListener releaseListener) {
        trackedEntries.put(reference, releaseListener);
        Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
        synchronized (clazz) {
            if (!WeakReferenceMonitor.isMonitoringThreadRunning()) {
                monitoringThread = new Thread((Runnable)new MonitoringProcess(), (class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor).getName());
                monitoringThread.setDaemon(true);
                monitoringThread.start();
            }
        }
    }

    private static ReleaseListener removeEntry(Reference reference) {
        return (ReleaseListener)trackedEntries.remove(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMonitoringThreadRunning() {
        Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
        synchronized (clazz) {
            return monitoringThread != null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MonitoringProcess
    implements Runnable {
        private MonitoringProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Reference reference;
            logger.debug((Object)"Starting reference monitor thread");
            try {
                while (!trackedEntries.isEmpty()) {
                    try {
                        reference = handleQueue.remove();
                        ReleaseListener releaseListener = WeakReferenceMonitor.removeEntry(reference);
                        if (releaseListener == null) continue;
                        releaseListener.released();
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug((Object)"Reference monitor thread interrupted", (Throwable)interruptedException);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Stopping reference monitor thread");
                Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
                synchronized (clazz) {
                    monitoringThread = null;
                    throw throwable;
                }
            }
            logger.debug((Object)"Stopping reference monitor thread");
            reference = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
            synchronized (reference) {
                monitoringThread = null;
                return;
            }
        }
    }

    public static interface ReleaseListener {
        public void released();
    }
}

