/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.security;

import java.security.BasicPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public final class SystemPermission
extends BasicPermission {
    public static final String SERVER = "server";
    public static final String ENGINE = "engine";
    public static final String JMX = "jmx";
    public static final String SHUTDOWN = "shutdown";
    public static final String CONTROL = "control";
    public static final String MONITOR = "monitor";
    private static final Set LEGAL_NAMES = new HashSet();
    private static final List LEGAL_ACTIONS;
    private final String actions;

    public SystemPermission(String string, String string2) {
        super(string);
        if (!LEGAL_NAMES.contains(string)) {
            throw new IllegalArgumentException("Unknown permission " + string);
        }
        this.actions = SystemPermission.getCanonicalForm(string2);
    }

    public String getActions() {
        return this.actions;
    }

    private static String getCanonicalForm(String string) {
        int n;
        CharSequence charSequence;
        string = string.trim().toLowerCase(Locale.ENGLISH);
        boolean[] blArray = new boolean[LEGAL_ACTIONS.size()];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken().trim().toLowerCase(Locale.ENGLISH);
            n = LEGAL_ACTIONS.indexOf(charSequence);
            if (n == -1) continue;
            blArray[n] = true;
        }
        charSequence = new StringBuffer();
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            if (((StringBuffer)charSequence).length() != 0) {
                ((StringBuffer)charSequence).append(",");
            }
            ((StringBuffer)charSequence).append(LEGAL_ACTIONS.get(n));
        }
        return ((StringBuffer)charSequence).toString();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SystemPermission systemPermission = (SystemPermission)object;
        return this.getActions().equals(systemPermission.getActions());
    }

    public boolean implies(Permission permission) {
        int n;
        if (!super.implies(permission)) {
            return false;
        }
        int n2 = SystemPermission.getActionMask(this.getActions());
        return (n2 & (n = SystemPermission.getActionMask(permission.getActions()))) == n;
    }

    private static int getActionMask(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = LEGAL_ACTIONS.indexOf(stringTokenizer.nextElement());
            if (n2 == -1) continue;
            n |= 1 << n2;
        }
        return n;
    }

    static {
        LEGAL_NAMES.add(SERVER);
        LEGAL_NAMES.add(ENGINE);
        LEGAL_NAMES.add(JMX);
        LEGAL_ACTIONS = new ArrayList();
        LEGAL_ACTIONS.add(CONTROL);
        LEGAL_ACTIONS.add(MONITOR);
        LEGAL_ACTIONS.add(SHUTDOWN);
    }
}

