/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class FileCopyUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$util$FileCopyUtils == null ? (class$org$springframework$util$FileCopyUtils = FileCopyUtils.class$("org.springframework.util.FileCopyUtils")) : class$org$springframework$util$FileCopyUtils));
    public static final int BUFFER_SIZE = 4096;
    static /* synthetic */ Class class$org$springframework$util$FileCopyUtils;

    public static int copy(File file, File file2) throws IOException {
        Assert.notNull(file, "No input File specified");
        Assert.notNull(file2, "No output File specified");
        return FileCopyUtils.copy(new BufferedInputStream(new FileInputStream(file)), (OutputStream)new BufferedOutputStream(new FileOutputStream(file2)));
    }

    public static void copy(byte[] byArray, File file) throws IOException {
        Assert.notNull(byArray, "No input byte array specified");
        Assert.notNull(file, "No output File specified");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        FileCopyUtils.copy(byteArrayInputStream, (OutputStream)bufferedOutputStream);
    }

    public static byte[] copyToByteArray(File file) throws IOException {
        Assert.notNull(file, "No input File specified");
        return FileCopyUtils.copyToByteArray(new BufferedInputStream(new FileInputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        Assert.notNull(inputStream, "No InputStream specified");
        Assert.notNull(outputStream, "No OutputStream specified");
        try {
            int n = 0;
            byte[] byArray = new byte[4096];
            int n2 = -1;
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                n += n2;
            }
            outputStream.flush();
            int n3 = n;
            return n3;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                logger.warn((Object)"Could not close InputStream", (Throwable)iOException);
            }
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                logger.warn((Object)"Could not close OutputStream", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(byte[] byArray, OutputStream outputStream) throws IOException {
        Assert.notNull(byArray, "No input byte array specified");
        Assert.notNull(outputStream, "No OutputStream specified");
        try {
            outputStream.write(byArray);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                logger.warn((Object)"Could not close OutputStream", (Throwable)iOException);
            }
        }
    }

    public static byte[] copyToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        FileCopyUtils.copy(inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader reader, Writer writer) throws IOException {
        Assert.notNull(reader, "No Reader specified");
        Assert.notNull(writer, "No Writer specified");
        try {
            int n = 0;
            char[] cArray = new char[4096];
            int n2 = -1;
            while ((n2 = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n2);
                n += n2;
            }
            writer.flush();
            int n3 = n;
            return n3;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                logger.warn((Object)"Could not close Reader", (Throwable)iOException);
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {
                logger.warn((Object)"Could not close Writer", (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String string, Writer writer) throws IOException {
        Assert.notNull(string, "No input String specified");
        Assert.notNull(writer, "No Writer specified");
        try {
            writer.write(string);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                logger.warn((Object)"Could not close Writer", (Throwable)iOException);
            }
        }
    }

    public static String copyToString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        FileCopyUtils.copy(reader, (Writer)stringWriter);
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

