/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.system;

import cn.com.voltronic.solar.communicate.SECUSBHandler;
import cn.com.voltronic.solar.communicate.SerialHandler;
import cn.com.voltronic.solar.communicate.USBHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.ProtocolProcessorItem;
import java.util.ArrayList;
import java.util.List;

public class ProcessorCategories {
    protected static List<ProtocolProcessorItem> _protocolList = new ArrayList<ProtocolProcessorItem>();
    protected static List<ProtocolProcessorItem> serialProcessors = new ArrayList<ProtocolProcessorItem>();
    protected static List<ProtocolProcessorItem> serialSecProcessors = new ArrayList<ProtocolProcessorItem>();
    protected static List<ProtocolProcessorItem> usbProcessors = new ArrayList<ProtocolProcessorItem>();
    protected static List<ProtocolProcessorItem> usbSecProcessors = new ArrayList<ProtocolProcessorItem>();

    public static void registerProcessor(Class protocol, Class handler, Class abstractProcess) {
        _protocolList.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        String clsName = handler.getName();
        if (clsName.equals(USBHandler.class.getName())) {
            usbProcessors.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        } else if (clsName.equals(SECUSBHandler.class.getName())) {
            usbSecProcessors.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        } else if (clsName.equals(SerialHandler.class.getName())) {
            serialProcessors.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        } else {
            serialSecProcessors.add(new ProtocolProcessorItem(protocol, handler, abstractProcess));
        }
    }

    public static AbstractProcessor getNewMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : _protocolList) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }

    public static AbstractProcessor getSerialMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : serialProcessors) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }

    public static AbstractProcessor getSerialSecMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : serialSecProcessors) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }

    public static AbstractProcessor getUsbMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : usbProcessors) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }

    public static AbstractProcessor getUsbSecMonitor(Object handler) {
        AbstractProcessor process = null;
        for (ProtocolProcessorItem item : usbSecProcessors) {
            process = item.getMatchProcess(handler);
            if (process != null) break;
        }
        return process;
    }
}

