/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BaseSplitPaneDivider
extends BasicSplitPaneDivider {
    private boolean centerOneTouchButtons = true;

    public BaseSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        if (JTattooUtilities.getJavaVersion() >= 1.4 && UIManager.get("SplitPane.centerOneTouchButtons") != null) {
            this.centerOneTouchButtons = UIManager.getBoolean("SplitPane.centerOneTouchButtons");
        }
        this.setLayout(new MyDividerLayout());
    }

    public Border getBorder() {
        return null;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = 0;
        int n4 = 0;
        if (n % 2 == 1) {
            n3 = 1;
        }
        if (n2 % 2 == 1) {
            n4 = 1;
        }
        ColorUIResource colorUIResource = AbstractLookAndFeel.getBackgroundColor();
        Color color = ColorHelper.brighter(colorUIResource, 25.0);
        Color color2 = ColorHelper.darker(colorUIResource, 5.0);
        Color[] colorArray = ColorHelper.createColorArr(color, color2, 10);
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            AbstractLookAndFeel abstractLookAndFeel = (AbstractLookAndFeel)UIManager.getLookAndFeel();
            if (this.orientation == 1) {
                JTattooUtilities.fillVerGradient(graphics, colorArray, 0, 0, n, n2);
                Icon icon = abstractLookAndFeel.getIconFactory().getSplitterHorBumpIcon();
                if (icon != null && n > icon.getIconWidth()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.7f);
                    graphics2D.setComposite(alphaComposite);
                    if (this.splitPane.isOneTouchExpandable() && this.centerOneTouchButtons) {
                        int n5 = n2 / 2;
                        int n6 = (n - icon.getIconWidth()) / 2 + n3;
                        int n7 = n5 - icon.getIconHeight() - 40;
                        icon.paintIcon(this, graphics, n6, n7);
                        n7 = n5 + 40;
                        icon.paintIcon(this, graphics, n6, n7);
                    } else {
                        int n8 = (n - icon.getIconWidth()) / 2 + n3;
                        int n9 = (n2 - icon.getIconHeight()) / 2;
                        icon.paintIcon(this, graphics, n8, n9);
                    }
                    graphics2D.setComposite(composite);
                }
            } else {
                JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n, n2);
                Icon icon = abstractLookAndFeel.getIconFactory().getSplitterVerBumpIcon();
                if (icon != null && n2 > icon.getIconHeight()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.7f);
                    graphics2D.setComposite(alphaComposite);
                    if (this.splitPane.isOneTouchExpandable() && this.centerOneTouchButtons) {
                        int n10 = n / 2;
                        int n11 = n10 - icon.getIconWidth() - 40;
                        int n12 = (n2 - icon.getIconHeight()) / 2 + n4;
                        icon.paintIcon(this, graphics, n11, n12);
                        n11 = n10 + 40;
                        icon.paintIcon(this, graphics, n11, n12);
                    } else {
                        int n13 = (n - icon.getIconWidth()) / 2;
                        int n14 = (n2 - icon.getIconHeight()) / 2 + n4;
                        icon.paintIcon(this, graphics, n13, n14);
                    }
                    graphics2D.setComposite(composite);
                }
            }
        }
        this.paintComponents(graphics);
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){

            public void paint(Graphics graphics) {
                Color color = this.getBackground();
                int n = this.getSize().width;
                int n2 = this.getSize().height;
                if (this.getModel().isPressed() && this.getModel().isArmed()) {
                    graphics.setColor(ColorHelper.darker(color, 40.0));
                    graphics.fillRect(0, 0, n, n2);
                } else if (this.getModel().isRollover()) {
                    graphics.setColor(AbstractLookAndFeel.getTheme().getRolloverColor());
                    graphics.fillRect(0, 0, n, n2);
                }
                AbstractLookAndFeel abstractLookAndFeel = (AbstractLookAndFeel)UIManager.getLookAndFeel();
                Icon icon = null;
                icon = BaseSplitPaneDivider.this.orientation == 1 ? abstractLookAndFeel.getIconFactory().getSplitterLeftArrowIcon() : abstractLookAndFeel.getIconFactory().getSplitterUpArrowIcon();
                int n3 = (n - icon.getIconWidth()) / 2;
                int n4 = (n2 - icon.getIconHeight()) / 2;
                icon.paintIcon(this, graphics, n3, n4);
                if (this.getModel().isArmed()) {
                    if (this.getModel().isPressed()) {
                        JTattooUtilities.draw3DBorder(graphics, ColorHelper.darker(color, 30.0), ColorHelper.brighter(color, 80.0), 0, 0, n, n2);
                    } else {
                        JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color, 80.0), ColorHelper.darker(color, 30.0), 0, 0, n, n2);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setRolloverEnabled(true);
        return jButton;
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){

            public void paint(Graphics graphics) {
                Color color = this.getBackground();
                int n = this.getSize().width;
                int n2 = this.getSize().height;
                if (this.getModel().isPressed() && this.getModel().isArmed()) {
                    graphics.setColor(ColorHelper.darker(color, 40.0));
                    graphics.fillRect(0, 0, n, n2);
                } else if (this.getModel().isRollover()) {
                    graphics.setColor(AbstractLookAndFeel.getTheme().getRolloverColor());
                    graphics.fillRect(0, 0, n, n2);
                }
                AbstractLookAndFeel abstractLookAndFeel = (AbstractLookAndFeel)UIManager.getLookAndFeel();
                Icon icon = null;
                icon = BaseSplitPaneDivider.this.orientation == 1 ? abstractLookAndFeel.getIconFactory().getSplitterRightArrowIcon() : abstractLookAndFeel.getIconFactory().getSplitterDownArrowIcon();
                int n3 = (n - icon.getIconWidth()) / 2;
                int n4 = (n2 - icon.getIconHeight()) / 2;
                icon.paintIcon(this, graphics, n3, n4);
                if (this.getModel().isArmed()) {
                    if (this.getModel().isPressed()) {
                        JTattooUtilities.draw3DBorder(graphics, ColorHelper.darker(color, 30.0), ColorHelper.brighter(color, 80.0), 0, 0, n, n2);
                    } else {
                        JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(color, 80.0), ColorHelper.darker(color, 30.0), 0, 0, n, n2);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setRolloverEnabled(true);
        return jButton;
    }

    protected class MyDividerLayout
    implements LayoutManager {
        protected MyDividerLayout() {
        }

        public void layoutContainer(Container container) {
            if (BaseSplitPaneDivider.this.leftButton != null && BaseSplitPaneDivider.this.rightButton != null && container == BaseSplitPaneDivider.this) {
                if (BaseSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = BaseSplitPaneDivider.this.getInsets();
                    int n = 11;
                    int n2 = 0;
                    int n3 = 0;
                    if (BaseSplitPaneDivider.this.centerOneTouchButtons) {
                        n = 13;
                        n2 = (BaseSplitPaneDivider.this.getWidth() - 2 * n) / 2 - n;
                        n3 = (BaseSplitPaneDivider.this.getHeight() - 2 * n) / 2 - n;
                    }
                    if (BaseSplitPaneDivider.this.orientation == 0) {
                        int n4;
                        int n5 = n4 = insets != null ? insets.left : 0;
                        if (insets != null) {
                            n -= insets.top + insets.bottom;
                            n = Math.max(n, 0);
                        }
                        int n6 = (container.getSize().height - n) / 2;
                        BaseSplitPaneDivider.this.leftButton.setBounds(n2 + n4, n6, n * 2, n);
                        BaseSplitPaneDivider.this.rightButton.setBounds(n2 + n4 + n * 2 + 1, n6, n * 2, n);
                    } else {
                        int n7;
                        int n8 = n7 = insets != null ? insets.top : 0;
                        if (insets != null) {
                            n -= insets.left + insets.right;
                            n = Math.max(n, 0);
                        }
                        int n9 = (container.getSize().width - n) / 2;
                        BaseSplitPaneDivider.this.leftButton.setBounds(n9, n3 + n7, n, n * 2);
                        BaseSplitPaneDivider.this.rightButton.setBounds(n9, n3 + n7 + n * 2 + 1, n, n * 2);
                    }
                } else {
                    BaseSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    BaseSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            if (container != BaseSplitPaneDivider.this || BaseSplitPaneDivider.this.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension dimension = null;
            if (BaseSplitPaneDivider.this.splitPane.isOneTouchExpandable() && BaseSplitPaneDivider.this.leftButton != null) {
                dimension = BaseSplitPaneDivider.this.leftButton.getMinimumSize();
            }
            Insets insets = BaseSplitPaneDivider.this.getInsets();
            int n2 = n = BaseSplitPaneDivider.this.getDividerSize();
            if (BaseSplitPaneDivider.this.orientation == 0) {
                if (dimension != null) {
                    int n3 = dimension.height;
                    if (insets != null) {
                        n3 += insets.top + insets.bottom;
                    }
                    n2 = Math.max(n2, n3);
                }
                n = 1;
            } else {
                if (dimension != null) {
                    int n4 = dimension.width;
                    if (insets != null) {
                        n4 += insets.left + insets.right;
                    }
                    n = Math.max(n, n4);
                }
                n2 = 1;
            }
            return new Dimension(n, n2);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }
    }
}

