/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class FormatIdUtil {
    private static final int BYTE_MASK = 255;
    private static final int NIBBLE_MASK = 15;
    private static final int NIBBLE_SHIFT = 4;
    private static final int HEX_RADIX = 16;

    private FormatIdUtil() {
    }

    public static int getFormatIdByteLength(int n) {
        return 2;
    }

    public static void writeFormatIdInteger(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(n);
    }

    public static int readFormatIdInteger(DataInput dataInput) throws IOException {
        return dataInput.readUnsignedShort();
    }

    public static int readFormatIdInteger(byte[] byArray) {
        byte by = byArray[0];
        byte by2 = byArray[1];
        return (by & 0xFF) << 8 | by2 & 0xFF;
    }

    public static String formatIdToString(int n) {
        return Integer.toString(n);
    }

    public static String toString(byte[] byArray, int n) {
        char[] cArray = new char[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[i] & 0xFF;
            int n4 = n3 & 0xF;
            int n5 = n3 >>> 4;
            cArray[n2++] = FormatIdUtil.encodeNibble(n4);
            cArray[n2++] = FormatIdUtil.encodeNibble(n5);
        }
        return new String(cArray);
    }

    public static byte[] fromString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        for (int i = 0; i < n; i += 2) {
            int n3 = FormatIdUtil.decodeNibble(cArray[i]);
            int n4 = FormatIdUtil.decodeNibble(cArray[i + 1]);
            byArray[n2++] = (byte)(n4 << 4 | n3);
        }
        return byArray;
    }

    private static char encodeNibble(int n) {
        return Character.forDigit(n, 16);
    }

    private static int decodeNibble(char c) {
        return Character.digit(c, 16);
    }
}

