/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.EmbedCallableStatement;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedCallableStatement20
extends EmbedCallableStatement {
    public EmbedCallableStatement20(EmbedConnection embedConnection, String string, int n, int n2, int n3) throws SQLException {
        super(embedConnection, string, n, n2, n3);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dataValueDescriptor);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(n);
    }

    public Ref getRef(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public Array getArray(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw Util.notImplemented();
    }

    public void setArray(int n, Array array) throws SQLException {
        throw Util.notImplemented();
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public Blob getBlob(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public Clob getClob(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public Array getArray(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setNull(String string, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw Util.notImplemented();
    }

    public boolean getBoolean(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setByte(String string, byte by) throws SQLException {
        throw Util.notImplemented();
    }

    public byte getByte(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setShort(String string, short s) throws SQLException {
        throw Util.notImplemented();
    }

    public short getShort(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setInt(String string, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public int getInt(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setLong(String string, long l) throws SQLException {
        throw Util.notImplemented();
    }

    public long getLong(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setFloat(String string, float f) throws SQLException {
        throw Util.notImplemented();
    }

    public float getFloat(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setDouble(String string, double d) throws SQLException {
        throw Util.notImplemented();
    }

    public double getDouble(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw Util.notImplemented();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setString(String string, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    public String getString(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw Util.notImplemented();
    }

    public byte[] getBytes(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public void setDate(String string, Date date) throws SQLException {
        throw Util.notImplemented();
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public Date getDate(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public void setTime(String string, Time time) throws SQLException {
        throw Util.notImplemented();
    }

    public Time getTime(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw Util.notImplemented();
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(string);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setObject(String string, Object object) throws SQLException {
        throw Util.notImplemented();
    }

    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setBigDecimal(bigDecimal);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 5);
        }
        return bigDecimal;
    }

    boolean setObjectConvert(int n, Object object) throws SQLException {
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkStatus();
        switch (this.getParms().getParameterMode(n)) {
            case 0: 
            case 1: {
                throw this.newSQLException("XCL26.S", Integer.toString(n));
            }
        }
        Reader reader = null;
        int n2 = this.getParameterJDBCType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                Object object;
                boolean bl = false;
                Object object2 = object = this.getConnectionSynchronization();
                synchronized (object2) {
                    try {
                        DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
                        if (dataValueDescriptor.isNull()) {
                            break;
                        }
                        bl = true;
                        this.setupContextStack();
                        StreamStorable streamStorable = (StreamStorable)((Object)dataValueDescriptor);
                        InputStream inputStream = streamStorable.returnStream();
                        reader = inputStream == null ? new StringReader(dataValueDescriptor.getString()) : new UTF8Reader(inputStream, 0L, this, object);
                        break;
                    }
                    catch (Throwable throwable) {
                        throw EmbedResultSet.noStateChangeException(throwable);
                    }
                    finally {
                        if (bl) {
                            this.restoreContextStack();
                        }
                    }
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream inputStream = this.getBinaryStream(n);
                    if (inputStream == null) break;
                    reader = new InputStreamReader(inputStream, "UTF-16BE");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw this.newSQLException(unsupportedEncodingException.getMessage());
                }
            }
            default: {
                throw this.newSQLException("22005", "java.io.Reader", Util.typeName(n2));
            }
        }
        this.wasNull = reader == null;
        return reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getBinaryStream(int n) throws SQLException {
        int n2 = this.getParameterJDBCType(n);
        switch (n2) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw this.newSQLException("22005", "java.io.InputStream", Util.typeName(n2));
            }
        }
        boolean bl = false;
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                bl = true;
                this.setupContextStack();
                StreamStorable streamStorable = (StreamStorable)((Object)dataValueDescriptor);
                InputStream inputStream = streamStorable.returnStream();
                inputStream = inputStream == null ? new ByteArrayInputStream(dataValueDescriptor.getBytes()) : new BinaryToRawStream(inputStream, dataValueDescriptor);
                InputStream inputStream2 = inputStream;
                return inputStream2;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }
}

