/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.comparator;

import java.io.Serializable;
import java.util.Comparator;

public class InvertibleComparator
implements Comparator,
Serializable {
    private final Comparator comparator;
    private boolean ascending = true;

    public InvertibleComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public InvertibleComparator(Comparator comparator, boolean bl) {
        this.comparator = comparator;
        this.setAscending(bl);
    }

    public void setAscending(boolean bl) {
        this.ascending = bl;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void invertOrder() {
        this.ascending = !this.ascending;
    }

    public int compare(Object object, Object object2) {
        int n = this.comparator.compare(object, object2);
        if (n != 0) {
            if (!this.ascending) {
                n = Integer.MIN_VALUE == n ? Integer.MAX_VALUE : (n *= -1);
            }
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InvertibleComparator)) {
            return false;
        }
        InvertibleComparator invertibleComparator = (InvertibleComparator)object;
        return ((Object)this.comparator).equals(invertibleComparator.comparator) && this.ascending == invertibleComparator.ascending;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    public String toString() {
        return "InvertibleComparator: [" + this.comparator + "]; ascending=" + this.ascending;
    }
}

