/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import sun.awt.AWTAccessor;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.util.logging.PlatformLogger;

public final class XContentWindow
extends XWindow {
    private static PlatformLogger insLog = PlatformLogger.getLogger("sun.awt.X11.insets.XContentWindow");
    private final XDecoratedPeer parentFrame;
    private final List<SavedExposeEvent> iconifiedExposeEvents = new ArrayList<SavedExposeEvent>();

    static XContentWindow createContent(XDecoratedPeer xDecoratedPeer) {
        WindowDimensions windowDimensions = xDecoratedPeer.getDimensions();
        Rectangle rectangle = windowDimensions.getBounds();
        Insets insets = windowDimensions.getInsets();
        if (insets != null) {
            rectangle.x = -insets.left;
            rectangle.y = -insets.top;
        } else {
            rectangle.x = 0;
            rectangle.y = 0;
        }
        XContentWindow xContentWindow = new XContentWindow(xDecoratedPeer, rectangle);
        xContentWindow.xSetVisible(true);
        return xContentWindow;
    }

    private XContentWindow(XDecoratedPeer xDecoratedPeer, Rectangle rectangle) {
        super((Component)xDecoratedPeer.getTarget(), xDecoratedPeer.getShell(), rectangle);
        this.parentFrame = xDecoratedPeer;
    }

    @Override
    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.putIfNull((Object)"bit gravity", (Object)1);
        Long l = (Long)xCreateWindowParams.get("event mask");
        if (l != null) {
            l = l & 0xFFFFFFFFFFFDFFFFL;
            xCreateWindowParams.put("event mask", l);
        }
    }

    @Override
    protected String getWMName() {
        return "Content window";
    }

    @Override
    protected boolean isEventDisabled(XEvent xEvent) {
        switch (xEvent.get_type()) {
            case 7: 
            case 8: {
                return false;
            }
            case 22: {
                return true;
            }
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isEventDisabled(xEvent) || this.parentFrame.isEventDisabled(xEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setContentBounds(WindowDimensions windowDimensions) {
        XToolkit.awtLock();
        try {
            Rectangle rectangle = windowDimensions.getBounds();
            Insets insets = windowDimensions.getInsets();
            if (insets != null) {
                rectangle.setLocation(-insets.left, -insets.top);
            }
            if (insLog.isLoggable(500)) {
                insLog.fine("Setting content bounds {0}, old bounds {1}", rectangle, this.getBounds());
            }
            boolean bl = !rectangle.equals(this.getBounds());
            this.reshape(rectangle);
            if (bl) {
                insLog.fine("Sending RESIZED");
                this.handleResize(rectangle);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.validateSurface();
    }

    public void handleResize(Rectangle rectangle) {
        AWTAccessor.getComponentAccessor().setSize(this.target, rectangle.width, rectangle.height);
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    @Override
    public void postPaintEvent(Component component, int n, int n2, int n3, int n4) {
        if (this.parentFrame instanceof XFramePeer && (((XFramePeer)this.parentFrame).getState() & 1) != 0) {
            this.iconifiedExposeEvents.add(new SavedExposeEvent(component, n, n2, n3, n4));
        } else {
            super.postPaintEvent(component, n, n2, n3, n4);
        }
    }

    void purgeIconifiedExposeEvents() {
        for (SavedExposeEvent savedExposeEvent : this.iconifiedExposeEvents) {
            super.postPaintEvent(savedExposeEvent.target, savedExposeEvent.x, savedExposeEvent.y, savedExposeEvent.w, savedExposeEvent.h);
        }
        this.iconifiedExposeEvents.clear();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getBounds() + "]";
    }

    private static class SavedExposeEvent {
        Component target;
        int x;
        int y;
        int w;
        int h;

        SavedExposeEvent(Component component, int n, int n2, int n3, int n4) {
            this.target = component;
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }
    }
}

