/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.communicate.SNMPHandler;
import cn.com.voltronic.solar.configure.CustomerConfig;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.CommandParameterMap;
import cn.com.voltronic.solar.data.bean.ControlRelation;
import cn.com.voltronic.solar.data.bean.EnableSpinnerParameter;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.MoreInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.PurchaseInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.CRCUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class P16
implements IProtocol {
    public static Logger logger = Logger.getLogger(P16.class);
    public static final String VERSION_140115 = "14-01-15";
    public static final String VERSION_170711 = "17-07-11";
    private static int GRIDTIE_BASIC = 100;
    private static int OFFGRID_BASIC = 150;
    private static int HOMESOLAR_BASIC = 200;
    protected int mpptTrackNumber = 1;
    private String dspversion = "";
    private String mcuversion = "";
    private String modelName = "";
    private String modelType = "10";
    private String deviceModel = "100";
    private String serialNo = "";
    private boolean supportModelSetting = true;
    private CommandParameterMap map = new CommandParameterMap();
    private List<ControlRelation> relalist = new ArrayList<ControlRelation>();

    @Override
    public String getProtocolID() {
        return "P16";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            IComUSBHandler _handler = (IComUSBHandler)handler;
            String dataStr = "(NAK";
            int i = 0;
            while (i < 3) {
                if (!dataStr.equals("(NAK")) break;
                try {
                    dataStr = _handler.excuteSimpleCommand("QPI");
                    if (dataStr.length() > 5) {
                        if (CRCUtil.checkCRC(dataStr)) {
                            dataStr = dataStr.substring(0, dataStr.length() - 2);
                            _handler.setCrcCheck(true);
                        } else {
                            dataStr = "(NAK";
                            _handler.setCrcCheck(false);
                        }
                    }
                }
                catch (Exception e) {
                    return false;
                }
                ++i;
            }
            if (dataStr.startsWith("(PI") && dataStr.endsWith("16") && this instanceof P16) {
                block15: {
                    try {
                        this.mpptTrackNumber = _handler.getMpptTrackNumber();
                        this.modelType = _handler.getModeType();
                        this.deviceModel = _handler.getDeviceModel();
                        this.modelName = _handler.getModelName();
                        String serialNoStr = _handler.getSerialNo();
                        dataStr = "";
                        int i2 = 0;
                        while (i2 < 5 && (StringUtils.isEmpty((String)dataStr) || dataStr.startsWith("(NAK") || dataStr.indexOf("MCU:") < 0 || dataStr.indexOf("DSP:") < 0)) {
                            dataStr = _handler.excuteSimpleCommand("I");
                            int index = dataStr.indexOf("DSP:");
                            if (index > 0) {
                                this.dspversion = dataStr.substring(index + 4, index + 4 + 8);
                                index = dataStr.indexOf("MCU:");
                                this.mcuversion = dataStr.substring(index + 4, index + 4 + 8);
                            } else {
                                dataStr = "";
                            }
                            ++i2;
                        }
                        if (serialNoStr != null && !"".equals(serialNoStr)) {
                            this.serialNo = serialNoStr;
                            break block15;
                        }
                        return false;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (!(handler instanceof ModbusHandler)) {
            boolean cfr_ignored_0 = handler instanceof SNMPHandler;
        }
        return false;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.gridVoltageR[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.gridFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        if (this.modelName.isEmpty()) {
            item.add(new AutoLabelItem("message.pvInputVoltage[:]", "{workInfo.getPvInputVoltage1}", "V"));
        } else if (this.modelName.equals("000")) {
            item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
            item.add(new AutoLabelItem("message.pvInputVoltage2[:]", "{workInfo.getPvInputVoltage2}", "V"));
        }
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            IComUSBHandler _handler = (IComUSBHandler)((Object)processor.getHandler());
            this.modelType = _handler.getModeType();
        }
        if (!this.modelType.equals("00")) {
            item.add(new AutoLabelItem("message.acOutputPower[:]", "{workInfo.getAcOutputPowerR}", "W"));
            item.add(new AutoLabelItem("message.outputLoadPercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
            item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
            item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
            item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        }
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public MoreInfo getMoreInfo() {
        return null;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.topology[:]", "{machineInfo.getTopology}", ""));
        infos.add(new AutoLabelItem("message.mainfirewareversion[:]", "{machineInfo.getMainFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.slavefirewareversion[:]", "{machineInfo.getSlaveFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.iophase[:]", "{machineInfo.getIoPhase}", ""));
        infos.add(new AutoLabelItem("message.nominalInputVoltage[:]", "{machineInfo.getNominalInputVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominalOutputVoltage[:]", "{machineInfo.getNominalOutputVoltage}", "V"));
        if (!this.modelType.equals("00")) {
            infos.add(new AutoLabelItem("message.batteryPieceNumber[:]", "{machineInfo.getBatteryPieceNumber}", ""));
            infos.add(new AutoLabelItem("message.batteryStandVoltage[:]", "{machineInfo.getBatteryStandVoltage}", "V"));
        }
        productInfo.setInfos(infos);
        return productInfo;
    }

    @Override
    public PurchaseInfo getPurchaseInfo() {
        return null;
    }

    @Override
    public RatingInfo getRatingInfo() {
        RatingInfo ratingInfo = new RatingInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.outputRateVA[:]", "{machineInfo.getOutputRateVA}", "W"));
        if (!this.modelType.equals("00")) {
            infos.add(new AutoLabelItem("message.acVoltageL[:]", "{machineInfo.getMinACInputLowV}", "V"));
            infos.add(new AutoLabelItem("message.acVoltageH[:]", "{machineInfo.getMaxACInputHighV}", "V"));
            infos.add(new AutoLabelItem("message.acFrequencyL[:]", "{machineInfo.getMinACInputLowF}", "Hz"));
            infos.add(new AutoLabelItem("message.acfrequencyH[:]", "{machineInfo.getMaxACInputHighF}", "Hz"));
        }
        if (!this.modelType.equals("01")) {
            infos.add(new AutoLabelItem("message.acRatingVoltage[:]", "{machineInfo.getGridRatingVoltage}", "V"));
            infos.add(new AutoLabelItem("message.acRatingFrequency[:]", "{machineInfo.getGridRatingFrequency}", "Hz"));
            infos.add(new AutoLabelItem("message.gridRatingCurrent[:]", "{machineInfo.getGridRatingCurrent}", "A"));
        }
        infos.add(new AutoLabelItem("message.MPPTRatingCurrent[:]", "{machineInfo.getPerMPPTRatingCurrent}", "A"));
        if (!this.modelType.equals("00")) {
            infos.add(new AutoLabelItem("message.batteryRatingVoltage[:]", "{machineInfo.getBatteryRatingVoltage}", "V"));
        }
        ratingInfo.setInfos(infos);
        return ratingInfo;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        if (this.modelName.equals("000")) {
            if (this.modelType.equals("00")) {
                infos.add(new AutoLabelItem("message.setGOLV[:]", "{defaultData.getLowGridV}", "V"));
                infos.add(new AutoLabelItem("message.setGOHV[:]", "{defaultData.getHighGridV}", "V"));
                infos.add(new AutoLabelItem("message.setGOLF[:]", "{defaultData.getLowGridF}", "Hz"));
                infos.add(new AutoLabelItem("message.setGOHF[:]", "{defaultData.getHighGridF}", "Hz"));
            } else if (this.modelType.equals("10")) {
                infos.add(new AutoLabelItem("message.setGOLV[:]", "{defaultData.getGridInputVoltageL}", "V"));
                infos.add(new AutoLabelItem("message.setGOHV[:]", "{defaultData.getGridInputVoltageH}", "V"));
                infos.add(new AutoLabelItem("message.setGOLF[:]", "{defaultData.getGridInputFrequencyL}", "Hz"));
                infos.add(new AutoLabelItem("message.setGOHF[:]", "{defaultData.getGridInputFrequencyH}", "Hz"));
            } else {
                infos.add(new AutoLabelItem("message.acVoltageL[:]", "{defaultData.getGridInputVoltageL}", "V"));
                infos.add(new AutoLabelItem("message.acVoltageH[:]", "{defaultData.getGridInputVoltageH}", "V"));
                infos.add(new AutoLabelItem("message.acFrequencyL[:]", "{defaultData.getGridInputFrequencyL}", "Hz"));
                infos.add(new AutoLabelItem("message.acfrequencyH[:]", "{defaultData.getGridInputFrequencyH}", "Hz"));
            }
            if (!this.modelType.equals("01") && (this.deviceModel.equals("100") || this.deviceModel.equals("108") || this.deviceModel.equals("050") || this.deviceModel.equals("058"))) {
                infos.add(new AutoLabelItem("message.setGILTHV[:]", "{defaultData.getGridAvgHighV}", "V"));
            }
            infos.add(new AutoLabelItem("message.setOPMP[:]", "{defaultData.getMaxoutputPower}", "W"));
            infos.add(new AutoLabelItem("message.setPVIPLV[:]", "{defaultData.getPvInputLowV}", "V"));
            infos.add(new AutoLabelItem("message.setPVIPHV[:]", "{defaultData.getPvInputHighV}", "V"));
            infos.add(new AutoLabelItem("message.setMPPTLV[:]", "{defaultData.getMppLowV}", "V"));
            infos.add(new AutoLabelItem("message.setMPPTHV[:]", "{defaultData.getMppHighV}", "V"));
            if (!this.modelType.equals("00")) {
                infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
                infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getFloatingVoltage}", "V"));
                infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getMaxChargingVoltage}", "V"));
            }
        }
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.pepdP[:]", "message.enable", "message.disable", "{cappbility.isCapableP}", "CapableP", false));
        if (!this.modelType.equals("01") && this.getMCUVersion().compareTo(VERSION_170711) >= 0 && (this.deviceModel.equals("070") || this.deviceModel.equals("120") || this.deviceModel.equals("071") || this.deviceModel.equals("121") || this.deviceModel.equals("072") || this.deviceModel.equals("122") || this.deviceModel.equals("073") || this.deviceModel.equals("123") || this.deviceModel.equals("074") || this.deviceModel.equals("124") || this.deviceModel.equals("075") || this.deviceModel.equals("125"))) {
            list.add(new AutoRadioItem("message.fPFD[:]", "message.enable", "message.disable", "{cappbility.isCapableD}", "CapableD", false));
            list.add(new AutoRadioItem("message.fPOVD[:]", "message.enable", "message.disable", "{cappbility.isCapableE}", "CapableE", false));
            list.add(new AutoRadioItem("message.rPControl[:]", "message.enable", "message.disable", "{cappbility.isCapableF}", "CapableF", false));
        }
        if (!this.modelType.equals("00")) {
            list.add(new AutoRadioItem("message.pepdB[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
            if (this.isSupportModelSetting()) {
                list.add(new AutoRadioItem("message.GNTM[:]", "message.enable", "message.disable", "{cappbility.isGntm}", "GNTM", false));
            }
            if (this.getMCUVersion().compareTo(VERSION_140115) >= 0) {
                list.add(new AutoRadioItem("message.BatteryTypeLiFe[:]", "message.yes", "message.no", "{configData.isLiFeBattery}", "LBF", false));
            }
            list.add(new AutoRadioItem("message.wideAcInputRange[:]", "message.enable", "message.disable", "{cappbility.isCapableC}", "CapableC", false));
        }
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        if (!this.modelType.equals("00") && !this.modelType.equals("10")) {
            this.modelType.equals("11");
        }
        this.modelType.equals("01");
        list.add(new AutoSpinnerItem("message.setPVIPLV[:]", "{configData.getMinPvInputLowV}", "{configData.getMaxPvInputLowV}", "1", "{configData.getPvInputLowV}", "V", "setPVIPLV", 0, false));
        list.add(new AutoSpinnerItem("message.setPVIPHV[:]", "{configData.getMinPvInputHighV}", "{configData.getMaxPvInputHighV}", "1", "{configData.getPvInputHighV}", "V", "setPVIPHV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTLV[:]", "{configData.getMinMpptLowV}", "{configData.getMaxMpptLowV}", "1", "{configData.getMpptLowV}", "V", "setMPPTLV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTHV[:]", "{configData.getMinMpptHighV}", "{configData.getMaxMpptHighV}", "1", "{configData.getMpptHighV}", "V", "setMPPTHV", 0, false));
        if (!this.modelType.equals("00")) {
            if (this.modelName.equals("000")) {
                list.add(new AutoSpinnerItem("message.maxChargingCurrent[:]", "{configData.getMinMaxChargingCurrent}", "{configData.getMaxMaxChargingCurrent}", "5", "{configData.getMaxChargingCurrent}", "A", "setMaxChargingCurrent", 0, false));
                list.add(new AutoSpinnerItem("message.maxACchargingCurrent[:]", "{configData.getMinMaxAcChargingCurrent}", "{configData.getMaxMaxAcChargingCurrent}", "5", "{configData.getMaxAcChargingCurrent}", "A", "setMaxAcChargingCurrent", 0, false));
                list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargingVoltage}", "{configData.getMaxMaxChargingVoltage}", "0.1", "{configData.getMaxChargingVoltage}", "V", "setMaxChargingVoltage", 0, false));
                list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingVoltage}", "{configData.getMaxFloatingVoltage}", "0.1", "{configData.getFloatingVoltage}", "V", "setFloatingVoltage", 0, false));
            } else {
                list.add(new AutoSpinnerItem("message.maxChargingCurrent[:]", "{configData.getMinMaxChargingCurrent}", "{configData.getMaxMaxChargingCurrent}", "0.1", "{configData.getMaxChargingCurrent}", "A", "setMaxChargingCurrent", 0, false));
                list.add(new AutoSpinnerItem("message.maxACchargingCurrent[:]", "{configData.getMinMaxAcChargingCurrent}", "{configData.getMaxMaxAcChargingCurrent}", "0.1", "{configData.getMaxAcChargingCurrent}", "A", "setMaxAcChargingCurrent", 0, false));
                list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargingVoltage}", "{configData.getMaxMaxChargingVoltage}", "0.1", "{configData.getMaxChargingVoltage}", "V", "setMaxChargingVoltage", 0, false));
                list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingVoltage}", "{configData.getMaxFloatingVoltage}", "0.1", "{configData.getFloatingVoltage}", "V", "setFloatingVoltage", 0, false));
            }
        }
        if (!this.modelType.equals("00")) {
            if (this.isSupportModelSetting()) {
                list.add(new AutoSpinnerItem("message.cutoffVolGridOn[:]", "{configData.getMinCutoffVoltage}", "{configData.getMaxCutoffVoltage}", "0.1", "{configData.getCutoffVoltage}", "V", "setCutoffVoltage", 1, false));
                list.add(new AutoSpinnerItem("message.recoverVolGridOn[:]", "{configData.getMinRecoverVoltage}", "{configData.getMaxRecoverVoltage}", "0.1", "{configData.getRecoverVoltage}", "V", "setRecoverVoltage", 1, false));
                list.add(new AutoSpinnerItem("message.cutoffVolGridLoss[:]", "{configData.getMinCutoffVoltageGridLoss}", "{configData.getMaxCutoffVoltageGridLoss}", "0.1", "{configData.getCutoffVoltageGridLoss}", "V", "setCutoffVoltage", 0, false));
                list.add(new AutoSpinnerItem("message.recoverVolGridLoss[:]", "{configData.getMinRecoverVoltageGridLoss}", "{configData.getMaxRecoverVoltageGridLoss}", "0.1", "{configData.getRecoverVoltageGridLoss}", "V", "setRecoverVoltage", 0, false));
            }
            list.add(new AutoSpinnerItem("message.feedingGridPowerCalibration[:]", "{configData.getMinGridPowerDeviation}", "{configData.getMaxGridPowerDeviation}", "1", "{configData.getGridPowerDeviation}", "W", "setGridPowerDeviation", 0, false));
            list.add(new AutoSpinnerItem("message.batDischargeMaxCurrentInHybridMode[:]", "{configData.getMinBatDischargeMaxCurrentInHybridMode}", "{configData.getMaxBatDischargeMaxCurrentInHybridMode}", "1", "{configData.getBatDischargeMaxCurrentInHybridMode}", "A", "setBatDischargeMaxCurrentInHybridMode", 0, false));
        }
        this.getMCUVersion().compareTo(VERSION_140115);
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.gridVoltageR", "{workInfo.getGridVoltageR}", true, false));
        list.add(new HistoryData("message.pvInputPower", "{workInfo.getPvInputPower1}", true, false));
        list.add(new HistoryData("message.gridFrequency", "{workInfo.getGridFrequency}", true, true));
        if (this.modelName.isEmpty()) {
            list.add(new HistoryData("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", true, true));
        } else if (this.modelName.equals("000")) {
            list.add(new HistoryData("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", true, true));
            list.add(new HistoryData("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", true, true));
        }
        if (!this.modelType.equals("00")) {
            list.add(new HistoryData("message.acOutputPower", "{workInfo.getAcOutputPowerR}", true, true));
            list.add(new HistoryData("message.outputLoadPercent", "{workInfo.getOutputLoadPercent}", true, true));
            list.add(new HistoryData("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", true, true));
            list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
            list.add(new HistoryData("message.chargeCurrent", "{workInfo.getChargingCurrent}", true, true));
        }
        list.add(new HistoryData("message.temperature", "{workInfo.getMaxTemperature}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{faultData.getGridVoltage}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{faultData.getGridFrequency}", true, true));
        if (this.modelName.isEmpty()) {
            list.add(new HistoryData("message.pvInputVoltage", "{faultData.getPvinputvoltage1}", true, true));
        } else if (this.modelName.equals("000")) {
            list.add(new HistoryData("message.pvInputVoltage1", "{faultData.getPvinputvoltage1}", true, true));
            list.add(new HistoryData("message.pvInputVoltage2", "{faultData.getPvinputvoltage2}", true, true));
        }
        if (!this.modelType.equals("00")) {
            list.add(new HistoryData("message.outputLoadPercent", "{faultData.getOutputLoadPercent}", true, true));
            list.add(new HistoryData("message.acOutputVoltage", "{faultData.getOutputLoadVoltage}", true, true));
            list.add(new HistoryData("message.acOutputCurrent", "{faultData.getOutputLoadCurrent}", true, true));
            list.add(new HistoryData("message.acOutputFrequency", "{faultData.getOutputLoadFrequency}", true, true));
            list.add(new HistoryData("message.batteryVoltage", "{faultData.getBatteryVoltage}", true, true));
        }
        list.add(new HistoryData("message.temperature", "{faultData.getMaxTemperature}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.gridVoltageR", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.pvInputPower", "{workInfo.getPvInputPower1}", 3000.0, "W", true));
        list.add(new HistoryChart("message.gridFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        if (this.modelName.isEmpty()) {
            list.add(new HistoryChart("message.pvInputVoltage", "{workInfo.getPvInputVoltage1}", 500.0, "V", true));
        } else if (this.modelName.equals("000")) {
            list.add(new HistoryChart("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", 500.0, "V", true));
            list.add(new HistoryChart("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", 500.0, "V", true));
        }
        if (!this.modelType.equals("00")) {
            list.add(new HistoryChart("message.acOutputPower", "{workInfo.getAcOutputPowerR}", 3000.0, "W", true));
            list.add(new HistoryChart("message.outputLoadPercent", "{workInfo.getOutputLoadPercent}", 100.0, "%", true));
            list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", 500.0, "V", true));
            list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
            list.add(new HistoryChart("message.chargeCurrent", "{workInfo.getChargingCurrent}", 100.0, "A", true));
        }
        list.add(new HistoryChart("message.temperature", "{workInfo.getMaxTemperature}", 180.0, "Degree", true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public int getMpptTrackNumber() {
        return this.mpptTrackNumber;
    }

    @Override
    public void setMpptTrackNumber(int mpptTrackNumber) {
        this.mpptTrackNumber = mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        return this.serialNo;
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        if (this.isSupportModelSetting()) {
            items2.add(new AutoMenuTwo(new AutoMenuItem("message.modelchange", 200, ""), null));
        }
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.synchroEnergyData", 203, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.realTimeCtrl", 204, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryPower", 301, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        if (!this.modelName.equals("000")) {
            items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryFaultData", 303, ""), null));
        }
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.monitorPointInfo", 305, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.powerNumber", 306, ""), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Italian", 404, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", 406, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Russian", 407, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", 409, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Turkish", 410, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Japanese", 413, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        ArrayList<AutoMenuItem> items = new ArrayList<AutoMenuItem>();
        CustomerConfig custormerConfig = GlobalVariables.customerConfig;
        if (custormerConfig.isEnglish()) {
            items.add(new AutoMenuItem("English", 5021, ""));
        }
        if (custormerConfig.isTurkish()) {
            items.add(new AutoMenuItem("Turkish", 5022, ""));
        }
        if (custormerConfig.isRussian()) {
            items.add(new AutoMenuItem("Russian", 5023, ""));
        }
        if (items.size() < 2) {
            items = null;
        }
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), items));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }

    @Override
    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
        try {
            int modeid = Integer.parseInt(deviceModel);
            this.modelType = modeid >= HOMESOLAR_BASIC ? "11" : (modeid >= OFFGRID_BASIC ? "01" : (modeid >= GRIDTIE_BASIC ? "00" : "10"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public CommandParameterMap getCommandMap() {
        return this.map;
    }

    @Override
    public void initCommandMap() {
        this.map.clear();
        this.map.AddCommand("setGOLV", 1);
        this.map.AddCommand("setGOHV", 1);
        this.map.AddCommand("setGOLF", 1);
        this.map.AddCommand("setGOHF", 1);
        this.map.AddCommand("setOPMP", 1);
        this.map.AddCommand("setPVN", 1);
        this.map.AddCommand("setGridWaittime", 1);
        this.map.AddCommand("setPVIPLV", 1);
        this.map.AddCommand("setPVIPHV", 1);
        this.map.AddCommand("setMPPTLV", 1);
        this.map.AddCommand("setMPPTHV", 1);
        this.map.AddCommand("setGILTHV", 1);
        this.map.AddCommand("setGOLV", 1);
        this.map.AddCommand("setGOHV", 1);
        this.map.AddCommand("setGOLF", 1);
        this.map.AddCommand("setGOHF", 1);
        this.map.AddCommand("setMaxChargingCurrent", 1);
        this.map.AddCommand("setMaxAcChargingCurrent", 1);
        this.map.AddCommand("setFloatingVoltage", 1);
        this.map.AddCommand("setMaxChargingVoltage", 1);
        this.map.AddCommand("setMaxPowerFeedingGrid", 1);
        this.map.AddCommand("setPowerFactor", 1);
        this.map.AddCommand("setPowerPercent", 1);
        this.map.AddCommand("setPowerPFPercent", 1);
        this.map.AddCommand("setPowerPFCurve", 1);
        this.map.AddCommand("setFeedinPowerFactor", 1);
        if (this.isSupportModelSetting()) {
            this.map.AddCommand("setCutoffVoltage", 2);
            this.map.AddCommand("setRecoverVoltage", 2);
            this.map.AddCommand("setLiBatterySetting", 3);
        }
        this.map.AddCommand("setGridPowerDeviation", 1);
        this.map.AddCommand("setBatDischargeMaxCurrentInHybridMode", 1);
        this.map.AddCommand("setFeefInReactivePower", 1);
        this.relalist.clear();
        if (!this.modelName.equals("000")) {
            this.relalist.add(new ControlRelation("setMaxChargingVoltage", 0, "setFloatingVoltage", 0, ControlRelation.RELATION_MAX));
            this.relalist.add(new ControlRelation("setFloatingVoltage", 0, "setMaxChargingVoltage", 0, ControlRelation.RELATION_MIN));
        }
        if (this.isSupportModelSetting()) {
            if (!this.modelName.equals("000")) {
                this.relalist.add(new ControlRelation("setFloatingVoltage", 0, "setRecoverVoltage", 0, ControlRelation.RELATION_MAX));
                this.relalist.add(new ControlRelation("setFloatingVoltage", 0, "setRecoverVoltage", 1, ControlRelation.RELATION_MAX));
                this.relalist.add(new ControlRelation("setFloatingVoltage", 0, "setLiBatterySetting", 1, ControlRelation.RELATION_MAX));
            }
            this.relalist.add(new ControlRelation("setRecoverVoltage", 0, "setFloatingVoltage", 0, ControlRelation.RELATION_MIN));
            this.relalist.add(new ControlRelation("setRecoverVoltage", 1, "setFloatingVoltage", 0, ControlRelation.RELATION_MIN));
            this.relalist.add(new ControlRelation("setLiBatterySetting", 1, "setFloatingVoltage", 0, ControlRelation.RELATION_MIN));
            this.relalist.add(new ControlRelation("setMaxChargingCurrent", 0, "setLiBatterySetting", 0, ControlRelation.RELATION_MAX));
            this.relalist.add(new ControlRelation("setLiBatterySetting", 0, "setMaxChargingCurrent", 0, ControlRelation.RELATION_MIN));
            if (!this.modelName.equals("000")) {
                this.relalist.add(new ControlRelation("setCutoffVoltage", 0, "setRecoverVoltage", 0, ControlRelation.RELATION_MIN));
                this.relalist.add(new ControlRelation("setCutoffVoltage", 1, "setRecoverVoltage", 1, ControlRelation.RELATION_MIN));
                this.relalist.add(new ControlRelation("setRecoverVoltage", 0, "setCutoffVoltage", 0, ControlRelation.RELATION_MAX));
                this.relalist.add(new ControlRelation("setRecoverVoltage", 1, "setCutoffVoltage", 1, ControlRelation.RELATION_MAX));
            }
        }
    }

    @Override
    public List<ControlRelation> getRelationList() {
        return this.relalist;
    }

    @Override
    public boolean isSupportModelSetting() {
        return this.supportModelSetting;
    }

    public void setSupportModelSetting(boolean supportModelSetting) {
        this.supportModelSetting = supportModelSetting;
    }

    @Override
    public String getDSPVersion() {
        return this.dspversion;
    }

    @Override
    public String getMCUVersion() {
        return this.mcuversion;
    }

    @Override
    public SpinnerParameter getFactoryParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        if (this.modelType.equals("00")) {
            list.add(new AutoSpinnerItem("message.setGOLV[:]", "{configData.getMinGridoutputlowV}", "{configData.getMaxGridoutputlowV}", "0.1", "{configData.getGridoutputlowV}", "V", "setGOLV", 0, false));
            list.add(new AutoSpinnerItem("message.setGOHV[:]", "{configData.getMinGridoutputhighV}", "{configData.getMaxGridoutputhighV}", "0.1", "{configData.getGridoutputhighV}", "V", "setGOHV", 0, false));
            list.add(new AutoSpinnerItem("message.setGOLF[:]", "{configData.getMinGridoutputlowF}", "{configData.getMaxGridoutputlowF}", "0.1", "{configData.getGridoutputlowF}", "Hz", "setGOLF", 0, false));
            list.add(new AutoSpinnerItem("message.setGOHF[:]", "{configData.getMinGridoutputhighF}", "{configData.getMaxGridoutputhighF}", "0.1", "{configData.getGridoutputhighF}", "Hz", "setGOHF", 0, false));
            list.add(new AutoSpinnerItem("message.setGridwaittime[:]", "{configData.getMinGridWaittime}", "{configData.getMaxGridWaittime}", "1", "{configData.getGridwaittime}", "message.seconds", "setGridWaittime", 0, false));
            if (this.getMCUVersion().compareTo(VERSION_170711) >= 0) {
                list.add(new AutoSpinnerItem("message.feef-inReactivePower[:]", "{configData.getMinfeefInReactivePower}", "{configData.getMaxfeefInReactivePower}", "1", "{configData.getFeefInReactivePower}", "Var", "setFeefInReactivePower", 0, false));
            }
        } else if (this.modelType.equals("10") || this.modelType.equals("11")) {
            list.add(new AutoSpinnerItem("message.setGOLV[:]", "{configData.getMinGridInputLowV}", "{configData.getMaxGridInputLowV}", "0.1", "{configData.getGridInputLowV}", "V", "setGOLV", 0, false));
            list.add(new AutoSpinnerItem("message.setGOHV[:]", "{configData.getMinGridInputHighV}", "{configData.getMaxGridInputHighV}", "0.1", "{configData.getGridInputHighV}", "V", "setGOHV", 0, false));
            list.add(new AutoSpinnerItem("message.setGOLF[:]", "{configData.getMinGridInputLowF}", "{configData.getMaxGridInputLowF}", "0.1", "{configData.getGridInputLowF}", "Hz", "setGOLF", 0, false));
            list.add(new AutoSpinnerItem("message.setGOHF[:]", "{configData.getMinGridInputHighF}", "{configData.getMaxGridInputHighF}", "0.1", "{configData.getGridInputHighF}", "Hz", "setGOHF", 0, false));
            list.add(new AutoSpinnerItem("message.setGridwaittime[:]", "{configData.getMinGridWaittime}", "{configData.getMaxGridWaittime}", "1", "{configData.getGridwaittime}", "message.seconds", "setGridWaittime", 0, false));
            if (this.getMCUVersion().compareTo(VERSION_170711) >= 0) {
                list.add(new AutoSpinnerItem("message.feef-inReactivePower[:]", "{configData.getMinfeefInReactivePower}", "{configData.getMaxfeefInReactivePower}", "1", "{configData.getFeefInReactivePower}", "Var", "setFeefInReactivePower", 0, false));
            }
        }
        if (!this.modelType.equals("01")) {
            if (this.deviceModel.equals("100") || this.deviceModel.equals("108") || this.deviceModel.equals("050") || this.deviceModel.equals("058")) {
                list.add(new AutoSpinnerItem("message.setGILTHV[:]", "{configData.getMinGridAvgHighV}", "{configData.getMaxGridAvgHighV}", "1", "{configData.getGridAvgHighV}", "V", "setGILTHV", 0, false));
            }
            if (this.getMCUVersion().compareTo(VERSION_170711) >= 0 && (this.deviceModel.equals("070") || this.deviceModel.equals("120") || this.deviceModel.equals("071") || this.deviceModel.equals("121") || this.deviceModel.equals("072") || this.deviceModel.equals("122") || this.deviceModel.equals("073") || this.deviceModel.equals("123") || this.deviceModel.equals("074") || this.deviceModel.equals("124") || this.deviceModel.equals("075") || this.deviceModel.equals("125"))) {
                list.add(new AutoSpinnerItem("message.setGILTHV[:]", "{configData.getMinGridAvgHighV}", "{configData.getMaxGridAvgHighV}", "1", "{configData.getGridAvgHighV}", "V", "setGILTHV", 0, false));
            }
        }
        if (!this.modelType.equals("01") && this.isSupportModelSetting()) {
            list.add(new AutoSpinnerItem("message.maxPowerFeedingGrid[:]", "{configData.getMinPowerFeedGrid}", "{configData.getMaxPowerFeedGrid}", "10", "{configData.getPowerfeedGrid}", "W", "setMaxPowerFeedingGrid", 0, false));
            list.add(new AutoSpinnerItem("message.feedinPowerFactor[:]", "{configData.getMinFeedinPowerFactor}", "{configData.getMaxFeedinPowerFactor}", "0.01", "{configData.getFeedinPowerFactor}", "", "setFeedinPowerFactor", 0, false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public List<String> spinnerValueRelate() {
        ArrayList<String> controlNames = new ArrayList<String>();
        controlNames.add("setFloatingVoltage+0");
        controlNames.add("setRecoverVoltage+1");
        controlNames.add("setRecoverVoltage+0");
        return controlNames;
    }

    @Override
    public EnableSpinnerParameter getEnableSpinnerParameter() {
        return null;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        return null;
    }

    @Override
    public int getOutputMode() {
        return 0;
    }

    @Override
    public void setOutputMode(int outputmode) {
    }
}

