/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.apache.log4j.spi.LoggingEvent;

public class BoundedFIFO {
    LoggingEvent[] buf;
    int numElements = 0;
    int first = 0;
    int next = 0;
    int maxSize;

    public BoundedFIFO(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + n + ") is not a positive integer.");
        }
        this.maxSize = n;
        this.buf = new LoggingEvent[n];
    }

    public LoggingEvent get() {
        if (this.numElements == 0) {
            return null;
        }
        LoggingEvent loggingEvent = this.buf[this.first];
        this.buf[this.first] = null;
        if (++this.first == this.maxSize) {
            this.first = 0;
        }
        --this.numElements;
        return loggingEvent;
    }

    public void put(LoggingEvent loggingEvent) {
        if (this.numElements != this.maxSize) {
            this.buf[this.next] = loggingEvent;
            if (++this.next == this.maxSize) {
                this.next = 0;
            }
            ++this.numElements;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isFull() {
        return this.numElements == this.maxSize;
    }

    public int length() {
        return this.numElements;
    }

    int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public synchronized void resize(int n) {
        if (n == this.maxSize) {
            return;
        }
        LoggingEvent[] loggingEventArray = new LoggingEvent[n];
        int n2 = this.maxSize - this.first;
        n2 = this.min(n2, n);
        n2 = this.min(n2, this.numElements);
        System.arraycopy(this.buf, this.first, loggingEventArray, 0, n2);
        int n3 = 0;
        if (n2 < this.numElements && n2 < n) {
            n3 = this.numElements - n2;
            n3 = this.min(n3, n - n2);
            System.arraycopy(this.buf, 0, loggingEventArray, n2, n3);
        }
        this.buf = loggingEventArray;
        this.maxSize = n;
        this.first = 0;
        this.next = this.numElements = n2 + n3;
        if (this.next == this.maxSize) {
            this.next = 0;
        }
    }

    public boolean wasEmpty() {
        return this.numElements == 1;
    }

    public boolean wasFull() {
        return this.numElements + 1 == this.maxSize;
    }
}

