/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class JTattooUtilities {
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    private static final boolean isOS2 = System.getProperty("os.name").toLowerCase().indexOf("os/2") != -1;
    private static final boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    private static final boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
    private static final boolean isSunOS = System.getProperty("os.name").toLowerCase().indexOf("sunos") != -1;
    private static final boolean isAIX = System.getProperty("os.name").toLowerCase().indexOf("aix") != -1;
    private static final boolean isHPUX = System.getProperty("os.name").toLowerCase().indexOf("hpux") != -1;
    private static final boolean isFreeBSD = System.getProperty("os.name").toLowerCase().indexOf("freebsd") != -1;
    private static final boolean isHiresScreen = Toolkit.getDefaultToolkit().getScreenSize().width > 1280;
    private static Double javaVersion = null;
    private static final String ELLIPSIS = "...";
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$java$awt$Graphics;
    static /* synthetic */ Class class$java$lang$String;

    public static double getJavaVersion() {
        if (javaVersion == null) {
            try {
                String string = System.getProperties().getProperty("java.version");
                String string2 = "";
                boolean bl = true;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == '.') {
                        if (bl) {
                            string2 = string2 + string.charAt(i);
                        }
                        bl = false;
                        continue;
                    }
                    if (!Character.isDigit(string.charAt(i))) continue;
                    string2 = string2 + string.charAt(i);
                }
                javaVersion = new Double(string2);
            }
            catch (Exception exception) {
                javaVersion = new Double(1.3);
            }
        }
        return javaVersion;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isOS2() {
        return isOS2;
    }

    public static boolean isMac() {
        return isMac;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isSunOS() {
        return isSunOS;
    }

    public static boolean isAIX() {
        return isAIX;
    }

    public static boolean isHPUX() {
        return isHPUX;
    }

    public static boolean isFreeBSD() {
        return isFreeBSD;
    }

    public static boolean isHiresScreen() {
        return isHiresScreen;
    }

    public static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    public static boolean isActive(JComponent jComponent) {
        if (jComponent == null) {
            return false;
        }
        boolean bl = true;
        if (jComponent instanceof JInternalFrame) {
            bl = ((JInternalFrame)jComponent).isSelected();
        }
        if (bl) {
            for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JInternalFrame)) continue;
                bl = ((JInternalFrame)container).isSelected();
                break;
            }
        }
        if (bl) {
            bl = JTattooUtilities.isFrameActive(jComponent);
        }
        return bl;
    }

    public static boolean isFrameActive(JComponent jComponent) {
        if (jComponent == null) {
            return false;
        }
        if (jComponent.getTopLevelAncestor() instanceof Window) {
            return JTattooUtilities.isWindowActive((Window)jComponent.getTopLevelAncestor());
        }
        return true;
    }

    public static boolean isWindowActive(Window window) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            try {
                Class<?>[] classArray = null;
                Object[] objectArray = null;
                Method method = window.getClass().getMethod("isActive", classArray);
                Boolean bl = (Boolean)method.invoke((Object)window, objectArray);
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static Container getRootContainer(Component component) {
        if (component != null) {
            Container container;
            for (container = component.getParent(); !(container == null || container instanceof JPopupMenu || container instanceof JInternalFrame || container instanceof Window || container.getParent() == null); container = container.getParent()) {
            }
            return container;
        }
        return null;
    }

    public static Dimension getFrameSize(Component component) {
        Container container = JTattooUtilities.getRootContainer(component);
        if (container != null) {
            return container.getSize();
        }
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Point getRelLocation(Component component) {
        if (component == null || !component.isShowing()) {
            return new Point(0, 0);
        }
        Container container = JTattooUtilities.getRootContainer(component);
        if (container != null && container.isShowing()) {
            Point point = component.getLocationOnScreen();
            Point point2 = container.getLocationOnScreen();
            return new Point(point.x - point2.x, point.y - point2.y);
        }
        return new Point(0, 0);
    }

    public static String getClippedText(String string, FontMetrics fontMetrics, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        if (n2 > n) {
            int n3 = SwingUtilities.computeStringWidth(fontMetrics, ELLIPSIS);
            for (int i = 0; i < string.length(); ++i) {
                if ((n3 += fontMetrics.charWidth(string.charAt(i))) <= n) continue;
                return string.substring(0, i) + ELLIPSIS;
            }
        }
        return string;
    }

    public static int findDisplayedMnemonicIndex(String string, int n) {
        if (string == null || n == 0) {
            return -1;
        }
        char c = Character.toUpperCase((char)n);
        char c2 = Character.toLowerCase((char)n);
        int n2 = string.indexOf(c);
        int n3 = string.indexOf(c2);
        if (n2 == -1) {
            return n3;
        }
        if (n3 == -1) {
            return n2;
        }
        return n3 < n2 ? n3 : n2;
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            try {
                Class<?> clazz = Class.forName("sun.swing.SwingUtilities2");
                Class[] classArray = new Class[]{class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = JTattooUtilities.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, class$java$awt$Graphics == null ? (class$java$awt$Graphics = JTattooUtilities.class$("java.awt.Graphics")) : class$java$awt$Graphics, class$java$lang$String == null ? (class$java$lang$String = JTattooUtilities.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE};
                Method method = clazz.getMethod("drawString", classArray);
                Object[] objectArray = new Object[]{jComponent, graphics, string, new Integer(n), new Integer(n2)};
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                graphics.drawString(string, n, n2);
            }
        } else {
            graphics.drawString(string, n, n2);
        }
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        if (JTattooUtilities.getJavaVersion() >= 1.6) {
            try {
                Class<?> clazz = Class.forName("sun.swing.SwingUtilities2");
                Class[] classArray = new Class[]{class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = JTattooUtilities.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, class$java$awt$Graphics == null ? (class$java$awt$Graphics = JTattooUtilities.class$("java.awt.Graphics")) : class$java$awt$Graphics, class$java$lang$String == null ? (class$java$lang$String = JTattooUtilities.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Method method = clazz.getMethod("drawStringUnderlineCharAt", classArray);
                Object[] objectArray = new Object[]{jComponent, graphics, string, new Integer(n), new Integer(n2), new Integer(n3)};
                method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                BasicGraphicsUtils.drawString(graphics, string, n, n2, n3);
            }
        } else if (JTattooUtilities.getJavaVersion() >= 1.4) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, n2, n3);
        } else {
            BasicGraphicsUtils.drawString(graphics, string, n, n2, n3);
        }
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static void fillHorGradient(Graphics graphics, Color[] colorArray, int n, int n2, int n3, int n4) {
        int n5 = colorArray.length;
        double d = (double)n4 / (double)n5;
        if (d <= 3.001) {
            int n6 = n2;
            for (int i = 0; i < n5; ++i) {
                int n7 = n2 + (int)Math.round((double)i * d);
                graphics.setColor(colorArray[i]);
                if (i == n5 - 1) {
                    graphics.fillRect(n, n6, n3, n2 + n4 - n6);
                } else {
                    graphics.fillRect(n, n6, n3, n7 - n6);
                }
                n6 = n7;
            }
        } else {
            JTattooUtilities.smoothFillHorGradient(graphics, colorArray, n, n2, n3, n4);
        }
    }

    public static void smoothFillHorGradient(Graphics graphics, Color[] colorArray, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = colorArray.length;
        double d = (double)n4 / (double)(n5 - 1);
        int n6 = n2;
        for (int i = 0; i < n5; ++i) {
            int n7 = n2 + (int)Math.round((double)i * d);
            if (i == n5 - 1) {
                graphics2D.setPaint(null);
                graphics2D.setColor(colorArray[i]);
                graphics.fillRect(n, n6, n3, n2 + n4 - n6);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, n6, colorArray[i], 0.0f, n7, colorArray[i + 1]));
                graphics.fillRect(n, n6, n3, n7 - n6);
            }
            n6 = n7;
        }
    }

    public static void fillInverseHorGradient(Graphics graphics, Color[] colorArray, int n, int n2, int n3, int n4) {
        int n5 = colorArray.length;
        double d = (double)n4 / (double)n5;
        if (d <= 3.001) {
            int n6 = n2;
            for (int i = 0; i < n5; ++i) {
                int n7 = n2 + (int)Math.round((double)i * d);
                graphics.setColor(colorArray[colorArray.length - i - 1]);
                if (i == n5 - 1) {
                    graphics.fillRect(n, n6, n3, n2 + n4 - n6);
                } else {
                    graphics.fillRect(n, n6, n3, n7 - n6);
                }
                n6 = n7;
            }
        } else {
            JTattooUtilities.smoothFillInverseHorGradient(graphics, colorArray, n, n2, n3, n4);
        }
    }

    public static void smoothFillInverseHorGradient(Graphics graphics, Color[] colorArray, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = colorArray.length;
        double d = (double)n4 / (double)n5;
        int n6 = n2;
        for (int i = 0; i < n5; ++i) {
            int n7 = n2 + (int)Math.round((double)i * d);
            graphics.setColor(colorArray[colorArray.length - i - 1]);
            if (i == n5 - 1) {
                graphics2D.setPaint(null);
                graphics2D.setColor(colorArray[colorArray.length - i - 1]);
                graphics.fillRect(n, n6, n3, n2 + n4 - n6);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, n6, colorArray[colorArray.length - i - 1], 0.0f, n7, colorArray[colorArray.length - i - 2]));
                graphics.fillRect(n, n6, n3, n7 - n6);
            }
            n6 = n7;
        }
    }

    public static void fillVerGradient(Graphics graphics, Color[] colorArray, int n, int n2, int n3, int n4) {
        int n5 = colorArray.length;
        double d = (double)n3 / (double)n5;
        int n6 = n;
        for (int i = 0; i < n5; ++i) {
            int n7 = n + (int)Math.round((double)i * d);
            graphics.setColor(colorArray[i]);
            if (i == n5 - 1) {
                graphics.fillRect(n6, n2, n + n3 - n6, n4);
            } else {
                graphics.fillRect(n6, n2, n7 - n6, n4);
            }
            n6 = n7;
        }
    }

    public static void fillInverseVerGradient(Graphics graphics, Color[] colorArray, int n, int n2, int n3, int n4) {
        int n5 = colorArray.length;
        double d = (double)n3 / (double)n5;
        int n6 = n;
        for (int i = 0; i < n5; ++i) {
            int n7 = n + (int)Math.round((double)i * d);
            graphics.setColor(colorArray[colorArray.length - i - 1]);
            if (i == n5 - 1) {
                graphics.fillRect(n6, n2, n + n3 - n6, n4);
            } else {
                graphics.fillRect(n6, n2, n7 - n6, n4);
            }
            n6 = n7;
        }
    }

    public static void drawBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    public static void draw3DBorder(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        graphics.setColor(color);
        graphics.drawLine(n, n2, n5 - 1, n2);
        graphics.drawLine(n, n2 + 1, n, n6);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n6, n5 - 1, n6);
        graphics.drawLine(n5, n2, n5, n6);
    }

    public static void drawRoundBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 1, n5, n5);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static void drawRound3DBorder(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = n4;
        int n8 = n4 / 2;
        Color color3 = ColorHelper.median(color, color2);
        Color color4 = ColorHelper.median(color, color3);
        Color color5 = ColorHelper.median(color2, color3);
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.drawLine(n + n8, n2, n5 - n8, n2);
        graphics2D.drawLine(n, n2 + n8, n, n6 - n8);
        graphics2D.setColor(color2);
        graphics2D.drawLine(n + n8, n6, n5 - n8, n6);
        graphics2D.drawLine(n5, n2 + n8, n5, n6 - n8);
        graphics2D.setColor(color);
        graphics2D.drawArc(n, n2, n7, n7, 90, 45);
        graphics2D.setColor(color4);
        graphics2D.drawArc(n, n2, n7, n7, 135, 45);
        graphics2D.setColor(color3);
        graphics2D.drawArc(n, n2, n7, n7, 180, 45);
        graphics2D.setColor(color5);
        graphics2D.drawArc(n, n2, n7, n7, 225, 45);
        graphics2D.setColor(color4);
        graphics2D.drawArc(n5 - n7, n2, n7, n7, 45, 45);
        graphics2D.setColor(color3);
        graphics2D.drawArc(n5 - n7, n2, n7, n7, 0, 45);
        graphics2D.setColor(color5);
        graphics2D.drawArc(n5 - n7, n2, n7, n7, -45, 45);
        graphics2D.setColor(color2);
        graphics2D.drawArc(n5 - n7, n2, n7, n7, -90, 45);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

