/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.platform;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LocalizedStrings {
    private static final Logger log = Logger.getLogger(LocalizedStrings.class.getName());
    private static ResourceBundle.Control utfResourceBundleControl = new EncodingResourceBundleControl("utf-8");
    private static String baseName;

    private LocalizedStrings() {
    }

    public static void setResourceBundleBaseName(String string) {
        baseName = string;
    }

    public static String getLocalizedProperty(String string) {
        log.log(Level.FINE, "Get property: " + string);
        try {
            String string2;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, Locale.getDefault(), utfResourceBundleControl);
            if (resourceBundle != null && (string2 = resourceBundle.getString(string)) != null && string2.trim().length() > 0) {
                log.log(Level.FINE, "Property value: " + string2);
                return string2.trim();
            }
        }
        catch (Exception exception) {
            log.log(Level.FINE, "exception thrown during bundle initialization", exception);
        }
        log.log(Level.FINE, "Unknown property value");
        return null;
    }

    private static class EncodingResourceBundleControl
    extends ResourceBundle.Control {
        private String encoding;

        public EncodingResourceBundleControl(String string) {
            this.encoding = string;
        }

        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            String string3 = this.toBundleName(string, locale);
            String string4 = this.toResourceName(string3, "properties");
            URL uRL = classLoader.getResource(string4);
            if (uRL != null) {
                try {
                    return new PropertyResourceBundle(new InputStreamReader(uRL.openStream(), this.encoding));
                }
                catch (Exception exception) {
                    log.log(Level.FINE, "exception thrown during bundle initialization", exception);
                }
            }
            return super.newBundle(string, locale, string2, classLoader, bl);
        }
    }
}

