/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.hifi.HiFiIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;

public class HiFiComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new HiFiComboBoxUI();
    }

    public JButton createArrowButton() {
        NoFocusButton noFocusButton = new NoFocusButton(HiFiIcons.getComboBoxIcon());
        noFocusButton.setBorder(new ArrowButtonBorder());
        return noFocusButton;
    }

    protected void setButtonBorder() {
    }

    static class ArrowButtonBorder
    extends AbstractBorder {
        private static final Insets insets = new Insets(1, 3, 1, 2);
        private static final Color frameLoColor = new Color(120, 120, 120);
        private static final Color frameLowerColor = new Color(96, 96, 96);
        private static final Color frameLowerLoColor = new Color(64, 64, 64);
        private static final Color frameLowestColor = new Color(32, 32, 32);

        ArrowButtonBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.translate(n, n2);
            graphics.setColor(frameLoColor);
            graphics.drawLine(1, 0, n3 - 1, 0);
            graphics.drawLine(1, 1, 1, n4 - 2);
            graphics.setColor(frameLowerColor);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 2);
            graphics.drawLine(2, n4 - 1, n3 - 2, n4 - 1);
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
            graphics2D.setComposite(alphaComposite);
            graphics.setColor(frameLowestColor);
            graphics.drawLine(2, 1, n3 - 2, 1);
            graphics.drawLine(2, 2, 2, n4 - 3);
            graphics.setColor(frameLowerLoColor);
            graphics.drawLine(0, 0, 0, n4);
            graphics2D.setComposite(composite);
            graphics.translate(-n, -n2);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }
}

