/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.scene.transform.Transform;

public class Shear
extends Transform {
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty pivotX;
    private DoubleProperty pivotY;

    public Shear() {
    }

    public Shear(double d, double d2) {
        this.setX(d);
        this.setY(d2);
    }

    public Shear(double d, double d2, double d3, double d4) {
        this.setX(d);
        this.setY(d2);
        this.setPivotX(d3);
        this.setPivotY(d4);
    }

    public final void setX(double d) {
        this.xProperty().set(d);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Shear.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Shear.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double d) {
        this.yProperty().set(d);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Shear.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Shear.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setPivotX(double d) {
        this.pivotXProperty().set(d);
    }

    public final double getPivotX() {
        return this.pivotX == null ? 0.0 : this.pivotX.get();
    }

    public final DoubleProperty pivotXProperty() {
        if (this.pivotX == null) {
            this.pivotX = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Shear.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Shear.this;
                }

                @Override
                public String getName() {
                    return "pivotX";
                }
            };
        }
        return this.pivotX;
    }

    public final void setPivotY(double d) {
        this.pivotYProperty().set(d);
    }

    public final double getPivotY() {
        return this.pivotY == null ? 0.0 : this.pivotY.get();
    }

    public final DoubleProperty pivotYProperty() {
        if (this.pivotY == null) {
            this.pivotY = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    Shear.this.transformChanged();
                }

                @Override
                public Object getBean() {
                    return Shear.this;
                }

                @Override
                public String getName() {
                    return "pivotY";
                }
            };
        }
        return this.pivotY;
    }

    @Override
    public double getMxy() {
        return this.getX();
    }

    @Override
    public double getMyx() {
        return this.getY();
    }

    @Override
    public double getTx() {
        return -this.getX() * this.getPivotY();
    }

    @Override
    public double getTy() {
        return -this.getY() * this.getPivotX();
    }

    @Override
    @Deprecated
    public void impl_apply(Affine3D affine3D) {
        if (this.getPivotX() != 0.0 || this.getPivotY() != 0.0) {
            affine3D.translate(this.getPivotX(), this.getPivotY());
            affine3D.shear(this.getX(), this.getY());
            affine3D.translate(-this.getPivotX(), -this.getPivotY());
        } else {
            affine3D.shear(this.getX(), this.getY());
        }
    }

    @Override
    @Deprecated
    public Transform impl_copy() {
        return new Shear(this.getX(), this.getY(), this.getPivotX(), this.getPivotY());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Shear [");
        stringBuilder.append("x=").append(this.getX());
        stringBuilder.append(", y=").append(this.getY());
        stringBuilder.append(", pivotX=").append(this.getPivotX());
        stringBuilder.append(", pivotY=").append(this.getPivotY());
        return stringBuilder.append("]").toString();
    }
}

