/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.core.io.Resource;

public abstract class AbstractResource
implements Resource {
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (IOException iOException) {
            try {
                InputStream inputStream = this.getInputStream();
                inputStream.close();
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL");
    }

    public File getFile() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public Resource createRelative(String string) throws IOException {
        throw new FileNotFoundException("Cannot create a relative resource for " + this.getDescription());
    }

    public String getFilename() throws IllegalStateException {
        throw new IllegalStateException(this.getDescription() + " does not carry a filename");
    }

    public abstract String getDescription();

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Resource && ((Resource)object).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }
}

