/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.Mergeable;
import org.springframework.core.CollectionFactory;

public class ManagedSet
implements Set,
Mergeable,
BeanMetadataElement {
    private final Set targetSet;
    private Object source;
    private boolean mergeEnabled;

    public ManagedSet() {
        this(16);
    }

    public ManagedSet(int n) {
        this.targetSet = CollectionFactory.createLinkedSetIfPossible((int)n);
    }

    public ManagedSet(Set set) {
        this.targetSet = set;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public void setMergeEnabled(boolean bl) {
        this.mergeEnabled = bl;
    }

    public boolean isMergeEnabled() {
        return this.mergeEnabled;
    }

    public Object merge(Object object) {
        if (!this.mergeEnabled) {
            throw new IllegalStateException("Not allowed to merge when the 'mergeEnabled' property is set to 'false'");
        }
        if (object == null) {
            return this;
        }
        if (!(object instanceof Set)) {
            throw new IllegalArgumentException("Cannot merge with object of type [" + object.getClass() + "]");
        }
        ManagedSet managedSet = new ManagedSet();
        managedSet.addAll((Set)object);
        managedSet.addAll(this);
        return managedSet;
    }

    public int size() {
        return this.targetSet.size();
    }

    public boolean isEmpty() {
        return this.targetSet.isEmpty();
    }

    public boolean contains(Object object) {
        return this.targetSet.contains(object);
    }

    public Iterator iterator() {
        return this.targetSet.iterator();
    }

    public Object[] toArray() {
        return this.targetSet.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.targetSet.toArray(objectArray);
    }

    public boolean add(Object object) {
        return this.targetSet.add(object);
    }

    public boolean remove(Object object) {
        return this.targetSet.remove(object);
    }

    public boolean containsAll(Collection collection) {
        return this.targetSet.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.targetSet.addAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.targetSet.retainAll(collection);
    }

    public boolean removeAll(Collection collection) {
        return this.targetSet.removeAll(collection);
    }

    public void clear() {
        this.targetSet.clear();
    }

    public int hashCode() {
        return ((Object)this.targetSet).hashCode();
    }

    public boolean equals(Object object) {
        return ((Object)this.targetSet).equals(object);
    }

    public String toString() {
        return this.targetSet.toString();
    }
}

