/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.net.InetAddress;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusUDPTransport;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.UDPSlaveTerminal;

public class ModbusUDPListener {
    private UDPSlaveTerminal m_Terminal;
    private ModbusUDPHandler m_Handler;
    private Thread m_HandlerThread;
    private int m_Port = 502;
    private boolean m_Listening;
    private InetAddress m_Interface;

    public ModbusUDPListener() {
    }

    public ModbusUDPListener(InetAddress ifc) {
        this.m_Interface = ifc;
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int port) {
        this.m_Port = port > 0 ? port : 502;
    }

    public void start() {
        try {
            this.m_Terminal = this.m_Interface == null ? new UDPSlaveTerminal(InetAddress.getLocalHost()) : new UDPSlaveTerminal(this.m_Interface);
            this.m_Terminal.setLocalPort(this.m_Port);
            this.m_Terminal.activate();
            this.m_Handler = new ModbusUDPHandler(this.m_Terminal.getModbusTransport());
            this.m_HandlerThread = new Thread(this.m_Handler);
            this.m_HandlerThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Listening = true;
    }

    public void stop() {
        this.m_Terminal.deactivate();
        this.m_Handler.stop();
        this.m_Listening = false;
    }

    public boolean isListening() {
        return this.m_Listening;
    }

    class ModbusUDPHandler
    implements Runnable {
        private ModbusUDPTransport m_Transport;
        private boolean m_Continue = true;

        public ModbusUDPHandler(ModbusUDPTransport transport) {
            this.m_Transport = transport;
        }

        @Override
        public void run() {
            try {
                try {
                    do {
                        ModbusRequest request = this.m_Transport.readRequest();
                        ModbusResponse response = null;
                        response = ModbusCoupler.getReference().getProcessImage() == null ? request.createExceptionResponse(1) : request.createResponse();
                        if (Modbus.debug) {
                            System.out.println("Request:" + request.getHexMessage());
                        }
                        if (Modbus.debug) {
                            System.out.println("Response:" + response.getHexMessage());
                        }
                        this.m_Transport.writeMessage(response);
                    } while (this.m_Continue);
                }
                catch (ModbusIOException ex) {
                    if (!ex.isEOF()) {
                        ex.printStackTrace();
                    }
                    try {
                        ModbusUDPListener.this.m_Terminal.deactivate();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    ModbusUDPListener.this.m_Terminal.deactivate();
                }
                catch (Exception exception) {}
            }
        }

        public void stop() {
            this.m_Continue = false;
        }
    }
}

