/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

import java.util.Properties;

public class SerialParameters {
    private String m_PortName;
    private int m_BaudRate;
    private int m_FlowControlIn;
    private int m_FlowControlOut;
    private int m_Databits;
    private int m_Stopbits;
    private int m_Parity;
    private String m_Encoding;
    private boolean m_Echo;
    private int m_ReceiveTimeout;

    public SerialParameters() {
        this.m_PortName = "";
        this.m_BaudRate = 9600;
        this.m_FlowControlIn = 0;
        this.m_FlowControlOut = 0;
        this.m_Databits = 8;
        this.m_Stopbits = 1;
        this.m_Parity = 0;
        this.m_Encoding = "ascii";
        this.m_ReceiveTimeout = 500;
        this.m_Echo = false;
    }

    public SerialParameters(String portName, int baudRate, int flowControlIn, int flowControlOut, int databits, int stopbits, int parity, boolean echo, int timeout) {
        this.m_PortName = portName;
        this.m_BaudRate = baudRate;
        this.m_FlowControlIn = flowControlIn;
        this.m_FlowControlOut = flowControlOut;
        this.m_Databits = databits;
        this.m_Stopbits = stopbits;
        this.m_Parity = parity;
        this.m_Echo = echo;
        this.m_ReceiveTimeout = timeout;
    }

    public SerialParameters(Properties props, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.setPortName(props.getProperty(String.valueOf(prefix) + "portName", ""));
        this.setBaudRate(props.getProperty(String.valueOf(prefix) + "baudRate", "9600"));
        this.setFlowControlIn(props.getProperty(String.valueOf(prefix) + "flowControlIn", "0"));
        this.setFlowControlOut(props.getProperty(String.valueOf(prefix) + "flowControlOut", "0"));
        this.setParity(props.getProperty(String.valueOf(prefix) + "parity", "0"));
        this.setDatabits(props.getProperty(String.valueOf(prefix) + "databits", "8"));
        this.setStopbits(props.getProperty(String.valueOf(prefix) + "stopbits", "1"));
        this.setEncoding(props.getProperty(String.valueOf(prefix) + "encoding", "ascii"));
        this.setEcho("true".equals(props.getProperty(String.valueOf(prefix) + "echo")));
        this.setReceiveTimeout(props.getProperty(String.valueOf(prefix) + "timeout", "500"));
    }

    public void setPortName(String name) {
        this.m_PortName = name;
    }

    public String getPortName() {
        return this.m_PortName;
    }

    public void setBaudRate(int rate) {
        this.m_BaudRate = rate;
    }

    public void setBaudRate(String rate) {
        this.m_BaudRate = Integer.parseInt(rate);
    }

    public int getBaudRate() {
        return this.m_BaudRate;
    }

    public String getBaudRateString() {
        return Integer.toString(this.m_BaudRate);
    }

    public void setFlowControlIn(int flowcontrol) {
        this.m_FlowControlIn = flowcontrol;
    }

    public void setFlowControlIn(String flowcontrol) {
        this.m_FlowControlIn = this.stringToFlow(flowcontrol);
    }

    public int getFlowControlIn() {
        return this.m_FlowControlIn;
    }

    public String getFlowControlInString() {
        return this.flowToString(this.m_FlowControlIn);
    }

    public void setFlowControlOut(int flowControlOut) {
        this.m_FlowControlOut = flowControlOut;
    }

    public void setFlowControlOut(String flowControlOut) {
        this.m_FlowControlOut = this.stringToFlow(flowControlOut);
    }

    public int getFlowControlOut() {
        return this.m_FlowControlOut;
    }

    public String getFlowControlOutString() {
        return this.flowToString(this.m_FlowControlOut);
    }

    public void setDatabits(int databits) {
        this.m_Databits = databits;
    }

    public void setDatabits(String databits) {
        if (databits.equals("5")) {
            this.m_Databits = 5;
        }
        if (databits.equals("6")) {
            this.m_Databits = 6;
        }
        if (databits.equals("7")) {
            this.m_Databits = 7;
        }
        if (databits.equals("8")) {
            this.m_Databits = 8;
        }
    }

    public int getDatabits() {
        return this.m_Databits;
    }

    public String getDatabitsString() {
        switch (this.m_Databits) {
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
        }
        return "8";
    }

    public void setStopbits(int stopbits) {
        this.m_Stopbits = stopbits;
    }

    public void setStopbits(String stopbits) {
        if (stopbits.equals("1")) {
            this.m_Stopbits = 1;
        }
        if (stopbits.equals("1.5")) {
            this.m_Stopbits = 3;
        }
        if (stopbits.equals("2")) {
            this.m_Stopbits = 2;
        }
    }

    public int getStopbits() {
        return this.m_Stopbits;
    }

    public String getStopbitsString() {
        switch (this.m_Stopbits) {
            case 1: {
                return "1";
            }
            case 3: {
                return "1.5";
            }
            case 2: {
                return "2";
            }
        }
        return "1";
    }

    public void setParity(int parity) {
        this.m_Parity = parity;
    }

    public void setParity(String parity) {
        if ((parity = parity.toLowerCase()).equals("none")) {
            this.m_Parity = 0;
        }
        if (parity.equals("even")) {
            this.m_Parity = 2;
        }
        if (parity.equals("odd")) {
            this.m_Parity = 1;
        }
    }

    public int getParity() {
        return this.m_Parity;
    }

    public String getParityString() {
        switch (this.m_Parity) {
            case 0: {
                return "none";
            }
            case 2: {
                return "even";
            }
            case 1: {
                return "odd";
            }
        }
        return "none";
    }

    public void setEncoding(String enc) {
        this.m_Encoding = (enc = enc.toLowerCase()).equals("ascii") || enc.equals("rtu") || enc.equals("bin") ? enc : "ascii";
    }

    public String getEncoding() {
        return this.m_Encoding;
    }

    public boolean isEcho() {
        return this.m_Echo;
    }

    public void setEcho(boolean newEcho) {
        this.m_Echo = newEcho;
    }

    public int getReceiveTimeout() {
        return this.m_ReceiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.m_ReceiveTimeout = receiveTimeout;
    }

    public void setReceiveTimeout(String str) {
        this.m_ReceiveTimeout = Integer.parseInt(str);
    }

    private int stringToFlow(String flowcontrol) {
        if ((flowcontrol = flowcontrol.toLowerCase()).equals("none")) {
            return 0;
        }
        if (flowcontrol.equals("xon/xoff out")) {
            return 8;
        }
        if (flowcontrol.equals("xon/xoff in")) {
            return 4;
        }
        if (flowcontrol.equals("rts/cts in")) {
            return 1;
        }
        if (flowcontrol.equals("rts/cts out")) {
            return 2;
        }
        return 0;
    }

    private String flowToString(int flowcontrol) {
        switch (flowcontrol) {
            case 0: {
                return "none";
            }
            case 8: {
                return "xon/xoff out";
            }
            case 4: {
                return "xon/xoff in";
            }
            case 1: {
                return "rts/cts in";
            }
            case 2: {
                return "rts/cts out";
            }
        }
        return "none";
    }
}

