/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

public class TabPaneSkin
extends SkinBase<TabPane, TabPaneBehavior> {
    private static final double ANIMATION_SPEED = 300.0;
    private static final int SPACER = 10;
    private TabHeaderArea tabHeaderArea;
    private ObservableList<TabContentRegion> tabContentRegions;
    private Rectangle clipRect;
    private Rectangle tabHeaderAreaClipRect;
    boolean focusTraversable = true;
    private Tab selectedTab;
    private Tab previousSelectedTab;
    private boolean isSelectingTab;
    private Map<Tab, Timeline> closedTab = new HashMap<Tab, Timeline>();
    private double maxw = 0.0;
    private double maxh = 0.0;
    static int CLOSE_BTN_SIZE = 16;
    private static final long SELECTED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("selected");
    private static final long TOP_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("top");
    private static final long BOTTOM_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("bottom");
    private static final long LEFT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("left");
    private static final long RIGHT_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("right");
    private static final long DISABLED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("disabled");

    private static int getRotation(Side side) {
        switch (side) {
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 180;
            }
            case LEFT: {
                return -90;
            }
            case RIGHT: {
                return 90;
            }
        }
        return 0;
    }

    private static Node clone(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ImageView) {
            ImageView imageView = (ImageView)node;
            ImageView imageView2 = new ImageView();
            imageView2.setImage(imageView.getImage());
            return imageView2;
        }
        if (node instanceof Label) {
            Label label = (Label)node;
            Label label2 = new Label(label.getText(), label.getGraphic());
            return label2;
        }
        return null;
    }

    public TabPaneSkin(TabPane tabPane) {
        super(tabPane, new TabPaneBehavior(tabPane));
        this.clipRect = new Rectangle();
        this.setClip(this.clipRect);
        this.tabContentRegions = FXCollections.observableArrayList();
        for (Tab tab : ((TabPane)this.getSkinnable()).getTabs()) {
            this.addTabContent(tab);
        }
        this.tabHeaderAreaClipRect = new Rectangle();
        this.tabHeaderArea = new TabHeaderArea();
        this.tabHeaderArea.setClip(this.tabHeaderAreaClipRect);
        this.getChildren().add(this.tabHeaderArea);
        if (((TabPane)this.getSkinnable()).getTabs().size() == 0) {
            this.tabHeaderArea.setVisible(false);
        }
        this.initializeTabListener();
        this.registerChangeListener(tabPane.getSelectionModel().selectedItemProperty(), "SELECTED_TAB");
        this.registerChangeListener(tabPane.sideProperty(), "SIDE");
        this.previousSelectedTab = null;
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        if (this.selectedTab == null && ((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex() != -1) {
            ((TabPane)this.getSkinnable()).getSelectionModel().select(((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex());
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        }
        if (this.selectedTab == null) {
            ((TabPane)this.getSkinnable()).getSelectionModel().selectFirst();
        }
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        this.isSelectingTab = false;
        this.initializeSwipeHandlers();
    }

    public StackPane getSelectedTabContentRegion() {
        for (TabContentRegion tabContentRegion : this.tabContentRegions) {
            if (!tabContentRegion.getTab().equals(this.selectedTab)) continue;
            return tabContentRegion;
        }
        return null;
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "SELECTED_TAB") {
            this.isSelectingTab = true;
            this.previousSelectedTab = this.selectedTab;
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
            this.requestLayout();
        } else if (string == "SIDE") {
            this.updateTabPosition();
        }
    }

    private void initializeTabListener() {
        ((TabPane)this.getSkinnable()).getTabs().addListener(new ListChangeListener<Tab>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Tab> change) {
                while (change.next()) {
                    Timeline timeline;
                    for (final Tab tab : change.getRemoved()) {
                        EventTarget eventTarget = TabPaneSkin.this.tabHeaderArea.getTabHeaderSkin(tab);
                        timeline = null;
                        if (eventTarget != null) {
                            ((TabHeaderSkin)eventTarget).animating = true;
                            timeline = TabPaneSkin.this.createTimeline((TabHeaderSkin)eventTarget, Duration.millis(450.0), 0.0, new EventHandler<ActionEvent>(){

                                @Override
                                public void handle(ActionEvent actionEvent) {
                                    TabPaneSkin.this.removeTab(tab);
                                    TabPaneSkin.this.closedTab.remove(tab);
                                    if (((TabPane)TabPaneSkin.this.getSkinnable()).getTabs().isEmpty()) {
                                        TabPaneSkin.this.tabHeaderArea.setVisible(false);
                                    }
                                }
                            });
                            timeline.play();
                        }
                        TabPaneSkin.this.closedTab.put(tab, timeline);
                    }
                    int n = 0;
                    for (EventTarget eventTarget : change.getAddedSubList()) {
                        EventTarget eventTarget2;
                        timeline = (Timeline)TabPaneSkin.this.closedTab.get(eventTarget);
                        if (timeline != null) {
                            timeline.stop();
                            Iterator iterator = TabPaneSkin.this.closedTab.keySet().iterator();
                            while (iterator.hasNext()) {
                                eventTarget2 = (Tab)iterator.next();
                                if (!eventTarget.equals(eventTarget2)) continue;
                                TabPaneSkin.this.removeTab(eventTarget2);
                                iterator.remove();
                            }
                        }
                        if (!TabPaneSkin.this.tabHeaderArea.isVisible()) {
                            TabPaneSkin.this.tabHeaderArea.setVisible(true);
                        }
                        int n2 = change.getFrom() + n++;
                        TabPaneSkin.this.tabHeaderArea.addTab((Tab)eventTarget, n2, false);
                        TabPaneSkin.this.addTabContent((Tab)eventTarget);
                        eventTarget2 = TabPaneSkin.this.tabHeaderArea.getTabHeaderSkin((Tab)eventTarget);
                        if (eventTarget2 == null) continue;
                        ((TabHeaderSkin)eventTarget2).animateNewTab = new Runnable((TabHeaderSkin)eventTarget2){
                            final /* synthetic */ TabHeaderSkin val$tabRegion;
                            {
                                this.val$tabRegion = tabHeaderSkin;
                            }

                            @Override
                            public void run() {
                                double d = TabPaneSkin.this.snapSize(this.val$tabRegion.prefWidth(-1.0));
                                this.val$tabRegion.animating = true;
                                this.val$tabRegion.prefWidth.set(0.0);
                                this.val$tabRegion.setVisible(true);
                                TabPaneSkin.this.createTimeline(this.val$tabRegion, Duration.millis(300.0), d, new EventHandler<ActionEvent>(){

                                    @Override
                                    public void handle(ActionEvent actionEvent) {
                                        val$tabRegion.animating = false;
                                        val$tabRegion.inner.requestLayout();
                                    }
                                }).play();
                            }
                        };
                    }
                }
            }
        });
    }

    private void addTabContent(Tab tab) {
        TabContentRegion tabContentRegion = new TabContentRegion(tab);
        tabContentRegion.setClip(new Rectangle());
        this.tabContentRegions.add(tabContentRegion);
        this.getChildren().add(0, tabContentRegion);
    }

    private void removeTabContent(Tab tab) {
        for (TabContentRegion tabContentRegion : this.tabContentRegions) {
            if (!tabContentRegion.getTab().equals(tab)) continue;
            tabContentRegion.removeListeners(tab);
            this.getChildren().remove(tabContentRegion);
            this.tabContentRegions.remove(tabContentRegion);
            break;
        }
    }

    private void removeTab(Tab tab) {
        TabHeaderSkin tabHeaderSkin = this.tabHeaderArea.getTabHeaderSkin(tab);
        this.tabHeaderArea.removeTab(tab);
        this.removeTabContent(tab);
        tabHeaderSkin.animating = false;
        this.tabHeaderArea.requestLayout();
        tab = null;
    }

    private void updateTabPosition() {
        this.tabHeaderArea.setScrollOffset(0.0);
        this.impl_reapplyCSS();
        this.requestLayout();
    }

    private Timeline createTimeline(TabHeaderSkin tabHeaderSkin, Duration duration, double d, EventHandler<ActionEvent> eventHandler) {
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue keyValue = new KeyValue(tabHeaderSkin.prefWidth, d, Interpolator.LINEAR);
        timeline.getKeyFrames().clear();
        timeline.getKeyFrames().add(new KeyFrame(duration, eventHandler, keyValue));
        return timeline;
    }

    private boolean isHorizontal() {
        Side side = ((TabPane)this.getSkinnable()).getSide();
        return Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side);
    }

    private void initializeSwipeHandlers() {
        if (PlatformUtil.isEmbedded()) {
            this.setOnSwipeLeft((EventHandler<? super SwipeEvent>)new EventHandler<SwipeEvent>(){

                @Override
                public void handle(SwipeEvent swipeEvent) {
                    ((TabPaneBehavior)TabPaneSkin.this.getBehavior()).selectNextTab();
                }
            });
            this.setOnSwipeRight((EventHandler<? super SwipeEvent>)new EventHandler<SwipeEvent>(){

                @Override
                public void handle(SwipeEvent swipeEvent) {
                    ((TabPaneBehavior)TabPaneSkin.this.getBehavior()).selectPreviousTab();
                }
            });
        }
    }

    private boolean isFloatingStyleClass() {
        return ((TabPane)this.getSkinnable()).getStyleClass().contains("floating");
    }

    @Override
    protected void setWidth(double d) {
        super.setWidth(d);
        this.clipRect.setWidth(d);
    }

    @Override
    protected void setHeight(double d) {
        super.setHeight(d);
        this.clipRect.setHeight(d);
    }

    @Override
    protected double computePrefWidth(double d) {
        for (TabContentRegion tabContentRegion : this.tabContentRegions) {
            this.maxw = Math.max(this.maxw, this.snapSize(tabContentRegion.prefWidth(-1.0)));
        }
        double d2 = this.isHorizontal() ? this.maxw : this.maxw + this.snapSize(this.tabHeaderArea.prefHeight(-1.0));
        return this.snapSize(d2) + this.snapSize(this.getInsets().getRight()) + this.snapSize(this.getInsets().getLeft());
    }

    @Override
    protected double computePrefHeight(double d) {
        for (TabContentRegion tabContentRegion : this.tabContentRegions) {
            this.maxh = Math.max(this.maxh, this.snapSize(tabContentRegion.prefHeight(-1.0)));
        }
        double d2 = this.isHorizontal() ? this.maxh + this.snapSize(this.tabHeaderArea.prefHeight(-1.0)) : this.maxh;
        return this.snapSize(d2) + this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom());
    }

    @Override
    public double getBaselineOffset() {
        return this.tabHeaderArea.getBaselineOffset() + this.tabHeaderArea.getLayoutY();
    }

    @Override
    protected void layoutChildren() {
        TabPane tabPane = (TabPane)this.getSkinnable();
        Side side = tabPane.getSide();
        Insets insets = this.getInsets();
        double d = this.snapSize(this.getWidth()) - this.snapSize(insets.getLeft()) - this.snapSize(insets.getRight());
        double d2 = this.snapSize(this.getHeight()) - this.snapSize(insets.getTop()) - this.snapSize(insets.getBottom());
        double d3 = this.snapSize(insets.getLeft());
        double d4 = this.snapSize(insets.getTop());
        double d5 = this.snapSize(this.tabHeaderArea.prefHeight(-1.0));
        double d6 = side.equals((Object)Side.RIGHT) ? d3 + d - d5 : d3;
        double d7 = side.equals((Object)Side.BOTTOM) ? d4 + d2 - d5 : d4;
        if (side.equals((Object)Side.TOP)) {
            this.tabHeaderArea.resize(d, d5);
            this.tabHeaderArea.relocate(d6, d7);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.TOP)));
        } else if (side.equals((Object)Side.BOTTOM)) {
            this.tabHeaderArea.resize(d, d5);
            this.tabHeaderArea.relocate(d, d7 - d5);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.BOTTOM), 0.0, d5));
        } else if (side.equals((Object)Side.LEFT)) {
            this.tabHeaderArea.resize(d2, d5);
            this.tabHeaderArea.relocate(d6 + d5, d2 - d5);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.LEFT), 0.0, d5));
        } else if (side.equals((Object)Side.RIGHT)) {
            this.tabHeaderArea.resize(d2, d5);
            this.tabHeaderArea.relocate(d6, d4 - d5);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.RIGHT), 0.0, d5));
        }
        this.tabHeaderAreaClipRect.setX(0.0);
        this.tabHeaderAreaClipRect.setY(0.0);
        if (this.isHorizontal()) {
            this.tabHeaderAreaClipRect.setWidth(d);
        } else {
            this.tabHeaderAreaClipRect.setWidth(d2);
        }
        this.tabHeaderAreaClipRect.setHeight(d5);
        double d8 = 0.0;
        double d9 = 0.0;
        if (side.equals((Object)Side.TOP)) {
            d8 = d3;
            d9 = d4 + d5;
            if (this.isFloatingStyleClass()) {
                d9 -= 1.0;
            }
        } else if (side.equals((Object)Side.BOTTOM)) {
            d8 = d3;
            d9 = d4;
            if (this.isFloatingStyleClass()) {
                d9 = 1.0;
            }
        } else if (side.equals((Object)Side.LEFT)) {
            d8 = d3 + d5;
            d9 = d4;
            if (this.isFloatingStyleClass()) {
                d8 -= 1.0;
            }
        } else if (side.equals((Object)Side.RIGHT)) {
            d8 = d3;
            d9 = d4;
            if (this.isFloatingStyleClass()) {
                d8 = 1.0;
            }
        }
        double d10 = d - (this.isHorizontal() ? 0.0 : d5);
        double d11 = d2 - (this.isHorizontal() ? d5 : 0.0);
        for (TabContentRegion tabContentRegion : this.tabContentRegions) {
            Node node;
            if (tabContentRegion.getTab().equals(this.selectedTab)) {
                tabContentRegion.setAlignment(Pos.TOP_LEFT);
                if (tabContentRegion.getClip() != null) {
                    ((Rectangle)tabContentRegion.getClip()).setWidth(d10);
                    ((Rectangle)tabContentRegion.getClip()).setHeight(d11);
                }
                tabContentRegion.resize(d10, d11);
                tabContentRegion.relocate(d8, d9);
                node = tabContentRegion.getTab().getContent();
                if (node == null) continue;
                node.setVisible(true);
                continue;
            }
            node = tabContentRegion.getTab().getContent();
            if (node == null) continue;
            node.setVisible(false);
        }
    }

    class TabMenuItem
    extends RadioMenuItem {
        Tab tab;

        public TabMenuItem(final Tab tab) {
            super(tab.getText(), TabPaneSkin.clone(tab.getGraphic()));
            this.tab = tab;
            this.setDisable(tab.isDisable());
            tab.disableProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    TabMenuItem.this.setDisable(tab.isDisable());
                }
            });
        }

        public Tab getTab() {
            return this.tab;
        }
    }

    class TabControlButtons
    extends StackPane {
        private StackPane inner;
        private StackPane downArrow;
        private Pane downArrowBtn;
        private boolean showControlButtons;
        private ContextMenu popup;
        private boolean showTabsMenu = false;
        private final DoubleProperty controlTabHeight = new SimpleDoubleProperty(this, "controlTabHeight");
        private boolean animationLock;
        double maxArrowWidth;
        double innerPrefWidth;
        private double prefWidth;

        public TabControlButtons() {
            this.controlTabHeight.addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    TabControlButtons.this.requestLayout();
                }
            });
            this.animationLock = false;
            this.getStyleClass().setAll((String[])new String[]{"control-buttons-tab"});
            TabPane tabPane = (TabPane)TabPaneSkin.this.getSkinnable();
            this.downArrowBtn = new Pane();
            this.downArrowBtn.getStyleClass().setAll((String[])new String[]{"tab-down-button"});
            this.downArrowBtn.setVisible(this.isShowTabsMenu());
            this.downArrow = new StackPane();
            this.downArrow.setManaged(false);
            this.downArrow.getStyleClass().setAll((String[])new String[]{"arrow"});
            this.downArrow.setRotate(tabPane.getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            this.downArrowBtn.getChildren().add(this.downArrow);
            this.downArrowBtn.setOnMouseClicked((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    TabControlButtons.this.showPopupMenu();
                }
            });
            this.setupPopupMenu();
            this.inner = new StackPane(){

                private double getArrowBtnWidth() {
                    if (TabControlButtons.this.animationLock) {
                        return TabControlButtons.this.maxArrowWidth;
                    }
                    if (TabControlButtons.this.isShowTabsMenu()) {
                        TabControlButtons.this.maxArrowWidth = Math.max(TabControlButtons.this.maxArrowWidth, this.snapSize(TabControlButtons.this.downArrow.prefWidth(this.getHeight())) + this.snapSize(TabControlButtons.this.downArrowBtn.prefWidth(this.getHeight())));
                    }
                    return TabControlButtons.this.maxArrowWidth;
                }

                @Override
                protected double computePrefWidth(double d) {
                    if (TabControlButtons.this.animationLock) {
                        return TabControlButtons.this.innerPrefWidth;
                    }
                    TabControlButtons.this.innerPrefWidth = this.getActualPrefWidth();
                    return TabControlButtons.this.innerPrefWidth;
                }

                public double getActualPrefWidth() {
                    double d = this.getArrowBtnWidth();
                    double d2 = 0.0;
                    if (TabControlButtons.this.isShowTabsMenu()) {
                        d2 += d;
                    }
                    if (d2 > 0.0) {
                        d2 += this.snapSize(this.getInsets().getLeft()) + this.snapSize(this.getInsets().getRight());
                    }
                    return d2;
                }

                @Override
                protected double computePrefHeight(double d) {
                    double d2 = 0.0;
                    if (TabControlButtons.this.isShowTabsMenu()) {
                        d2 = Math.max(d2, this.snapSize(TabControlButtons.this.downArrowBtn.prefHeight(d)));
                    }
                    if (d2 > 0.0) {
                        d2 += this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom());
                    }
                    return d2;
                }

                @Override
                protected void layoutChildren() {
                    Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
                    double d = 0.0;
                    double d2 = this.snapSize(this.getInsets().getTop());
                    double d3 = this.snapSize(this.getHeight()) - this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom());
                    d = side.equals((Object)Side.BOTTOM) || side.equals((Object)Side.LEFT) ? (d += this.positionTabsMenu(d, d2, d3, true)) : (d += this.positionTabsMenu(d, d2, d3, false));
                }

                private double positionTabsMenu(double d, double d2, double d3, boolean bl) {
                    double d4 = d;
                    if (TabControlButtons.this.isShowTabsMenu()) {
                        this.positionArrow(TabControlButtons.this.downArrowBtn, TabControlButtons.this.downArrow, d4, d2, TabControlButtons.this.maxArrowWidth, d3);
                        d4 += TabControlButtons.this.maxArrowWidth;
                    }
                    return d4;
                }

                private void positionArrow(Pane pane, StackPane stackPane, double d, double d2, double d3, double d4) {
                    pane.resize(d3, d4);
                    this.positionInArea(pane, d, d2, d3, d4, 0.0, HPos.CENTER, VPos.CENTER);
                    double d5 = this.snapSize(stackPane.prefWidth(-1.0));
                    double d6 = this.snapSize(stackPane.prefHeight(-1.0));
                    stackPane.resize(d5, d6);
                    this.positionInArea(stackPane, this.snapSize(pane.getInsets().getLeft()), this.snapSize(pane.getInsets().getTop()), d3 - this.snapSize(pane.getInsets().getLeft()) - this.snapSize(pane.getInsets().getRight()), d4 - this.snapSize(pane.getInsets().getTop()) - this.snapSize(pane.getInsets().getBottom()), 0.0, HPos.CENTER, VPos.CENTER);
                }
            };
            this.inner.getChildren().add(this.downArrowBtn);
            this.getChildren().add(this.inner);
            tabPane.sideProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
                    TabControlButtons.this.downArrow.setRotate(side.equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
                }
            });
            tabPane.getTabs().addListener(new ListChangeListener<Tab>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends Tab> change) {
                    TabControlButtons.this.setupPopupMenu();
                }
            });
            this.showControlButtons = false;
            if (this.isShowTabsMenu()) {
                this.showControlButtons = true;
                this.requestLayout();
            }
            this.getProperties().put(ContextMenu.class, this.popup);
        }

        private void showTabsMenu(boolean bl) {
            if (bl && !this.showTabsMenu) {
                this.downArrowBtn.setVisible(true);
                this.showControlButtons = true;
                this.inner.requestLayout();
                TabPaneSkin.this.tabHeaderArea.requestLayout();
            } else if (!bl && this.showTabsMenu) {
                this.hideControlButtons();
            }
            this.showTabsMenu = bl;
        }

        private boolean isShowTabsMenu() {
            return this.showTabsMenu;
        }

        public double getControlTabHeight() {
            return this.controlTabHeight.get();
        }

        public void setControlTabHeight(double d) {
            this.controlTabHeight.set(d);
        }

        private void setAnimationLock(boolean bl) {
            this.animationLock = bl;
            TabPaneSkin.this.tabHeaderArea.requestLayout();
        }

        @Override
        protected double computePrefWidth(double d) {
            if (this.animationLock) {
                return this.prefWidth;
            }
            this.prefWidth = this.getActualPrefWidth(d);
            return this.prefWidth;
        }

        private double getActualPrefWidth(double d) {
            double d2 = this.snapSize(this.inner.prefWidth(d));
            if (d2 > 0.0) {
                d2 += this.snapSize(this.getInsets().getLeft()) + this.snapSize(this.getInsets().getRight());
            }
            return d2;
        }

        @Override
        protected double computePrefHeight(double d) {
            return Math.max(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMinHeight(), this.snapSize(this.inner.prefHeight(d))) + this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom());
        }

        @Override
        protected void layoutChildren() {
            double d = this.snapSize(this.getInsets().getLeft());
            double d2 = this.snapSize(this.getInsets().getTop());
            double d3 = this.snapSize(this.getWidth()) - this.snapSize(this.getInsets().getLeft()) + this.snapSize(this.getInsets().getRight());
            double d4 = this.snapSize(this.getHeight()) - this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom());
            if (this.showControlButtons) {
                this.showControlButtons();
                this.showControlButtons = false;
            }
            this.inner.resize(d3, d4);
            this.positionInArea(this.inner, d, d2, d3, d4, 0.0, HPos.CENTER, VPos.BOTTOM);
        }

        private void showControlButtons() {
            double d = this.snapSize(this.prefHeight(-1.0));
            Timeline timeline = new Timeline();
            KeyValue keyValue = new KeyValue(this.controlTabHeight, d, Interpolator.EASE_OUT);
            this.setVisible(true);
            timeline.getKeyFrames().clear();
            timeline.getKeyFrames().add(new KeyFrame(Duration.millis(300.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (TabControlButtons.this.popup == null) {
                        TabControlButtons.this.setupPopupMenu();
                    }
                    TabControlButtons.this.requestLayout();
                }
            }, keyValue));
            timeline.play();
        }

        private void hideControlButtons() {
            this.setAnimationLock(true);
            Timeline timeline = new Timeline();
            KeyValue keyValue = new KeyValue(this.controlTabHeight, 0.0, Interpolator.EASE_IN);
            timeline.getKeyFrames().clear();
            timeline.getKeyFrames().add(new KeyFrame(Duration.millis(300.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (!TabControlButtons.this.isShowTabsMenu()) {
                        TabControlButtons.this.downArrowBtn.setVisible(false);
                    }
                    if (TabControlButtons.this.isShowTabsMenu()) {
                        TabControlButtons.this.showControlButtons = true;
                    } else {
                        TabControlButtons.this.setVisible(false);
                        TabControlButtons.this.popup.getItems().clear();
                        TabControlButtons.this.popup = null;
                    }
                    TabControlButtons.this.setAnimationLock(false);
                    TabControlButtons.this.requestLayout();
                }
            }, keyValue));
            timeline.play();
        }

        private void setupPopupMenu() {
            if (this.popup == null) {
                this.popup = new ContextMenu();
            }
            this.popup.getItems().clear();
            ToggleGroup toggleGroup = new ToggleGroup();
            ObservableList<TabMenuItem> observableList = FXCollections.observableArrayList();
            for (final Tab tab : ((TabPane)TabPaneSkin.this.getSkinnable()).getTabs()) {
                TabMenuItem tabMenuItem = new TabMenuItem(tab);
                tabMenuItem.setToggleGroup(toggleGroup);
                tabMenuItem.setOnAction(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent actionEvent) {
                        ((TabPane)TabPaneSkin.this.getSkinnable()).getSelectionModel().select(tab);
                    }
                });
                observableList.add(tabMenuItem);
            }
            this.popup.getItems().addAll((Collection<MenuItem>)observableList);
        }

        private void showPopupMenu() {
            for (MenuItem menuItem : this.popup.getItems()) {
                TabMenuItem tabMenuItem = (TabMenuItem)menuItem;
                if (!TabPaneSkin.this.selectedTab.equals(tabMenuItem.getTab())) continue;
                tabMenuItem.setSelected(true);
                break;
            }
            this.popup.show(this.downArrowBtn, Side.BOTTOM, 0.0, 0.0);
        }
    }

    class TabContentRegion
    extends StackPane
    implements TraverseListener {
        private TraversalEngine engine;
        private Direction direction;
        private Tab tab;
        private InvalidationListener tabListener;

        public Tab getTab() {
            return this.tab;
        }

        public TabContentRegion(Tab tab) {
            this.getStyleClass().setAll((String[])new String[]{"tab-content-area"});
            this.setManaged(false);
            this.tab = tab;
            this.updateContent();
            this.tabListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    if (observable == TabContentRegion.this.getTab().selectedProperty()) {
                        TabContentRegion.this.setVisible(TabContentRegion.this.getTab().isSelected());
                    } else if (observable == TabContentRegion.this.getTab().contentProperty()) {
                        TabContentRegion.this.getChildren().clear();
                        TabContentRegion.this.updateContent();
                    }
                }
            };
            tab.selectedProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    TabContentRegion.this.setVisible(TabContentRegion.this.getTab().isSelected());
                }
            });
            tab.contentProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    TabContentRegion.this.getChildren().clear();
                    TabContentRegion.this.updateContent();
                }
            });
            tab.selectedProperty().addListener(this.tabListener);
            tab.contentProperty().addListener(this.tabListener);
            this.engine = new TraversalEngine(this, false){

                @Override
                public void trav(Node node, Direction direction) {
                    TabContentRegion.this.direction = direction;
                    super.trav(node, direction);
                }
            };
            this.engine.addTraverseListener(this);
            this.setImpl_traversalEngine(this.engine);
            this.setVisible(tab.isSelected());
        }

        private void updateContent() {
            if (this.getTab().getContent() != null) {
                this.getChildren().add(this.getTab().getContent());
            }
        }

        private void removeListeners(Tab tab) {
            tab.selectedProperty().removeListener(this.tabListener);
            tab.contentProperty().removeListener(this.tabListener);
            this.engine.removeTraverseListener(this);
        }

        @Override
        public void onTraverse(Node node, Bounds bounds) {
            int n = this.engine.registeredNodes.indexOf(node);
            if (n == -1 && this.direction.equals((Object)Direction.PREVIOUS)) {
                ((TabPane)TabPaneSkin.this.getSkinnable()).requestFocus();
            }
            if (n == -1 && this.direction.equals((Object)Direction.NEXT)) {
                new TraversalEngine((Parent)((Object)TabPaneSkin.this.getSkinnable()), false).trav((Node)((Object)TabPaneSkin.this.getSkinnable()), Direction.NEXT);
            }
        }
    }

    class TabHeaderSkin
    extends StackPane {
        private final Tab tab;
        private Label label;
        private StackPane closeBtn;
        private StackPane inner;
        private Tooltip tooltip;
        private Rectangle clip;
        private InvalidationListener tabListener;
        private InvalidationListener controlListener;
        private final DoubleProperty prefWidth = new DoublePropertyBase(){

            @Override
            protected void invalidated() {
                TabHeaderSkin.this.requestLayout();
            }

            @Override
            public Object getBean() {
                return TabHeaderSkin.this;
            }

            @Override
            public String getName() {
                return "prefWidth";
            }
        };
        private boolean animating = false;
        private Runnable animateNewTab = null;

        public Tab getTab() {
            return this.tab;
        }

        public TabHeaderSkin(final Tab tab) {
            this.getStyleClass().setAll((Collection<String>)tab.getStyleClass());
            this.setId(tab.getId());
            this.setStyle(tab.getStyle());
            this.tab = tab;
            this.clip = new Rectangle();
            this.setClip(this.clip);
            this.label = new Label(tab.getText(), tab.getGraphic());
            this.label.getStyleClass().setAll((String[])new String[]{"tab-label"});
            this.closeBtn = new StackPane(){

                @Override
                protected double computePrefWidth(double d) {
                    return CLOSE_BTN_SIZE;
                }

                @Override
                protected double computePrefHeight(double d) {
                    return CLOSE_BTN_SIZE;
                }
            };
            this.closeBtn.getStyleClass().setAll((String[])new String[]{"tab-close-button"});
            this.closeBtn.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    TabHeaderSkin.this.removeListeners(TabHeaderSkin.this.getTab());
                    ((TabPaneBehavior)TabPaneSkin.this.getBehavior()).closeTab(TabHeaderSkin.this.getTab());
                    TabHeaderSkin.this.setOnMousePressed(null);
                }
            });
            this.updateGraphicRotation();
            this.inner = new StackPane(){

                @Override
                protected void layoutChildren() {
                    Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
                    double d = this.snapSize(this.getInsets().getTop());
                    double d2 = this.snapSize(this.getInsets().getRight());
                    double d3 = this.snapSize(this.getInsets().getBottom());
                    double d4 = this.snapSize(this.getInsets().getLeft());
                    double d5 = this.getWidth() - d4 + d2;
                    double d6 = this.getHeight() - d + d3;
                    double d7 = this.snapSize(TabHeaderSkin.this.label.prefWidth(-1.0));
                    double d8 = this.snapSize(TabHeaderSkin.this.label.prefHeight(-1.0));
                    double d9 = TabHeaderSkin.this.showCloseButton() ? this.snapSize(TabHeaderSkin.this.closeBtn.prefWidth(-1.0)) : 0.0;
                    double d10 = TabHeaderSkin.this.showCloseButton() ? this.snapSize(TabHeaderSkin.this.closeBtn.prefHeight(-1.0)) : 0.0;
                    double d11 = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMinWidth());
                    double d12 = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMaxWidth());
                    double d13 = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMinHeight());
                    double d14 = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMaxHeight());
                    double d15 = d7 + d9;
                    double d16 = Math.max(d8, d10);
                    if (d15 > d12 && d12 != Double.MAX_VALUE) {
                        d7 = d12 - d9;
                    } else if (d15 < d11) {
                        d7 = d11 - d9;
                    }
                    if (d16 > d14 && d14 != Double.MAX_VALUE) {
                        d8 = d14;
                    } else if (d16 < d13) {
                        d8 = d13;
                    }
                    if (TabHeaderSkin.this.animating) {
                        if (TabHeaderSkin.this.prefWidth.getValue() < d7) {
                            d7 = TabHeaderSkin.this.prefWidth.getValue();
                        }
                        TabHeaderSkin.this.closeBtn.setVisible(false);
                    } else {
                        TabHeaderSkin.this.closeBtn.setVisible(TabHeaderSkin.this.showCloseButton());
                    }
                    TabHeaderSkin.this.label.resize(d7, d8);
                    double d17 = d4;
                    double d18 = (d12 != Double.MAX_VALUE ? d12 : d5) - d2 - d9;
                    this.positionInArea(TabHeaderSkin.this.label, d17, d, d7, d6, 0.0, HPos.CENTER, VPos.CENTER);
                    if (TabHeaderSkin.this.closeBtn.isVisible()) {
                        TabHeaderSkin.this.closeBtn.resize(d9, d10);
                        this.positionInArea(TabHeaderSkin.this.closeBtn, d18, d, d9, d6, 0.0, HPos.CENTER, VPos.CENTER);
                    }
                }
            };
            this.inner.setRotate(((TabPane)TabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            this.inner.getChildren().addAll((Node[])new Node[]{this.label, this.closeBtn});
            this.getChildren().addAll((Node[])new Node[]{this.inner});
            this.tooltip = tab.getTooltip();
            if (this.tooltip != null) {
                Tooltip.install(this, this.tooltip);
            }
            this.tabListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    if (observable == tab.selectedProperty()) {
                        TabHeaderSkin.this.impl_pseudoClassStateChanged("selected");
                        TabHeaderSkin.this.inner.requestLayout();
                        TabHeaderSkin.this.requestLayout();
                    } else if (observable == tab.textProperty()) {
                        TabHeaderSkin.this.label.setText(TabHeaderSkin.this.getTab().getText());
                    } else if (observable == tab.graphicProperty()) {
                        TabHeaderSkin.this.label.setGraphic(TabHeaderSkin.this.getTab().getGraphic());
                    } else if (observable != tab.contextMenuProperty()) {
                        if (observable == tab.tooltipProperty()) {
                            TabHeaderSkin.this.getChildren().remove(TabHeaderSkin.this.tooltip);
                            TabHeaderSkin.this.tooltip = tab.getTooltip();
                            if (TabHeaderSkin.this.tooltip != null) {
                                // empty if block
                            }
                        } else if (observable == tab.styleProperty()) {
                            TabHeaderSkin.this.setStyle(tab.getStyle());
                        } else if (observable == tab.disableProperty()) {
                            TabHeaderSkin.this.impl_pseudoClassStateChanged("disabled");
                            TabHeaderSkin.this.inner.requestLayout();
                            TabHeaderSkin.this.requestLayout();
                        } else if (observable == tab.closableProperty()) {
                            TabHeaderSkin.this.inner.requestLayout();
                            TabHeaderSkin.this.requestLayout();
                        }
                    }
                }
            };
            tab.closableProperty().addListener(this.tabListener);
            tab.selectedProperty().addListener(this.tabListener);
            tab.textProperty().addListener(this.tabListener);
            tab.graphicProperty().addListener(this.tabListener);
            tab.contextMenuProperty().addListener(this.tabListener);
            tab.tooltipProperty().addListener(this.tabListener);
            tab.disableProperty().addListener(this.tabListener);
            tab.styleProperty().addListener(this.tabListener);
            tab.getStyleClass().addListener(new ListChangeListener<String>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends String> change) {
                    TabHeaderSkin.this.getStyleClass().setAll((Collection<String>)tab.getStyleClass());
                }
            });
            this.controlListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    if (observable == ((TabPane)TabPaneSkin.this.getSkinnable()).tabClosingPolicyProperty()) {
                        TabHeaderSkin.this.inner.requestLayout();
                        TabHeaderSkin.this.requestLayout();
                    } else if (observable == ((TabPane)TabPaneSkin.this.getSkinnable()).sideProperty()) {
                        TabHeaderSkin.this.inner.setRotate(((TabPane)TabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
                        if (((TabPane)TabPaneSkin.this.getSkinnable()).isRotateGraphic()) {
                            TabHeaderSkin.this.updateGraphicRotation();
                        }
                    } else if (observable == ((TabPane)TabPaneSkin.this.getSkinnable()).rotateGraphicProperty()) {
                        TabHeaderSkin.this.updateGraphicRotation();
                    } else if (observable == ((TabPane)TabPaneSkin.this.getSkinnable()).tabMinWidthProperty() || observable == ((TabPane)TabPaneSkin.this.getSkinnable()).tabMaxWidthProperty() || observable == ((TabPane)TabPaneSkin.this.getSkinnable()).tabMinHeightProperty() || observable == ((TabPane)TabPaneSkin.this.getSkinnable()).tabMaxHeightProperty()) {
                        TabHeaderSkin.this.requestLayout();
                    }
                }
            };
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabClosingPolicyProperty().addListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).sideProperty().addListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).rotateGraphicProperty().addListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabMinWidthProperty().addListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabMaxWidthProperty().addListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabMinHeightProperty().addListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabMaxHeightProperty().addListener(this.controlListener);
            this.getProperties().put(Tab.class, tab);
            this.getProperties().put(ContextMenu.class, tab.getContextMenu());
            this.setOnContextMenuRequested((EventHandler<? super ContextMenuEvent>)new EventHandler<ContextMenuEvent>(){

                @Override
                public void handle(ContextMenuEvent contextMenuEvent) {
                    if (TabHeaderSkin.this.getTab().getContextMenu() != null) {
                        TabHeaderSkin.this.getTab().getContextMenu().show(TabHeaderSkin.this.inner, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                        contextMenuEvent.consume();
                    }
                }
            });
            this.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (TabHeaderSkin.this.getTab().isDisable()) {
                        return;
                    }
                    if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
                        if (TabHeaderSkin.this.showCloseButton()) {
                            TabHeaderSkin.this.removeListeners(TabHeaderSkin.this.getTab());
                            ((TabPaneBehavior)TabPaneSkin.this.getBehavior()).closeTab(TabHeaderSkin.this.getTab());
                        }
                    } else if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                        ((TabPaneBehavior)TabPaneSkin.this.getBehavior()).selectTab(TabHeaderSkin.this.getTab());
                    }
                }
            });
        }

        private void updateGraphicRotation() {
            if (this.label.getGraphic() != null) {
                this.label.getGraphic().setRotate(((TabPane)TabPaneSkin.this.getSkinnable()).isRotateGraphic() ? 0.0 : (double)(((TabPane)TabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.RIGHT) ? -90.0f : (((TabPane)TabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.LEFT) ? 90.0f : 0.0f)));
            }
        }

        private boolean showCloseButton() {
            return this.tab.isClosable() && (((TabPane)TabPaneSkin.this.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane.TabClosingPolicy.ALL_TABS) || ((TabPane)TabPaneSkin.this.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane.TabClosingPolicy.SELECTED_TAB) && this.tab.isSelected());
        }

        private void removeListeners(Tab tab) {
            tab.selectedProperty().removeListener(this.tabListener);
            tab.textProperty().removeListener(this.tabListener);
            tab.graphicProperty().removeListener(this.tabListener);
            ContextMenu contextMenu = tab.getContextMenu();
            if (contextMenu != null) {
                contextMenu.getItems().clear();
            }
            tab.contextMenuProperty().removeListener(this.tabListener);
            tab.tooltipProperty().removeListener(this.tabListener);
            tab.styleProperty().removeListener(this.tabListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabClosingPolicyProperty().removeListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).sideProperty().removeListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).rotateGraphicProperty().removeListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabMinWidthProperty().removeListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabMaxWidthProperty().removeListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabMinHeightProperty().removeListener(this.controlListener);
            ((TabPane)TabPaneSkin.this.getSkinnable()).tabMaxHeightProperty().removeListener(this.controlListener);
            this.inner.getChildren().clear();
            this.getChildren().clear();
        }

        @Override
        protected double computePrefWidth(double d) {
            if (this.animating) {
                return this.prefWidth.getValue();
            }
            double d2 = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMinWidth());
            double d3 = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMaxWidth());
            double d4 = this.snapSize(this.getInsets().getRight());
            double d5 = this.snapSize(this.getInsets().getLeft());
            double d6 = this.snapSize(this.label.prefWidth(-1.0));
            if (this.showCloseButton()) {
                d6 += this.snapSize(this.closeBtn.prefWidth(-1.0));
            }
            if (d6 > d3) {
                d6 = d3;
            } else if (d6 < d2) {
                d6 = d2;
            }
            this.prefWidth.setValue(d6 += d4 + d5);
            return d6;
        }

        @Override
        protected double computePrefHeight(double d) {
            double d2 = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMinHeight());
            double d3 = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMaxHeight());
            double d4 = this.snapSize(this.getInsets().getTop());
            double d5 = this.snapSize(this.getInsets().getBottom());
            double d6 = this.snapSize(this.label.prefHeight(d));
            if (d6 > d3) {
                d6 = d3;
            } else if (d6 < d2) {
                d6 = d2;
            }
            return d6 += d4 + d5;
        }

        @Override
        protected void layoutChildren() {
            Insets insets = this.getInsets();
            this.inner.resize(this.snapSize(this.getWidth()) - this.snapSize(insets.getRight()) - this.snapSize(insets.getLeft()), this.snapSize(this.getHeight()) - this.snapSize(insets.getTop()) - this.snapSize(insets.getBottom()));
            this.inner.relocate(this.snapSize(insets.getLeft()), this.snapSize(insets.getTop()));
            if (this.animateNewTab != null) {
                this.animateNewTab.run();
                this.animateNewTab = null;
            }
        }

        @Override
        protected void setWidth(double d) {
            super.setWidth(d);
            this.clip.setWidth(d);
        }

        @Override
        protected void setHeight(double d) {
            super.setHeight(d);
            this.clip.setHeight(d);
        }

        @Override
        public long impl_getPseudoClassState() {
            long l = super.impl_getPseudoClassState();
            if (this.getTab().isDisable()) {
                l |= DISABLED_PSEUDOCLASS_STATE;
            } else if (this.getTab().isSelected()) {
                l |= SELECTED_PSEUDOCLASS_STATE;
            }
            switch (((TabPane)TabPaneSkin.this.getSkinnable()).getSide()) {
                case TOP: {
                    l |= TOP_PSEUDOCLASS_STATE;
                    break;
                }
                case RIGHT: {
                    l |= RIGHT_PSEUDOCLASS_STATE;
                    break;
                }
                case BOTTOM: {
                    l |= BOTTOM_PSEUDOCLASS_STATE;
                    break;
                }
                case LEFT: {
                    l |= LEFT_PSEUDOCLASS_STATE;
                }
            }
            return l;
        }
    }

    class TabHeaderArea
    extends StackPane {
        private Rectangle headerClip;
        private StackPane headersRegion;
        private StackPane headerBackground;
        private TabControlButtons controlButtons;
        private double lastDragPos;
        private double scrollOffset;
        private Point2D dragAnchor;
        private List<TabHeaderSkin> removeTab = new ArrayList<TabHeaderSkin>();
        private Timeline scroller;

        public double getScrollOffset() {
            return this.scrollOffset;
        }

        public void setScrollOffset(double d) {
            this.scrollOffset = d;
            this.headersRegion.requestLayout();
        }

        public TabHeaderArea() {
            this.getStyleClass().setAll((String[])new String[]{"tab-header-area"});
            this.setManaged(false);
            TabPane tabPane = (TabPane)TabPaneSkin.this.getSkinnable();
            this.headerClip = new Rectangle();
            this.headersRegion = new StackPane(){

                @Override
                protected double computePrefWidth(double d) {
                    double d2 = 0.0;
                    for (Node node : this.getChildren()) {
                        TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                        if (!tabHeaderSkin.isVisible()) continue;
                        d2 += tabHeaderSkin.prefWidth(d);
                    }
                    return this.snapSize(d2) + this.snapSize(this.getInsets().getLeft()) + this.snapSize(this.getInsets().getRight());
                }

                @Override
                protected double computePrefHeight(double d) {
                    double d2 = 0.0;
                    for (Node node : this.getChildren()) {
                        TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                        d2 = Math.max(d2, tabHeaderSkin.prefHeight(d));
                    }
                    return this.snapSize(d2) + this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom());
                }

                @Override
                protected void layoutChildren() {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    if (TabHeaderArea.this.tabsFit()) {
                        TabHeaderArea.this.setScrollOffset(0.0);
                    } else if (!TabHeaderArea.this.removeTab.isEmpty()) {
                        d4 = 0.0;
                        d3 = TabPaneSkin.this.tabHeaderArea.getWidth() - this.snapSize(TabHeaderArea.this.controlButtons.prefWidth(-1.0)) - TabHeaderArea.this.firstTabIndent() - 10.0;
                        Iterator iterator = this.getChildren().iterator();
                        while (iterator.hasNext()) {
                            TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)iterator.next();
                            d2 = this.snapSize(tabHeaderSkin.prefWidth(-1.0));
                            if (TabHeaderArea.this.removeTab.contains(tabHeaderSkin)) {
                                if (d4 < d3) {
                                    TabPaneSkin.this.isSelectingTab = true;
                                }
                                iterator.remove();
                                TabHeaderArea.this.removeTab.remove(tabHeaderSkin);
                                if (TabHeaderArea.this.removeTab.isEmpty()) break;
                            }
                            d4 += d2;
                        }
                    } else {
                        TabPaneSkin.this.isSelectingTab = true;
                    }
                    if (TabPaneSkin.this.isSelectingTab) {
                        d4 = 0.0;
                        d3 = 0.0;
                        double d5 = 0.0;
                        d2 = 0.0;
                        d = 0.0;
                        for (Node node : this.getChildren()) {
                            TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                            double d6 = this.snapSize(tabHeaderSkin.prefWidth(-1.0));
                            if (TabPaneSkin.this.selectedTab != null && TabPaneSkin.this.selectedTab.equals(tabHeaderSkin.getTab())) {
                                d3 = d4;
                                d5 = d6;
                            }
                            if (TabPaneSkin.this.previousSelectedTab != null && TabPaneSkin.this.previousSelectedTab.equals(tabHeaderSkin.getTab())) {
                                d2 = d4;
                                d = d6;
                            }
                            d4 += d6;
                        }
                        if (d3 > d2) {
                            TabHeaderArea.this.scrollToSelectedTab(d3 + d5, d2);
                        } else {
                            TabHeaderArea.this.scrollToSelectedTab(d3, d2);
                        }
                        TabPaneSkin.this.isSelectingTab = false;
                    }
                    Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
                    double d7 = this.snapSize(this.prefHeight(-1.0));
                    double d8 = side.equals((Object)Side.LEFT) || side.equals((Object)Side.BOTTOM) ? this.snapSize(this.getWidth()) - TabHeaderArea.this.getScrollOffset() : TabHeaderArea.this.getScrollOffset();
                    TabHeaderArea.this.updateHeaderClip();
                    for (Node node : this.getChildren()) {
                        double d9;
                        TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                        d = this.snapSize(tabHeaderSkin.prefWidth(-1.0));
                        double d10 = this.snapSize(tabHeaderSkin.prefHeight(-1.0));
                        tabHeaderSkin.resize(d, d10);
                        double d11 = d9 = side.equals((Object)Side.BOTTOM) ? 0.0 : d7 - d10 - this.snapSize(this.getInsets().getBottom());
                        if (side.equals((Object)Side.LEFT) || side.equals((Object)Side.BOTTOM)) {
                            tabHeaderSkin.relocate(d8 -= d, d9);
                            continue;
                        }
                        tabHeaderSkin.relocate(d8, d9);
                        d8 += d;
                    }
                }
            };
            this.headersRegion.getStyleClass().setAll((String[])new String[]{"headers-region"});
            this.headersRegion.setClip(this.headerClip);
            this.headerBackground = new StackPane();
            this.headerBackground.getStyleClass().setAll((String[])new String[]{"tab-header-background"});
            int n = 0;
            for (Tab tab : tabPane.getTabs()) {
                this.addTab(tab, n++, true);
            }
            this.controlButtons = new TabControlButtons();
            this.controlButtons.setVisible(false);
            if (this.controlButtons.isVisible()) {
                this.controlButtons.setVisible(true);
            }
            this.getChildren().addAll((Node[])new Node[]{this.headerBackground, this.headersRegion, this.controlButtons});
        }

        private void updateHeaderClip() {
            Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = this.firstTabIndent();
            double d8 = this.snapSize(this.controlButtons.prefWidth(-1.0));
            double d9 = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double d10 = this.snapSize(this.headersRegion.prefHeight(-1.0));
            if (d8 > 0.0) {
                d8 += 10.0;
            }
            if (this.headersRegion.getEffect() instanceof DropShadow) {
                DropShadow dropShadow = (DropShadow)this.headersRegion.getEffect();
                d6 = dropShadow.getRadius();
            }
            d5 = this.snapSize(this.getWidth()) - d8 - d7;
            if (side.equals((Object)Side.LEFT) || side.equals((Object)Side.BOTTOM)) {
                if (d9 < d5) {
                    d3 = d9 + d6;
                } else {
                    d = d9 - d5;
                    d3 = d5 + d6;
                }
                d4 = d10;
            } else {
                d = -d6;
                d3 = (d9 < d5 ? d9 : d5) + d6;
                d4 = d10;
            }
            this.headerClip.setX(d);
            this.headerClip.setY(d2);
            this.headerClip.setWidth(d3);
            this.headerClip.setHeight(d4);
        }

        private void addTab(Tab tab, int n, boolean bl) {
            TabHeaderSkin tabHeaderSkin = new TabHeaderSkin(tab);
            tabHeaderSkin.setVisible(bl);
            this.headersRegion.getChildren().add(n, tabHeaderSkin);
        }

        private void removeTab(Tab tab) {
            TabHeaderSkin tabHeaderSkin = this.getTabHeaderSkin(tab);
            if (tabHeaderSkin != null) {
                if (this.tabsFit()) {
                    this.headersRegion.getChildren().remove(tabHeaderSkin);
                } else {
                    this.removeTab.add(tabHeaderSkin);
                    tabHeaderSkin.removeListeners(tab);
                }
            }
        }

        private TabHeaderSkin getTabHeaderSkin(Tab tab) {
            for (Node node : this.headersRegion.getChildren()) {
                TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                if (!tabHeaderSkin.getTab().equals(tab)) continue;
                return tabHeaderSkin;
            }
            return null;
        }

        private void createScrollTimeline(final double d) {
            this.scroll(d);
            this.scroller = new Timeline();
            this.scroller.setCycleCount(-1);
            this.scroller.getKeyFrames().add(new KeyFrame(Duration.millis(150.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TabHeaderArea.this.scroll(d);
                }
            }, new KeyValue[0]));
        }

        private void scroll(double d) {
            if (this.tabsFit()) {
                return;
            }
            Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
            double d2 = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double d3 = this.snapSize(this.controlButtons.prefWidth(-1.0));
            double d4 = this.getWidth() - d2 - d3;
            double d5 = side.equals((Object)Side.LEFT) || side.equals((Object)Side.BOTTOM) ? -d : d;
            double d6 = this.getScrollOffset() + d5;
            this.setScrollOffset(d6 >= 0.0 ? 0.0 : (d6 <= d4 ? d4 : d6));
        }

        private boolean tabsFit() {
            double d;
            double d2 = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double d3 = d2 + (d = this.snapSize(this.controlButtons.prefWidth(-1.0))) + this.firstTabIndent() + 10.0;
            return d3 < this.getWidth();
        }

        private void scrollToSelectedTab(double d, double d2) {
            if (d > d2) {
                double d3;
                double d4 = d - d2;
                double d5 = d2 + this.getScrollOffset() + d4;
                if (d5 > (d3 = this.snapSize(this.getWidth()) - this.snapSize(this.controlButtons.prefWidth(-1.0)) - this.firstTabIndent() - 10.0)) {
                    this.setScrollOffset(this.getScrollOffset() - (d5 - d3));
                }
            } else {
                double d6 = d + this.getScrollOffset();
                if (d6 < 0.0) {
                    this.setScrollOffset(this.getScrollOffset() - d6);
                }
            }
        }

        private double firstTabIndent() {
            switch (((TabPane)TabPaneSkin.this.getSkinnable()).getSide()) {
                case TOP: 
                case BOTTOM: {
                    return this.snapSize(this.getInsets().getLeft());
                }
                case LEFT: 
                case RIGHT: {
                    return this.snapSize(this.getInsets().getTop());
                }
            }
            return 0.0;
        }

        @Override
        protected double computePrefWidth(double d) {
            double d2 = TabPaneSkin.this.isHorizontal() ? this.snapSize(this.getInsets().getLeft()) + this.snapSize(this.getInsets().getRight()) : this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom());
            return this.snapSize(this.headersRegion.prefWidth(-1.0)) + d2;
        }

        @Override
        protected double computePrefHeight(double d) {
            double d2 = TabPaneSkin.this.isHorizontal() ? this.snapSize(this.getInsets().getTop()) + this.snapSize(this.getInsets().getBottom()) : this.snapSize(this.getInsets().getLeft()) + this.snapSize(this.getInsets().getRight());
            return this.snapSize(this.headersRegion.prefHeight(-1.0)) + d2;
        }

        @Override
        public double getBaselineOffset() {
            return this.headersRegion.getBaselineOffset() + this.headersRegion.getLayoutY();
        }

        @Override
        protected void layoutChildren() {
            TabPane tabPane = (TabPane)TabPaneSkin.this.getSkinnable();
            Insets insets = this.getInsets();
            double d = this.snapSize(this.getWidth()) - (TabPaneSkin.this.isHorizontal() ? this.snapSize(insets.getLeft()) + this.snapSize(insets.getRight()) : this.snapSize(insets.getTop()) + this.snapSize(insets.getBottom()));
            double d2 = this.snapSize(this.getHeight()) - (TabPaneSkin.this.isHorizontal() ? this.snapSize(insets.getTop()) + this.snapSize(insets.getBottom()) : this.snapSize(insets.getLeft()) + this.snapSize(insets.getRight()));
            double d3 = this.snapSize(this.prefHeight(-1.0));
            double d4 = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double d5 = this.snapSize(this.headersRegion.prefHeight(-1.0));
            if (this.tabsFit()) {
                this.controlButtons.showTabsMenu(false);
            } else {
                this.controlButtons.showTabsMenu(true);
            }
            this.updateHeaderClip();
            double d6 = this.snapSize(this.controlButtons.prefWidth(-1.0));
            this.controlButtons.resize(d6, this.controlButtons.getControlTabHeight());
            this.headersRegion.resize(d4, d5);
            if (TabPaneSkin.this.isFloatingStyleClass()) {
                this.headerBackground.setVisible(false);
            } else {
                this.headerBackground.resize(this.snapSize(this.getWidth()), this.snapSize(this.getHeight()));
                this.headerBackground.setVisible(true);
            }
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
            if (side.equals((Object)Side.TOP)) {
                d7 = this.snapSize(insets.getLeft());
                d8 = d3 - d5 - this.snapSize(insets.getBottom());
                d9 = d - d6 + this.snapSize(insets.getLeft());
                d10 = this.snapSize(this.getHeight()) - this.controlButtons.getControlTabHeight() - this.snapSize(insets.getBottom());
            } else if (side.equals((Object)Side.RIGHT)) {
                d7 = this.snapSize(insets.getTop());
                d8 = d3 - d5 - this.snapSize(insets.getLeft());
                d9 = d - d6 + this.snapSize(insets.getTop());
                d10 = this.snapSize(this.getHeight()) - this.controlButtons.getControlTabHeight() - this.snapSize(insets.getLeft());
            } else if (side.equals((Object)Side.BOTTOM)) {
                d7 = this.snapSize(this.getWidth()) - d4 - this.snapSize(this.getInsets().getLeft());
                d8 = d3 - d5 - this.snapSize(insets.getTop());
                d9 = this.snapSize(insets.getRight());
                d10 = this.snapSize(this.getHeight()) - this.controlButtons.getControlTabHeight() - this.snapSize(insets.getTop());
            } else if (side.equals((Object)Side.LEFT)) {
                d7 = this.snapSize(this.getWidth()) - d4 - this.snapSize(this.getInsets().getTop());
                d8 = d3 - d5 - this.snapSize(insets.getRight());
                d9 = this.snapSize(insets.getLeft());
                d10 = this.snapSize(this.getHeight()) - this.controlButtons.getControlTabHeight() - this.snapSize(insets.getRight());
            }
            if (this.headerBackground.isVisible()) {
                this.positionInArea(this.headerBackground, 0.0, 0.0, this.snapSize(this.getWidth()), this.snapSize(this.getHeight()), 0.0, HPos.CENTER, VPos.CENTER);
            }
            this.positionInArea(this.headersRegion, d7, d8, d, d2, 0.0, HPos.LEFT, VPos.CENTER);
            this.positionInArea(this.controlButtons, d9, d10, d6, this.controlButtons.getControlTabHeight(), 0.0, HPos.CENTER, VPos.CENTER);
        }
    }
}

