/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.io.Formatable;

public class BaseTypeIdImpl
implements Formatable {
    private int formatId;
    String SQLTypeName;
    transient int JDBCTypeId;

    public BaseTypeIdImpl() {
    }

    public BaseTypeIdImpl(int n) {
        this.formatId = n;
        this.setTypeIdSpecificInstanceVariables();
    }

    BaseTypeIdImpl(String string) {
        this.SQLTypeName = string;
    }

    public String getSQLTypeName() {
        return this.SQLTypeName;
    }

    public int getJDBCTypeId() {
        return this.JDBCTypeId;
    }

    public String toParsableString(TypeDescriptor typeDescriptor) {
        String string = this.getSQLTypeName();
        switch (this.formatId) {
            case 28: 
            case 30: {
                int n = string.indexOf(41);
                String string2 = string.substring(0, n);
                string = string2 + typeDescriptor.getMaximumWidth() + string.substring(n);
                break;
            }
            case 17: 
            case 25: 
            case 442: 
            case 446: {
                string = string + "(" + typeDescriptor.getMaximumWidth() + ")";
                break;
            }
            case 198: {
                string = string + "(" + typeDescriptor.getPrecision() + "," + typeDescriptor.getScale() + ")";
            }
        }
        return string;
    }

    public boolean userType() {
        return false;
    }

    public String toString() {
        return MessageService.getTextMessage("44X00.U") + ": " + this.getSQLTypeName();
    }

    public boolean equals(Object object) {
        if (object instanceof BaseTypeIdImpl) {
            return this.getSQLTypeName().equals(((BaseTypeIdImpl)object).getSQLTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.getSQLTypeName().hashCode();
    }

    public int getTypeFormatId() {
        return this.formatId;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.SQLTypeName = objectInput.readUTF();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.SQLTypeName);
    }

    private void setTypeIdSpecificInstanceVariables() {
        switch (this.formatId) {
            case 16: {
                this.SQLTypeName = "BOOLEAN";
                this.JDBCTypeId = JVMInfo.JAVA_SQL_TYPES_BOOLEAN;
                break;
            }
            case 19: {
                this.SQLTypeName = "INTEGER";
                this.JDBCTypeId = 4;
                break;
            }
            case 22: {
                this.SQLTypeName = "SMALLINT";
                this.JDBCTypeId = 5;
                break;
            }
            case 196: {
                this.SQLTypeName = "TINYINT";
                this.JDBCTypeId = -6;
                break;
            }
            case 23: {
                this.SQLTypeName = "BIGINT";
                this.JDBCTypeId = -5;
                break;
            }
            case 198: {
                this.SQLTypeName = "DECIMAL";
                this.JDBCTypeId = 3;
                break;
            }
            case 18: {
                this.SQLTypeName = "DOUBLE";
                this.JDBCTypeId = 8;
                break;
            }
            case 20: {
                this.SQLTypeName = "REAL";
                this.JDBCTypeId = 7;
                break;
            }
            case 21: {
                this.SQLTypeName = "REF";
                this.JDBCTypeId = 1111;
                break;
            }
            case 17: {
                this.SQLTypeName = "CHAR";
                this.JDBCTypeId = 1;
                break;
            }
            case 25: {
                this.SQLTypeName = "VARCHAR";
                this.JDBCTypeId = 12;
                break;
            }
            case 231: {
                this.SQLTypeName = "LONG VARCHAR";
                this.JDBCTypeId = -1;
                break;
            }
            case 446: {
                this.SQLTypeName = "CLOB";
                this.JDBCTypeId = 2005;
                break;
            }
            case 28: {
                this.SQLTypeName = "CHAR () FOR BIT DATA";
                this.JDBCTypeId = -2;
                break;
            }
            case 30: {
                this.SQLTypeName = "VARCHAR () FOR BIT DATA";
                this.JDBCTypeId = -3;
                break;
            }
            case 233: {
                this.SQLTypeName = "LONG VARCHAR FOR BIT DATA";
                this.JDBCTypeId = -4;
                break;
            }
            case 442: {
                this.SQLTypeName = "BLOB";
                this.JDBCTypeId = 2004;
                break;
            }
            case 32: {
                this.SQLTypeName = "DATE";
                this.JDBCTypeId = 91;
                break;
            }
            case 33: {
                this.SQLTypeName = "TIME";
                this.JDBCTypeId = 92;
                break;
            }
            case 34: {
                this.SQLTypeName = "TIMESTAMP";
                this.JDBCTypeId = 93;
                break;
            }
            case 457: {
                this.SQLTypeName = "XML";
                this.JDBCTypeId = 2009;
                break;
            }
        }
    }
}

