/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonListener;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class BaseButtonUI
extends BasicButtonUI {
    protected static Rectangle viewRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseButtonUI();
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setOpaque(false);
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setOpaque(true);
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BaseButtonListener(abstractButton);
    }

    protected void paintBackground(Graphics graphics, AbstractButton abstractButton) {
        if (!abstractButton.isContentAreaFilled() || abstractButton.getParent() instanceof JMenuBar) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        Color[] colorArray = null;
        ButtonModel buttonModel = abstractButton.getModel();
        colorArray = abstractButton.isEnabled() ? (abstractButton.getBackground() instanceof ColorUIResource ? (buttonModel.isPressed() && buttonModel.isArmed() ? AbstractLookAndFeel.getTheme().getPressedColors() : (buttonModel.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : AbstractLookAndFeel.getTheme().getButtonColors())) : (buttonModel.isPressed() && buttonModel.isArmed() ? ColorHelper.createColorArr(abstractButton.getBackground(), ColorHelper.darker(abstractButton.getBackground(), 50.0), 20) : (buttonModel.isRollover() ? ColorHelper.createColorArr(ColorHelper.brighter(abstractButton.getBackground(), 80.0), ColorHelper.brighter(abstractButton.getBackground(), 20.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(abstractButton.getBackground(), 40.0), ColorHelper.darker(abstractButton.getBackground(), 20.0), 20)))) : AbstractLookAndFeel.getTheme().getDisabledColors();
        if (abstractButton.isBorderPainted()) {
            Insets insets = abstractButton.getBorder().getBorderInsets(abstractButton);
            int n3 = insets.left > 0 ? 1 : 0;
            int n4 = insets.top > 0 ? 1 : 0;
            int n5 = insets.right > 0 ? n - 1 : n;
            int n6 = insets.bottom > 0 ? n2 - 1 : n2;
            JTattooUtilities.fillHorGradient(graphics, colorArray, n3, n4, n5 - n3, n6 - n4);
        } else {
            JTattooUtilities.fillHorGradient(graphics, colorArray, 0, 0, n, n2);
        }
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = -1;
        n = JTattooUtilities.getJavaVersion() >= 1.4 ? abstractButton.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(abstractButton.getText(), buttonModel.getMnemonic());
        if (buttonModel.isEnabled()) {
            int n2 = 0;
            if (buttonModel.isArmed() && buttonModel.isPressed()) {
                n2 = 1;
            }
            graphics.setColor(abstractButton.getForeground());
            JTattooUtilities.drawStringUnderlineCharAt(abstractButton, graphics, abstractButton.getText(), n, rectangle.x + n2, rectangle.y + n2 + fontMetrics.getAscent());
        } else {
            graphics.setColor(Color.white);
            JTattooUtilities.drawStringUnderlineCharAt(abstractButton, graphics, abstractButton.getText(), n, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
            graphics.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(abstractButton, graphics, abstractButton.getText(), n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        graphics.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, 4, 3, abstractButton.getWidth() - 8, abstractButton.getHeight() - 6);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        BaseButtonUI.viewRect.x = insets.left;
        BaseButtonUI.viewRect.y = insets.top;
        BaseButtonUI.viewRect.width = abstractButton.getWidth() - (insets.right + BaseButtonUI.viewRect.x);
        BaseButtonUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + BaseButtonUI.viewRect.y);
        BaseButtonUI.textRect.height = 0;
        BaseButtonUI.textRect.width = 0;
        BaseButtonUI.textRect.y = 0;
        BaseButtonUI.textRect.x = 0;
        BaseButtonUI.iconRect.height = 0;
        BaseButtonUI.iconRect.width = 0;
        BaseButtonUI.iconRect.y = 0;
        BaseButtonUI.iconRect.x = 0;
        int n = this.defaultTextIconGap;
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            n = abstractButton.getIconTextGap();
        }
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : n);
        this.paintBackground(graphics, abstractButton);
        if (abstractButton.getIcon() != null) {
            if (!abstractButton.isEnabled()) {
                object2 = graphics2D.getComposite();
                object = AlphaComposite.getInstance(3, 0.5f);
                graphics2D.setComposite((Composite)object);
                this.paintIcon(graphics, jComponent, iconRect);
                graphics2D.setComposite((Composite)object2);
            } else {
                if (abstractButton.getModel().isPressed() && abstractButton.getModel().isRollover()) {
                    ++BaseButtonUI.iconRect.x;
                    ++BaseButtonUI.iconRect.y;
                }
                this.paintIcon(graphics, jComponent, iconRect);
            }
        }
        if (string != null && !string.equals("")) {
            object2 = (View)jComponent.getClientProperty("html");
            if (object2 != null) {
                object = null;
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                ((View)object2).paint(graphics, textRect);
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                }
            } else {
                this.paintText(graphics, abstractButton, textRect);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
    }
}

