/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String ID_ATTRIBUTE = "id";

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        AbstractBeanDefinition abstractBeanDefinition = this.parseInternal(element, parserContext);
        if (!parserContext.isNested()) {
            try {
                String string = this.resolveId(element, abstractBeanDefinition, parserContext);
                if (!StringUtils.hasText((String)string)) {
                    parserContext.getReaderContext().error("Id is required for element '" + element.getLocalName() + "' when used as a top-level tag", element);
                }
                BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(abstractBeanDefinition, string);
                this.registerBeanDefinition(beanDefinitionHolder, parserContext.getRegistry());
                if (this.shouldFireEvents()) {
                    BeanComponentDefinition beanComponentDefinition = new BeanComponentDefinition(beanDefinitionHolder);
                    this.postProcessComponentDefinition(beanComponentDefinition);
                    parserContext.registerComponent(beanComponentDefinition);
                }
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {
                parserContext.getReaderContext().error(beanDefinitionStoreException.getMessage(), element);
                return null;
            }
        }
        return abstractBeanDefinition;
    }

    protected String resolveId(Element element, AbstractBeanDefinition abstractBeanDefinition, ParserContext parserContext) throws BeanDefinitionStoreException {
        if (this.shouldGenerateId()) {
            return parserContext.getReaderContext().generateBeanName(abstractBeanDefinition);
        }
        String string = element.getAttribute(ID_ATTRIBUTE);
        if (!StringUtils.hasText((String)string) && this.shouldGenerateIdAsFallback()) {
            string = parserContext.getReaderContext().generateBeanName(abstractBeanDefinition);
        }
        return string;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry) {
        BeanDefinitionReaderUtils.registerBeanDefinition(beanDefinitionHolder, beanDefinitionRegistry);
    }

    protected abstract AbstractBeanDefinition parseInternal(Element var1, ParserContext var2);

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return false;
    }

    protected boolean shouldFireEvents() {
        return true;
    }

    protected void postProcessComponentDefinition(BeanComponentDefinition beanComponentDefinition) {
    }
}

