/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.embed.EmbeddedSceneDragSourceInterface;
import com.sun.javafx.embed.EmbeddedSceneDragStartListenerInterface;
import com.sun.javafx.embed.EmbeddedSceneDropTargetInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.tk.Toolkit;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javafx.embed.swing.DataFlavorUtils;
import javafx.embed.swing.SwingDragSource;
import javafx.scene.input.TransferMode;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

final class SwingDnD {
    private final JFXPanelFacade facade;
    private final Transferable dndTransferable = new DnDTransferable();
    private final DragSourceListener dragSourceListener;
    private SwingDragSource swingDragSource;
    private EmbeddedSceneDragSourceInterface fxDragSource;
    private EmbeddedSceneDropTargetInterface dropTarget;
    private MouseEvent me;

    SwingDnD(final JComponent jComponent, JFXPanelFacade jFXPanelFacade) {
        this.facade = jFXPanelFacade;
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SwingDnD.this.storeMouseEvent(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                SwingDnD.this.storeMouseEvent(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SwingDnD.this.storeMouseEvent(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SwingDnD.this.storeMouseEvent(mouseEvent);
            }
        });
        this.dragSourceListener = new DragSourceAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
                if (SwingDnD.this.fxDragSource == null) {
                    return;
                }
                assert (SwingDnD.this.hasFxScene());
                try {
                    SwingDnD.this.fxDragSource.dragDropEnd(SwingDnD.dropActionToTransferMode(dragSourceDropEvent.getDropAction()));
                }
                finally {
                    SwingDnD.this.fxDragSource = null;
                }
            }
        };
        new DropTarget(jComponent, 0x40000003, new DropTargetAdapter(){

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                if (!SwingDnD.this.hasFxScene()) {
                    dropTargetDragEvent.rejectDrag();
                    return;
                }
                if (SwingDnD.this.fxDragSource == null) {
                    assert (SwingDnD.this.swingDragSource == null);
                    SwingDnD.this.swingDragSource = new SwingDragSource(dropTargetDragEvent);
                }
                Point point = dropTargetDragEvent.getLocation();
                Point point2 = new Point(point);
                SwingUtilities.convertPointToScreen(point2, jComponent);
                SwingDnD.applyDragResult(SwingDnD.this.getDropTarget().handleDragEnter(point.x, point.y, point2.x, point2.y, SwingDnD.dropActionToTransferMode(dropTargetDragEvent.getDropAction()), SwingDnD.this.getDragSource()), dropTargetDragEvent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dragExit(DropTargetEvent dropTargetEvent) {
                if (!SwingDnD.this.hasFxScene()) {
                    return;
                }
                try {
                    SwingDnD.this.dropTarget.handleDragLeave();
                }
                finally {
                    SwingDnD.this.endDnD();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                if (!SwingDnD.this.hasFxScene()) {
                    return;
                }
                if (SwingDnD.this.swingDragSource != null) {
                    SwingDnD.this.swingDragSource.updateContents(dropTargetDragEvent);
                }
                Point point = dropTargetDragEvent.getLocation();
                Point point2 = new Point(point);
                SwingUtilities.convertPointToScreen(point2, jComponent);
                SwingDnD.applyDragResult(SwingDnD.this.dropTarget.handleDragOver(point.x, point.y, point2.x, point2.y, SwingDnD.dropActionToTransferMode(dropTargetDragEvent.getDropAction())), dropTargetDragEvent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                if (!SwingDnD.this.hasFxScene()) {
                    return;
                }
                Point point = dropTargetDropEvent.getLocation();
                Point point2 = new Point(point);
                SwingUtilities.convertPointToScreen(point2, jComponent);
                try {
                    TransferMode transferMode = SwingDnD.this.dropTarget.handleDragDrop(point.x, point.y, point2.x, point2.y, SwingDnD.dropActionToTransferMode(dropTargetDropEvent.getDropAction()));
                    SwingDnD.applyDropResult(transferMode, dropTargetDropEvent);
                    dropTargetDropEvent.dropComplete(transferMode != null);
                }
                finally {
                    SwingDnD.this.endDnD();
                }
            }
        });
    }

    void addNotify() {
        DragSource.getDefaultDragSource().addDragSourceListener(this.dragSourceListener);
    }

    void removeNotify() {
        DragSource.getDefaultDragSource().removeDragSourceListener(this.dragSourceListener);
    }

    EmbeddedSceneDragStartListenerInterface getDragStartListener() {
        return new EmbeddedSceneDragStartListenerInterface(){

            @Override
            public void dragStarted(final EmbeddedSceneDragSourceInterface embeddedSceneDragSourceInterface, final TransferMode transferMode) {
                assert (Toolkit.getToolkit().isFxUserThread());
                assert (embeddedSceneDragSourceInterface != null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        assert (SwingDnD.this.fxDragSource == null);
                        assert (SwingDnD.this.swingDragSource == null);
                        assert (SwingDnD.this.dropTarget == null);
                        SwingDnD.this.fxDragSource = embeddedSceneDragSourceInterface;
                        SwingDnD.startDrag(SwingDnD.this.me, SwingDnD.this.dndTransferable, embeddedSceneDragSourceInterface.getSupportedActions(), transferMode);
                    }
                });
            }
        };
    }

    private static void startDrag(final MouseEvent mouseEvent, Transferable transferable, final Set<TransferMode> set, TransferMode transferMode) {
        assert (set.contains((Object)transferMode));
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = SwingDnD.transferModeToDropAction(transferMode);
        final class StubDragGestureRecognizer
        extends DragGestureRecognizer {
            StubDragGestureRecognizer() {
                super(DragSource.getDefaultDragSource(), mouseEvent2.getComponent());
                super.setSourceActions(SwingDnD.transferModesToDropActions(set));
                super.appendEvent(mouseEvent);
            }

            @Override
            protected void registerListeners() {
            }

            @Override
            protected void unregisterListeners() {
            }
        }
        StubDragGestureRecognizer stubDragGestureRecognizer = new StubDragGestureRecognizer();
        List<InputEvent> list = Arrays.asList(stubDragGestureRecognizer.getTriggerEvent());
        DragGestureEvent dragGestureEvent = new DragGestureEvent(stubDragGestureRecognizer, n, point, list);
        dragGestureEvent.startDrag(null, transferable);
    }

    private boolean hasFxScene() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.getFxScene() != null;
    }

    private EmbeddedSceneInterface getFxScene() {
        return this.facade.getScene();
    }

    private EmbeddedSceneDragSourceInterface getDragSource() {
        assert (this.hasFxScene());
        assert (this.swingDragSource == null != (this.fxDragSource == null));
        if (this.swingDragSource != null) {
            return this.swingDragSource;
        }
        return this.fxDragSource;
    }

    private EmbeddedSceneDropTargetInterface getDropTarget() {
        assert (this.hasFxScene());
        if (this.dropTarget == null) {
            this.dropTarget = this.getFxScene().createDropTarget();
        }
        return this.dropTarget;
    }

    private void endDnD() {
        assert (this.dropTarget != null);
        this.dropTarget = null;
        if (this.swingDragSource != null) {
            this.swingDragSource = null;
        }
    }

    private void storeMouseEvent(MouseEvent mouseEvent) {
        this.me = mouseEvent;
    }

    private static void applyDragResult(TransferMode transferMode, DropTargetDragEvent dropTargetDragEvent) {
        if (transferMode == null) {
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(SwingDnD.transferModeToDropAction(transferMode));
        }
    }

    private static void applyDropResult(TransferMode transferMode, DropTargetDropEvent dropTargetDropEvent) {
        if (transferMode == null) {
            dropTargetDropEvent.rejectDrop();
        } else {
            dropTargetDropEvent.acceptDrop(SwingDnD.transferModeToDropAction(transferMode));
        }
    }

    static TransferMode dropActionToTransferMode(int n) {
        switch (n) {
            case 1: {
                return TransferMode.COPY;
            }
            case 2: {
                return TransferMode.MOVE;
            }
            case 0x40000000: {
                return TransferMode.LINK;
            }
            case 0: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    static int transferModeToDropAction(TransferMode transferMode) {
        switch (transferMode) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        throw new IllegalArgumentException();
    }

    static Set<TransferMode> dropActionsToTransferModes(int n) {
        EnumSet<TransferMode> enumSet = EnumSet.noneOf(TransferMode.class);
        if ((n & 1) != 0) {
            enumSet.add(TransferMode.COPY);
        }
        if ((n & 2) != 0) {
            enumSet.add(TransferMode.MOVE);
        }
        if ((n & 0x40000000) != 0) {
            enumSet.add(TransferMode.LINK);
        }
        return Collections.unmodifiableSet(enumSet);
    }

    static int transferModesToDropActions(Set<TransferMode> set) {
        int n = 0;
        for (TransferMode transferMode : set) {
            n |= SwingDnD.transferModeToDropAction(transferMode);
        }
        return n;
    }

    private static void checkSwingEventDispatchThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
    }

    private final class DnDTransferable
    implements Transferable {
        private DnDTransferable() {
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            SwingDnD.checkSwingEventDispatchThread();
            if (!SwingDnD.this.hasFxScene()) {
                return null;
            }
            String string = DataFlavorUtils.getFxMimeType(dataFlavor);
            return DataFlavorUtils.adjustFxData(dataFlavor, SwingDnD.this.getDragSource().getData(string));
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            SwingDnD.checkSwingEventDispatchThread();
            if (!SwingDnD.this.hasFxScene()) {
                return null;
            }
            String[] stringArray = SwingDnD.this.getDragSource().getMimeTypes();
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(stringArray.length);
            for (String string : stringArray) {
                DataFlavor dataFlavor = null;
                try {
                    dataFlavor = new DataFlavor(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                arrayList.add(dataFlavor);
            }
            return arrayList.toArray(new DataFlavor[0]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            SwingDnD.checkSwingEventDispatchThread();
            if (!SwingDnD.this.hasFxScene()) {
                return false;
            }
            return SwingDnD.this.getDragSource().isMimeTypeAvailable(DataFlavorUtils.getFxMimeType(dataFlavor));
        }
    }

    static interface JFXPanelFacade {
        public EmbeddedSceneInterface getScene();
    }
}

