/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaUtils;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class ImageCache {
    private final LinkedHashMap<Integer, PixelCountSoftReference> map = new LinkedHashMap(16, 0.75f, true);
    private final int maxPixelCount;
    private int currentPixelCount = 0;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReferenceQueue<Image> referenceQueue = new ReferenceQueue();
    private static final AquaUtils.RecyclableSingleton<ImageCache> instance = new AquaUtils.RecyclableSingleton<ImageCache>(){

        @Override
        protected ImageCache getInstance() {
            return new ImageCache();
        }
    };

    static ImageCache getInstance() {
        return instance.get();
    }

    ImageCache(int n) {
        this.maxPixelCount = n;
    }

    ImageCache() {
        this(0x200000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(GraphicsConfiguration graphicsConfiguration, int n, int n2, int n3, JRSUIState jRSUIState) {
        PixelCountSoftReference pixelCountSoftReference;
        int n4 = ImageCache.hash(graphicsConfiguration, n, n2, n3, jRSUIState);
        this.lock.readLock().lock();
        try {
            pixelCountSoftReference = this.map.get(n4);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (pixelCountSoftReference != null && pixelCountSoftReference.equals(graphicsConfiguration, n, n2, n3, jRSUIState)) {
            return (Image)pixelCountSoftReference.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setImage(Image image, GraphicsConfiguration graphicsConfiguration, int n, int n2, int n3, JRSUIState jRSUIState) {
        if (jRSUIState.is(JRSUIConstants.Animating.YES)) {
            return false;
        }
        int n4 = ImageCache.hash(graphicsConfiguration, n, n2, n3, jRSUIState);
        this.lock.writeLock().lock();
        try {
            PixelCountSoftReference pixelCountSoftReference = this.map.get(n4);
            if (pixelCountSoftReference != null && pixelCountSoftReference.get() == image) {
                boolean bl = true;
                return bl;
            }
            if (pixelCountSoftReference != null) {
                this.currentPixelCount -= pixelCountSoftReference.pixelCount;
                this.map.remove(n4);
            }
            int n5 = image.getWidth(null) * image.getHeight(null);
            this.currentPixelCount += n5;
            if (this.currentPixelCount > this.maxPixelCount) {
                while ((pixelCountSoftReference = (PixelCountSoftReference)this.referenceQueue.poll()) != null) {
                    this.map.remove(pixelCountSoftReference.hash);
                    this.currentPixelCount -= pixelCountSoftReference.pixelCount;
                }
            }
            if (this.currentPixelCount > this.maxPixelCount) {
                Iterator iterator = this.map.entrySet().iterator();
                while (this.currentPixelCount > this.maxPixelCount && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    iterator.remove();
                    Image image2 = (Image)((PixelCountSoftReference)entry.getValue()).get();
                    if (image2 != null) {
                        image2.flush();
                    }
                    this.currentPixelCount -= ((PixelCountSoftReference)entry.getValue()).pixelCount;
                }
            }
            this.map.put(n4, new PixelCountSoftReference(image, this.referenceQueue, n5, n4, graphicsConfiguration, n, n2, n3, jRSUIState));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static int hash(GraphicsConfiguration graphicsConfiguration, int n, int n2, int n3, JRSUIState jRSUIState) {
        int n4 = graphicsConfiguration != null ? graphicsConfiguration.hashCode() : 0;
        n4 = 31 * n4 + n;
        n4 = 31 * n4 + n2;
        n4 = 31 * n4 + n3;
        n4 = 31 * n4 + jRSUIState.hashCode();
        return n4;
    }

    private static class PixelCountSoftReference
    extends SoftReference<Image> {
        final int pixelCount;
        final int hash;
        private final GraphicsConfiguration config;
        private final int w;
        private final int h;
        private final int scale;
        private final JRSUIState state;

        PixelCountSoftReference(Image image, ReferenceQueue<? super Image> referenceQueue, int n, int n2, GraphicsConfiguration graphicsConfiguration, int n3, int n4, int n5, JRSUIState jRSUIState) {
            super(image, referenceQueue);
            this.pixelCount = n;
            this.hash = n2;
            this.config = graphicsConfiguration;
            this.w = n3;
            this.h = n4;
            this.scale = n5;
            this.state = jRSUIState;
        }

        boolean equals(GraphicsConfiguration graphicsConfiguration, int n, int n2, int n3, JRSUIState jRSUIState) {
            return graphicsConfiguration == this.config && n == this.w && n2 == this.h && n3 == this.scale && jRSUIState.equals(this.state);
        }
    }
}

