/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.DeviceBean;
import cn.com.voltronic.solar.dbtools.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class DeviceDao
extends BaseDao {
    private static final String INSERT_SERIALNO = "INSERT INTO SERIALNO(prodid,serialno,mpptnumber,modetype,parallel,modelname) VALUES(?,?,?,?,?,?)";
    private static final String SELECT_SERIALNO = "select * from serialno where serialno=? order by serialno";
    private static final String QUERYDATA_PRODID_1 = " SELECT distinct prodid FROM serialno order by prodid";
    private static final String QUERYDATA_SERIALNO = " SELECT distinct serialno FROM SERIALNO  order by serialno";
    private static final String QUERYDATA_SERIALNO_NO_PRODID = " SELECT distinct serialno FROM SERIALNO where prodid != ? and  prodid != ?  and  prodid != ? order by serialno";
    private static final String UPDATE_SERIALNO = " update serialno set mpptnumber=?,modetype=?,parallel=?,modelname=? where prodid=? and serialno=?";
    private static final String DELETE = "delete from serialno";

    public boolean InsertOrUpdateDevice(DeviceBean bean) {
        boolean result;
        block9: {
            result = false;
            boolean update = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select serialno from serialno where prodid=? and serialno=? ");
                    ps.setString(1, bean.getProdid());
                    ps.setString(2, bean.getSerialno());
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        update = true;
                    }
                    this.close(rs, ps);
                    rs = null;
                    if (update) {
                        ps = conn.prepareStatement(UPDATE_SERIALNO);
                        ps.setInt(1, bean.getMpptnumber());
                        ps.setString(2, bean.getModetype());
                        ps.setInt(3, bean.getParallel());
                        ps.setString(4, bean.getModelname());
                        ps.setString(5, bean.getProdid());
                        ps.setString(6, bean.getSerialno());
                    } else {
                        ps = conn.prepareStatement(INSERT_SERIALNO);
                        ps.setString(1, bean.getProdid());
                        ps.setString(2, bean.getSerialno());
                        ps.setInt(3, bean.getMpptnumber());
                        ps.setString(4, bean.getModetype());
                        ps.setInt(5, bean.getParallel());
                        ps.setString(6, bean.getModelname());
                    }
                    if (ps.executeUpdate() > 0) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public List<String> querySerialnoAll() {
        ArrayList<String> result;
        block7: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(QUERYDATA_SERIALNO);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            result.add(rs.getString("serialno"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }

    public List<String> querySerialnoAll(String prodid1, String prodid2, String prodid3) {
        ArrayList<String> result;
        block7: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(QUERYDATA_SERIALNO_NO_PRODID);
                        ps.setString(1, prodid1);
                        ps.setString(2, prodid2);
                        ps.setString(3, prodid3);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            result.add(rs.getString("serialno"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        return result;
    }

    public DeviceBean queryDevicebySerialno(String serialno) {
        DeviceBean bean;
        block8: {
            bean = null;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (conn != null) {
                try {
                    try {
                        ps = conn.prepareStatement(SELECT_SERIALNO);
                        ps.setString(1, serialno);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            bean = new DeviceBean();
                            bean.setProdid(rs.getString("prodid"));
                            bean.setSerialno(rs.getString("serialno"));
                            bean.setMpptnumber(rs.getInt("mpptnumber"));
                            bean.setModetype(rs.getString("modetype"));
                            bean.setParallel(rs.getInt("parallel"));
                            bean.setModelname(rs.getString("modelname"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.close(rs, ps);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs, ps);
                    throw throwable;
                }
                this.close(rs, ps);
            }
        }
        if (bean == null) {
            bean = new DeviceBean();
        }
        return bean;
    }

    public boolean updateDevice(DeviceBean bean) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(UPDATE_SERIALNO);
                ps.setInt(1, bean.getMpptnumber());
                ps.setString(2, bean.getModetype());
                ps.setInt(3, bean.getParallel());
                ps.setString(4, bean.getModelname());
                ps.setString(5, bean.getProdid());
                ps.setString(6, bean.getSerialno());
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deleteAll() {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE);
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }
}

