/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5.viewer.categoryexplorer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryAbstractCellEditor;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerModel;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNode;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryNodeEditorRenderer;

public class CategoryNodeEditor
extends CategoryAbstractCellEditor {
    protected CategoryNodeEditorRenderer _renderer = new CategoryNodeEditorRenderer();
    protected CategoryNode _lastEditedNode;
    protected JCheckBox _checkBox = this._renderer.getCheckBox();
    protected CategoryExplorerModel _categoryModel;
    protected JTree _tree;

    public CategoryNodeEditor(CategoryExplorerModel categoryExplorerModel) {
        this._categoryModel = categoryExplorerModel;
        this._checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryNodeEditor.this._categoryModel.update(CategoryNodeEditor.this._lastEditedNode, CategoryNodeEditor.this._checkBox.isSelected());
                CategoryNodeEditor.this.stopCellEditing();
            }
        });
        this._renderer.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) != 0) {
                    CategoryNodeEditor.this.showPopup(CategoryNodeEditor.this._lastEditedNode, mouseEvent.getX(), mouseEvent.getY());
                }
                CategoryNodeEditor.this.stopCellEditing();
            }
        });
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this._lastEditedNode = (CategoryNode)object;
        this._tree = jTree;
        return this._renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
    }

    public Object getCellEditorValue() {
        return this._lastEditedNode.getUserObject();
    }

    protected JMenuItem createPropertiesMenuItem(final CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Properties");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryNodeEditor.this.showPropertiesDialog(categoryNode);
            }
        });
        return jMenuItem;
    }

    protected void showPropertiesDialog(CategoryNode categoryNode) {
        JOptionPane.showMessageDialog(this._tree, this.getDisplayedProperties(categoryNode), "Category Properties: " + categoryNode.getTitle(), -1);
    }

    protected Object getDisplayedProperties(CategoryNode categoryNode) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Category: " + categoryNode.getTitle());
        if (categoryNode.hasFatalRecords()) {
            arrayList.add("Contains at least one fatal LogRecord.");
        }
        if (categoryNode.hasFatalChildren()) {
            arrayList.add("Contains descendants with a fatal LogRecord.");
        }
        arrayList.add("LogRecords in this category alone: " + categoryNode.getNumberOfContainedRecords());
        arrayList.add("LogRecords in descendant categories: " + categoryNode.getNumberOfRecordsFromChildren());
        arrayList.add("LogRecords in this category including descendants: " + categoryNode.getTotalNumberOfRecords());
        return arrayList.toArray();
    }

    protected void showPopup(CategoryNode categoryNode, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setSize(150, 400);
        if (categoryNode.getParent() == null) {
            jPopupMenu.add(this.createRemoveMenuItem());
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(this.createSelectDescendantsMenuItem(categoryNode));
        jPopupMenu.add(this.createUnselectDescendantsMenuItem(categoryNode));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createExpandMenuItem(categoryNode));
        jPopupMenu.add(this.createCollapseMenuItem(categoryNode));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.createPropertiesMenuItem(categoryNode));
        jPopupMenu.show(this._renderer, n, n2);
    }

    protected JMenuItem createSelectDescendantsMenuItem(final CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Select All Descendant Categories");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryNodeEditor.this._categoryModel.setDescendantSelection(categoryNode, true);
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createUnselectDescendantsMenuItem(final CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Deselect All Descendant Categories");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryNodeEditor.this._categoryModel.setDescendantSelection(categoryNode, false);
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createExpandMenuItem(final CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Expand All Descendant Categories");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryNodeEditor.this.expandDescendants(categoryNode);
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createCollapseMenuItem(final CategoryNode categoryNode) {
        JMenuItem jMenuItem = new JMenuItem("Collapse All Descendant Categories");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryNodeEditor.this.collapseDescendants(categoryNode);
            }
        });
        return jMenuItem;
    }

    protected JMenuItem createRemoveMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Remove All Empty Categories");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                while (CategoryNodeEditor.this.removeUnusedNodes() > 0) {
                }
            }
        });
        return jMenuItem;
    }

    protected void expandDescendants(CategoryNode categoryNode) {
        Enumeration<TreeNode> enumeration = categoryNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode categoryNode2 = (CategoryNode)enumeration.nextElement();
            this.expand(categoryNode2);
        }
    }

    protected void collapseDescendants(CategoryNode categoryNode) {
        Enumeration<TreeNode> enumeration = categoryNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode categoryNode2 = (CategoryNode)enumeration.nextElement();
            this.collapse(categoryNode2);
        }
    }

    protected int removeUnusedNodes() {
        int n = 0;
        CategoryNode categoryNode = this._categoryModel.getRootCategoryNode();
        Enumeration<TreeNode> enumeration = categoryNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            CategoryNode categoryNode2 = (CategoryNode)enumeration.nextElement();
            if (!categoryNode2.isLeaf() || categoryNode2.getNumberOfContainedRecords() != 0 || categoryNode2.getParent() == null) continue;
            this._categoryModel.removeNodeFromParent(categoryNode2);
            ++n;
        }
        return n;
    }

    protected void expand(CategoryNode categoryNode) {
        this._tree.expandPath(this.getTreePath(categoryNode));
    }

    protected TreePath getTreePath(CategoryNode categoryNode) {
        return new TreePath(categoryNode.getPath());
    }

    protected void collapse(CategoryNode categoryNode) {
        this._tree.collapsePath(this.getTreePath(categoryNode));
    }
}

