/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.springframework.core.io.AbstractResource;

public class ByteArrayResource
extends AbstractResource {
    private final byte[] byteArray;
    private final String description;
    static /* synthetic */ Class array$B;

    public ByteArrayResource(byte[] byArray) {
        this(byArray, "resource loaded from byte array");
    }

    public ByteArrayResource(byte[] byArray, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Byte array must not be null");
        }
        this.byteArray = byArray;
        this.description = string != null ? string : "";
    }

    public final byte[] getByteArray() {
        return this.byteArray;
    }

    public boolean exists() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteArray);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof ByteArrayResource && Arrays.equals(((ByteArrayResource)object).byteArray, this.byteArray);
    }

    public int hashCode() {
        return (array$B == null ? (array$B = ByteArrayResource.class$("[B")) : array$B).hashCode() * 29 * this.byteArray.length;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

