/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Window;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDialogs {
    public static List<File> showFileChooser(Window owner, File folder, String filename, String title, int type, boolean multipleMode, List<ExtensionFilter> extensionFilters) {
        String _folder = CommonDialogs.convertFolder(folder);
        if (filename == null) {
            filename = "";
        }
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Type parameter must be equal to one of the constants from Type");
        }
        ExtensionFilter[] _extensionFilters = null;
        if (extensionFilters != null) {
            _extensionFilters = extensionFilters.toArray(new ExtensionFilter[0]);
        }
        return Application.GetApplication().staticCommonDialogs_showFileChooser(owner, _folder, filename, CommonDialogs.convertTitle(title), type, multipleMode, _extensionFilters);
    }

    public static File showFolderChooser(Window owner, File folder, String title) {
        return Application.GetApplication().staticCommonDialogs_showFolderChooser(owner, CommonDialogs.convertFolder(folder), CommonDialogs.convertTitle(title));
    }

    private static String convertFolder(File folder) {
        if (folder != null) {
            if (folder.isDirectory()) {
                return folder.getAbsolutePath();
            }
            throw new IllegalArgumentException("Folder parameter must be a valid folder");
        }
        return "";
    }

    private static String convertTitle(String title) {
        return title != null ? title : "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionFilter {
        private final String description;
        private final List<String> extensions;

        public ExtensionFilter(String description, List<String> extensions) {
            if (description == null || description.length() == 0) {
                throw new IllegalArgumentException("Description parameter must be non-null and not empty");
            }
            if (extensions == null || extensions.isEmpty()) {
                throw new IllegalArgumentException("Extensions parameter must be non-null and not empty");
            }
            for (String extension : extensions) {
                if (extension != null && extension.length() != 0) continue;
                throw new IllegalArgumentException("Each extension must be non-null and not empty");
            }
            this.description = description;
            this.extensions = extensions;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getExtensions() {
            return this.extensions;
        }

        public String[] extensionsToArray() {
            return this.extensions.toArray(new String[0]);
        }
    }

    public static final class Type {
        public static final int OPEN = 0;
        public static final int SAVE = 1;
    }
}

