/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.EventDispatcher;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractLine
implements Line {
    protected final Line.Info info;
    protected Control[] controls;
    AbstractMixer mixer;
    private boolean open = false;
    private final Vector listeners = new Vector();
    private static final Map<ThreadGroup, EventDispatcher> dispatchers = new WeakHashMap<ThreadGroup, EventDispatcher>();

    protected AbstractLine(Line.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
        if (controlArray == null) {
            controlArray = new Control[]{};
        }
        this.info = info;
        this.mixer = abstractMixer;
        this.controls = controlArray;
    }

    @Override
    public final Line.Info getLineInfo() {
        return this.info;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addLineListener(LineListener lineListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(lineListener)) {
                this.listeners.addElement(lineListener);
            }
        }
    }

    @Override
    public final void removeLineListener(LineListener lineListener) {
        this.listeners.removeElement(lineListener);
    }

    @Override
    public final Control[] getControls() {
        Control[] controlArray = new Control[this.controls.length];
        for (int i = 0; i < this.controls.length; ++i) {
            controlArray[i] = this.controls[i];
        }
        return controlArray;
    }

    @Override
    public final boolean isControlSupported(Control.Type type) {
        if (type == null) {
            return false;
        }
        for (int i = 0; i < this.controls.length; ++i) {
            if (type != this.controls[i].getType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Control getControl(Control.Type type) {
        if (type != null) {
            for (int i = 0; i < this.controls.length; ++i) {
                if (type != this.controls[i].getType()) continue;
                return this.controls[i];
            }
        }
        throw new IllegalArgumentException("Unsupported control type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setOpen(boolean bl) {
        boolean bl2 = false;
        long l = this.getLongFramePosition();
        AbstractLine abstractLine = this;
        synchronized (abstractLine) {
            if (this.open != bl) {
                this.open = bl;
                bl2 = true;
            }
        }
        if (bl2) {
            if (bl) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.OPEN, l));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.CLOSE, l));
            }
        }
    }

    final void sendEvents(LineEvent lineEvent) {
        this.getEventDispatcher().sendAudioEvents(lineEvent, this.listeners);
    }

    public final int getFramePosition() {
        return (int)this.getLongFramePosition();
    }

    public long getLongFramePosition() {
        return -1L;
    }

    final AbstractMixer getMixer() {
        return this.mixer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final EventDispatcher getEventDispatcher() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, EventDispatcher> map = dispatchers;
        synchronized (map) {
            EventDispatcher eventDispatcher = dispatchers.get(threadGroup);
            if (eventDispatcher == null) {
                eventDispatcher = new EventDispatcher();
                dispatchers.put(threadGroup, eventDispatcher);
                eventDispatcher.start();
            }
            return eventDispatcher;
        }
    }

    @Override
    public abstract void open() throws LineUnavailableException;

    @Override
    public abstract void close();
}

