/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowEagerClassLoading = true;
    private final Map beanDefinitionMap = new HashMap();
    private final List beanDefinitionNames = new ArrayList();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory beanFactory) {
        super(beanFactory);
    }

    public void setAllowBeanDefinitionOverriding(boolean bl) {
        this.allowBeanDefinitionOverriding = bl;
    }

    public void setAllowEagerClassLoading(boolean bl) {
        this.allowEagerClassLoading = bl;
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory configurableBeanFactory) {
        super.copyConfigurationFrom(configurableBeanFactory);
        if (configurableBeanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableBeanFactory;
            this.allowBeanDefinitionOverriding = defaultListableBeanFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = defaultListableBeanFactory.allowEagerClassLoading;
        }
    }

    public boolean containsBeanDefinition(String string) {
        return this.beanDefinitionMap.containsKey(string);
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray((Collection)this.beanDefinitionNames);
    }

    public String[] getBeanNamesForType(Class clazz) {
        return this.getBeanNamesForType(clazz, true, true);
    }

    public String[] getBeanNamesForType(Class clazz, boolean bl, boolean bl2) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String[] stringArray = this.beanDefinitionNames.iterator();
        while (stringArray.hasNext()) {
            String string = (String)stringArray.next();
            if (this.isAlias(string) || ((AbstractBeanDefinition)(object = this.getMergedBeanDefinition(string, false))).isAbstract() || !bl2 && !((AbstractBeanDefinition)object).hasBeanClass() && ((AbstractBeanDefinition)object).isLazyInit() && !this.allowEagerClassLoading) continue;
            try {
                boolean bl3;
                boolean bl4 = this.isBeanClassMatch(string, (RootBeanDefinition)object, class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean);
                boolean bl5 = bl3 = !(!bl2 && this.requiresEagerInitForType(string, bl4, ((AbstractBeanDefinition)object).getFactoryBeanName()) || !bl && !this.isSingleton(string) || !this.isTypeMatch(string, clazz));
                if (!bl3 && bl4) {
                    string = "&" + string;
                    boolean bl6 = bl3 = (bl || ((AbstractBeanDefinition)object).isSingleton()) && this.isTypeMatch(string, clazz);
                }
                if (!bl3) continue;
                arrayList.add(string);
            }
            catch (CannotLoadBeanClassException cannotLoadBeanClassException) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignoring bean class loading failure for bean '" + string + "'"), (Throwable)((Object)cannotLoadBeanClassException));
            }
        }
        stringArray = this.getSingletonNames();
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (this.containsBeanDefinition((String)object)) continue;
            if (this.isFactoryBean((String)object)) {
                if ((bl || this.isSingleton((String)object)) && this.isTypeMatch((String)object, clazz)) {
                    arrayList.add(object);
                    continue;
                }
                object = "&" + (String)object;
            }
            if (!this.isTypeMatch((String)object, clazz)) continue;
            arrayList.add(object);
        }
        return StringUtils.toStringArray(arrayList);
    }

    private boolean requiresEagerInitForType(String string, boolean bl, String string2) {
        return bl && !this.containsSingleton(string) || string2 != null && this.isFactoryBean(string2) && !this.containsSingleton(string2);
    }

    public Map getBeansOfType(Class clazz) throws BeansException {
        return this.getBeansOfType(clazz, true, true);
    }

    public Map getBeansOfType(Class clazz, boolean bl, boolean bl2) throws BeansException {
        String[] stringArray = this.getBeanNamesForType(clazz, bl, bl2);
        Map map = CollectionFactory.createLinkedMapIfPossible((int)stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                map.put(string, this.getBean(string));
                continue;
            }
            catch (BeanCreationException beanCreationException) {
                BeanCreationException beanCreationException2;
                Throwable throwable = beanCreationException.getMostSpecificCause();
                if (throwable instanceof BeanCurrentlyInCreationException && this.isCurrentlyInCreation((beanCreationException2 = (BeanCreationException)((Object)throwable)).getBeanName())) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Ignoring match to currently created bean '" + string + "': " + beanCreationException.getMessage()));
                    continue;
                }
                throw beanCreationException;
            }
        }
        return map;
    }

    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Pre-instantiating singletons in " + this));
        }
        Iterator iterator = this.beanDefinitionNames.iterator();
        while (iterator.hasNext()) {
            RootBeanDefinition rootBeanDefinition;
            String string = (String)iterator.next();
            if (this.containsSingleton(string) || !this.containsBeanDefinition(string) || (rootBeanDefinition = this.getMergedBeanDefinition(string, false)).isAbstract() || !rootBeanDefinition.isSingleton() || rootBeanDefinition.isLazyInit()) continue;
            Class clazz = this.resolveBeanClass(rootBeanDefinition, string);
            if (clazz != null && (class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(clazz)) {
                this.getBean("&" + string);
                continue;
            }
            this.getBean(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeanDefinition(String string, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Object v;
        Assert.hasText((String)string, (String)"'beanName' must not be empty");
        Assert.notNull((Object)beanDefinition, (String)"BeanDefinition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException beanDefinitionValidationException) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), string, "Validation of bean definition failed", (Throwable)((Object)beanDefinitionValidationException));
            }
        }
        if ((v = this.beanDefinitionMap.get(string)) != null) {
            if (!this.allowBeanDefinitionOverriding) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), string, "Cannot register bean definition [" + beanDefinition + "] for bean '" + string + "': There is already [" + v + "] bound.");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding bean definition for bean '" + string + "': replacing [" + v + "] with [" + beanDefinition + "]"));
            }
        } else {
            this.beanDefinitionNames.add(string);
        }
        this.beanDefinitionMap.put(string, beanDefinition);
        Object object = this.getSingletonMutex();
        synchronized (object) {
            this.removeSingleton(string);
        }
    }

    public BeanDefinition getBeanDefinition(String string) throws NoSuchBeanDefinitionException {
        BeanDefinition beanDefinition = (BeanDefinition)this.beanDefinitionMap.get(string);
        if (beanDefinition == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No bean named '" + string + "' found in " + this));
            }
            throw new NoSuchBeanDefinitionException(string);
        }
        return beanDefinition;
    }

    protected Map findAutowireCandidates(String string, Class clazz) {
        String[] stringArray = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this, clazz);
        Map map = CollectionFactory.createLinkedMapIfPossible((int)stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals(string) || this.containsBeanDefinition(string2) && !this.getMergedBeanDefinition(string2).isAutowireCandidate()) continue;
            map.put(string2, this.getBean(string2));
        }
        return map;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(ObjectUtils.identityToString((Object)this));
        stringBuffer.append(": defining beans [");
        stringBuffer.append(StringUtils.arrayToCommaDelimitedString((Object[])this.getBeanDefinitionNames()));
        stringBuffer.append("]; ");
        BeanFactory beanFactory = this.getParentBeanFactory();
        if (beanFactory == null) {
            stringBuffer.append("root of factory hierarchy");
        } else {
            stringBuffer.append("parent: " + ObjectUtils.identityToString((Object)beanFactory));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

