/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.repository;

import java.lang.reflect.Type;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.parser.SignatureParser;
import sun.reflect.generics.repository.GenericDeclRepository;
import sun.reflect.generics.tree.ClassSignature;
import sun.reflect.generics.tree.ClassTypeSignature;
import sun.reflect.generics.visitor.Reifier;

public class ClassRepository
extends GenericDeclRepository<ClassSignature> {
    private volatile Type superclass;
    private volatile Type[] superInterfaces;

    private ClassRepository(String string, GenericsFactory genericsFactory) {
        super(string, genericsFactory);
    }

    @Override
    protected ClassSignature parse(String string) {
        return SignatureParser.make().parseClassSig(string);
    }

    public static ClassRepository make(String string, GenericsFactory genericsFactory) {
        return new ClassRepository(string, genericsFactory);
    }

    public Type getSuperclass() {
        Type type = this.superclass;
        if (type == null) {
            Reifier reifier = this.getReifier();
            ((ClassSignature)this.getTree()).getSuperclass().accept(reifier);
            this.superclass = type = reifier.getResult();
        }
        return type;
    }

    public Type[] getSuperInterfaces() {
        Type[] typeArray = this.superInterfaces;
        if (typeArray == null) {
            ClassTypeSignature[] classTypeSignatureArray = ((ClassSignature)this.getTree()).getSuperInterfaces();
            typeArray = new Type[classTypeSignatureArray.length];
            for (int i = 0; i < classTypeSignatureArray.length; ++i) {
                Reifier reifier = this.getReifier();
                classTypeSignatureArray[i].accept(reifier);
                typeArray[i] = reifier.getResult();
            }
            this.superInterfaces = typeArray;
        }
        return (Type[])typeArray.clone();
    }
}

