/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ReflectionToStringBuilder
extends ToStringBuilder {
    private static ThreadLocal registry = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashSet();
        }
    };
    private boolean appendStatics = false;
    private boolean appendTransients = false;
    private String[] excludeFieldNames;
    private Class upToClass = null;

    static Set getRegistry() {
        return (Set)registry.get();
    }

    static boolean isRegistered(Object object) {
        return ReflectionToStringBuilder.getRegistry().contains(object);
    }

    static void register(Object object) {
        ReflectionToStringBuilder.getRegistry().add(object);
    }

    public static String toString(Object object) {
        return ReflectionToStringBuilder.toString(object, null, false, false, null);
    }

    public static String toString(Object object, ToStringStyle toStringStyle) {
        return ReflectionToStringBuilder.toString(object, toStringStyle, false, false, null);
    }

    public static String toString(Object object, ToStringStyle toStringStyle, boolean bl) {
        return ReflectionToStringBuilder.toString(object, toStringStyle, bl, false, null);
    }

    public static String toString(Object object, ToStringStyle toStringStyle, boolean bl, boolean bl2) {
        return ReflectionToStringBuilder.toString(object, toStringStyle, bl, bl2, null);
    }

    public static String toString(Object object, ToStringStyle toStringStyle, boolean bl, boolean bl2, Class clazz) {
        return new ReflectionToStringBuilder(object, toStringStyle, null, clazz, bl, bl2).toString();
    }

    public static String toString(Object object, ToStringStyle toStringStyle, boolean bl, Class clazz) {
        return new ReflectionToStringBuilder(object, toStringStyle, null, clazz, bl).toString();
    }

    public static String toStringExclude(Object object, String string) {
        return ReflectionToStringBuilder.toStringExclude(object, new String[]{string});
    }

    public static String toStringExclude(Object object, Collection collection) {
        return ReflectionToStringBuilder.toStringExclude(object, ReflectionToStringBuilder.toNoNullStringArray(collection));
    }

    static String[] toNoNullStringArray(Collection collection) {
        if (collection == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ReflectionToStringBuilder.toNoNullStringArray(collection.toArray());
    }

    static String[] toNoNullStringArray(Object[] objectArray) {
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object != null) {
                arrayList.add(object.toString());
            }
            ++n;
        }
        return arrayList.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String toStringExclude(Object object, String[] stringArray) {
        return new ReflectionToStringBuilder(object).setExcludeFieldNames(stringArray).toString();
    }

    static void unregister(Object object) {
        ReflectionToStringBuilder.getRegistry().remove(object);
    }

    public ReflectionToStringBuilder(Object object) {
        super(object);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle toStringStyle) {
        super(object, toStringStyle);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle toStringStyle, StringBuffer stringBuffer) {
        super(object, toStringStyle, stringBuffer);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle toStringStyle, StringBuffer stringBuffer, Class clazz, boolean bl) {
        super(object, toStringStyle, stringBuffer);
        this.setUpToClass(clazz);
        this.setAppendTransients(bl);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle toStringStyle, StringBuffer stringBuffer, Class clazz, boolean bl, boolean bl2) {
        super(object, toStringStyle, stringBuffer);
        this.setUpToClass(clazz);
        this.setAppendTransients(bl);
        this.setAppendStatics(bl2);
    }

    protected boolean accept(Field field) {
        if (field.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers()) && !this.isAppendTransients()) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers()) && !this.isAppendStatics()) {
            return false;
        }
        return this.getExcludeFieldNames() == null || Arrays.binarySearch(this.getExcludeFieldNames(), field.getName()) < 0;
    }

    protected void appendFieldsIn(Class clazz) {
        if (ReflectionToStringBuilder.isRegistered(this.getObject())) {
            this.appendAsObjectToString(this.getObject());
            return;
        }
        try {
            this.registerObject();
            if (clazz.isArray()) {
                this.reflectionAppendArray(this.getObject());
                Object var10_2 = null;
                this.unregisterObject();
                return;
            }
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(accessibleObjectArray, true);
            int n = 0;
            while (n < accessibleObjectArray.length) {
                block11: {
                    AccessibleObject accessibleObject = accessibleObjectArray[n];
                    String string = ((Field)accessibleObject).getName();
                    if (this.accept((Field)accessibleObject)) {
                        try {
                            Object var8_11;
                            Object object = this.getValue((Field)accessibleObject);
                            if (ReflectionToStringBuilder.isRegistered(object) && !((Field)accessibleObject).getType().isPrimitive()) {
                                this.getStyle().appendFieldStart(this.getStringBuffer(), string);
                                this.appendAsObjectToString(object);
                                this.getStyle().appendFieldEnd(this.getStringBuffer(), string);
                                break block11;
                            }
                            try {
                                this.registerObject();
                                this.append(string, object);
                                var8_11 = null;
                                this.unregisterObject();
                            }
                            catch (Throwable throwable) {
                                var8_11 = null;
                                this.unregisterObject();
                                throw throwable;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new InternalError("Unexpected IllegalAccessException: " + illegalAccessException.getMessage());
                        }
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var10_4 = null;
            this.unregisterObject();
            throw throwable;
        }
        Object var10_3 = null;
        this.unregisterObject();
    }

    public String[] getExcludeFieldNames() {
        return this.excludeFieldNames;
    }

    public Class getUpToClass() {
        return this.upToClass;
    }

    protected Object getValue(Field field) throws IllegalArgumentException, IllegalAccessException {
        return field.get(this.getObject());
    }

    public boolean isAppendStatics() {
        return this.appendStatics;
    }

    public boolean isAppendTransients() {
        return this.appendTransients;
    }

    public ToStringBuilder reflectionAppendArray(Object object) {
        this.getStyle().reflectionAppendArrayDetail(this.getStringBuffer(), null, object);
        return this;
    }

    void registerObject() {
        ReflectionToStringBuilder.register(this.getObject());
    }

    public void setAppendStatics(boolean bl) {
        this.appendStatics = bl;
    }

    public void setAppendTransients(boolean bl) {
        this.appendTransients = bl;
    }

    public ReflectionToStringBuilder setExcludeFieldNames(String[] stringArray) {
        if (stringArray == null) {
            this.excludeFieldNames = null;
        } else {
            this.excludeFieldNames = ReflectionToStringBuilder.toNoNullStringArray(stringArray);
            Arrays.sort(this.excludeFieldNames);
        }
        return this;
    }

    public void setUpToClass(Class clazz) {
        this.upToClass = clazz;
    }

    public String toString() {
        if (this.getObject() == null) {
            return this.getStyle().getNullText();
        }
        Class<?> clazz = this.getObject().getClass();
        this.appendFieldsIn(clazz);
        while (clazz.getSuperclass() != null && clazz != this.getUpToClass()) {
            clazz = clazz.getSuperclass();
            this.appendFieldsIn(clazz);
        }
        return super.toString();
    }

    void unregisterObject() {
        ReflectionToStringBuilder.unregister(this.getObject());
    }
}

