/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.configure.ConfigureTools;
import cn.com.voltronic.solar.configure.PasswordConfig;
import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.MD5Util;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;

public class PasswordJDialog
extends AADialog {
    private static final long serialVersionUID = 2192844775828400661L;
    private AAButton applyButton;
    private AAButton clearButton;
    private AALabel jLabel1;
    private AALabel jLabel2;
    private AALabel jLabel4;
    private AALabel jLabel5;
    private JPasswordField oldPasswordField;
    private JPasswordField newPasswordField;
    private JPasswordField confirmPasswordField;

    public PasswordJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("message.passwordSet");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new AALabel();
        this.jLabel2 = new AALabel();
        this.oldPasswordField = new JPasswordField();
        this.jLabel4 = new AALabel();
        this.newPasswordField = new JPasswordField();
        this.jLabel5 = new AALabel();
        this.confirmPasswordField = new JPasswordField();
        this.applyButton = new AAButton();
        this.clearButton = new AAButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("message.password");
        this.jLabel2.setText("message.currentpassword[:]");
        this.jLabel4.setText("message.newpassword[:]");
        this.jLabel5.setText("message.affirmpassword[:]");
        this.applyButton.setText("message.apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                String inputOldString = new String(PasswordJDialog.this.oldPasswordField.getPassword()).trim();
                String inputNewString = new String(PasswordJDialog.this.newPasswordField.getPassword()).trim();
                String inputConfirmString = new String(PasswordJDialog.this.confirmPasswordField.getPassword()).trim();
                if (inputOldString.length() < 6) {
                    DisplayMessage.showErrorDialog("message.pswLess6");
                    PasswordJDialog.this.oldPasswordField.requestFocus(true);
                    return;
                }
                if (inputNewString.length() < 6) {
                    DisplayMessage.showErrorDialog("message.pswLess6");
                    PasswordJDialog.this.newPasswordField.requestFocus(true);
                    return;
                }
                if (inputConfirmString.length() < 6) {
                    DisplayMessage.showErrorDialog("message.pswLess6");
                    PasswordJDialog.this.confirmPasswordField.requestFocus(true);
                    return;
                }
                String oldPassword = "";
                try {
                    oldPassword = GlobalVariables.passwordConfig.getManagerPassword();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (MD5Util.validatePassword(oldPassword, inputOldString)) {
                    if (inputNewString.equals(inputConfirmString)) {
                        try {
                            PasswordConfig config = new PasswordConfig();
                            config.setManagerPassword(MD5Util.encodeByMD5(inputNewString));
                            ConfigureTools.updateProperties(config);
                            ConfigureTools.wrapProperties(GlobalVariables.passwordConfig);
                            DisplayMessage.showInfoDialog("message.modPswSuc");
                            PasswordJDialog.this.clearPassword();
                            PasswordJDialog.this.dispose();
                        }
                        catch (Exception ex) {
                            DisplayMessage.showErrorDialog("message.modPswFail");
                        }
                    } else {
                        DisplayMessage.showErrorDialog("message.notSame");
                        PasswordJDialog.this.newPasswordField.requestFocus(true);
                    }
                } else {
                    DisplayMessage.showErrorDialog("message.curPswError");
                    PasswordJDialog.this.oldPasswordField.requestFocus(true);
                }
            }
        });
        this.clearButton.setText("message.reset");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordJDialog.this.clearPassword();
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.applyButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clearButton)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.confirmPasswordField).addComponent(this.newPasswordField).addComponent(this.oldPasswordField, -2, 197, -2))).addContainerGap(59, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.oldPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.newPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.confirmPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.applyButton).addComponent(this.clearButton)).addContainerGap(29, Short.MAX_VALUE)));
        this.pack();
    }

    private void clearPassword() {
        this.oldPasswordField.setText("");
        this.newPasswordField.setText("");
        this.confirmPasswordField.setText("");
    }
}

