/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.communicate;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.util.CRCUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import usb.IUSBComm;

public class USBHandler
implements IComUSBHandler,
ICommunicateDevice {
    private static final Logger LOGGER = Logger.getLogger(USBHandler.class);
    private boolean isCrcCheck = false;
    private String usbId;
    private IUSBComm usbComm;
    protected AbstractProcessor notifyProcesser;
    private int _errorcount = 0;
    private boolean isUseCRC = false;

    public USBHandler(IUSBComm usbComm, String usbId) {
        this.usbComm = usbComm;
        this.usbId = usbId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String excuteSimpleCommand(String command) {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            String returnValue;
            block10: {
                boolean result = true;
                returnValue = "";
                try {
                    try {
                        int time = 0;
                        while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                            Thread.sleep(1000L);
                            returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
                            LOGGER.debug((Object)("excuteSimpleCommand:" + command));
                            LOGGER.debug((Object)returnValue);
                            ++time;
                        }
                        if (StringUtils.isEmpty((String)returnValue)) {
                            result = false;
                        }
                    }
                    catch (Exception ex) {
                        result = false;
                        this.countErrorandNotifyProcesser(result);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.countErrorandNotifyProcesser(result);
                    throw throwable;
                }
                this.countErrorandNotifyProcesser(result);
            }
            Debug.debug(command, returnValue);
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String excuteCommand(String command, boolean isResponse) {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            String returnValue;
            block14: {
                boolean result = true;
                returnValue = "";
                try {
                    try {
                        returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
                        if (isResponse) {
                            int time = 0;
                            while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 2) {
                                Thread.sleep(3000L);
                                returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
                                ++time;
                            }
                            if (StringUtils.isEmpty((String)returnValue)) {
                                result = false;
                            }
                        }
                        LOGGER.debug((Object)(String.valueOf(command) + "(" + returnValue.length() + ")" + ":" + returnValue));
                        if (this.isCrcCheck) {
                            if (CRCUtil.checkCRC(returnValue)) {
                                returnValue = returnValue.substring(0, returnValue.length() - 2);
                                LOGGER.debug((Object)(String.valueOf(command) + " check crc true "));
                            } else {
                                returnValue = "";
                                LOGGER.debug((Object)(String.valueOf(command) + " check crc false "));
                            }
                        }
                    }
                    catch (Exception ex) {
                        result = false;
                        this.countErrorandNotifyProcesser(result);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    this.countErrorandNotifyProcesser(result);
                    throw throwable;
                }
                this.countErrorandNotifyProcesser(result);
            }
            Debug.debug(command, returnValue);
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        IUSBComm iUSBComm = this.usbComm;
        synchronized (iUSBComm) {
            if (this.usbComm != null) {
                // empty if block
            }
        }
    }

    @Override
    public String getDeviceName() {
        return "USB" + this.usbId;
    }

    @Override
    public void setNotifyProcess(AbstractProcessor process) {
        this.notifyProcesser = process;
    }

    private void countErrorandNotifyProcesser(boolean success) {
        this._errorcount = success ? 0 : ++this._errorcount;
        if (this._errorcount >= 3 && this.notifyProcesser != null) {
            System.out.println("---------communication exception---------" + this._errorcount);
            this.notifyProcesser.close();
        }
    }

    @Override
    public int getMpptTrackNumber() {
        int mpptTrackNumber = 2;
        try {
            String result = this.excuteCommand("QPIRI", true);
            if (result != null && !"".equals(result) && !result.equals("QPIRI")) {
                String[] arr = result.split(" ");
                mpptTrackNumber = Integer.parseInt(arr[7]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mpptTrackNumber;
    }

    @Override
    public String getSerialNo() {
        String serialno = "";
        String serialnoStr = "";
        try {
            int i = 0;
            while (i < 3) {
                serialnoStr = this.excuteCommand("QID", true);
                if (!(serialnoStr == null || "".equals(serialnoStr) || serialnoStr.equalsIgnoreCase("(NAK") || serialnoStr.equalsIgnoreCase("(ACK") || serialnoStr.equals("QID"))) {
                    serialno = serialnoStr.substring(1);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serialno;
    }

    @Override
    public String getModeType() {
        String machineTypeStr = "";
        try {
            String qpiriStr = this.excuteCommand("QPIRI", true);
            if (!("".equals(qpiriStr) || qpiriStr.equals("(NAK") || qpiriStr.equals("QPIRI"))) {
                String[] ratingInfo = qpiriStr.split(" ");
                machineTypeStr = ratingInfo[8];
                return machineTypeStr;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return machineTypeStr;
    }

    @Override
    public String getDeviceModel() {
        String _deviceModel = "";
        try {
            String qdmStr = this.excuteCommand("QDM", true);
            if (!("".equals(qdmStr) || qdmStr.equals("(NAK") || qdmStr.equals("QDM"))) {
                _deviceModel = qdmStr = qdmStr.substring(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return _deviceModel;
    }

    @Override
    public void setCrcCheck(boolean isCrcCheck) {
        this.isCrcCheck = isCrcCheck;
    }

    @Override
    public String excuteSetCommand(String command, boolean isResponse) {
        return null;
    }

    @Override
    public boolean isUseCRC() {
        return this.isUseCRC;
    }

    @Override
    public void setUseCRC(boolean isUseCRC) {
        this.isUseCRC = isUseCRC;
    }

    @Override
    public String getModelName() {
        String modelName = "";
        try {
            String qgmn = this.excuteCommand("QGMN", true);
            if (!("".equals(qgmn) || qgmn.equals("(NAK") || qgmn.equals("QGMN"))) {
                modelName = qgmn = qgmn.substring(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return modelName;
    }
}

