/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.exception;

import cn.com.voltronic.solar.configure.ConfigureTools;
import cn.com.voltronic.solar.dao.EventCfgDao;
import cn.com.voltronic.solar.dao.EventRecordDao;
import cn.com.voltronic.solar.data.bean.EventData;
import cn.com.voltronic.solar.data.bean.EventDataRecord;
import cn.com.voltronic.solar.data.bean.Eventcfg;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.thread.SendEmailThread;
import cn.com.voltronic.solar.thread.SendSMSThread;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EventsHandler {
    private static Document document15 = null;
    private static Document document16 = null;
    private static Document document17 = null;
    private static Document document17P1S1 = null;
    private static Document document18 = null;
    private static Document document181TO2K = null;
    private static Document document1730K = null;
    private static final String XML_PATH = String.valueOf(System.getProperty("user.dir")) + File.separator + "config" + File.separator;

    static {
        try {
            document15 = EventsHandler.doDocument("Events_P15.xml");
            document16 = EventsHandler.doDocument("Events_P16.xml");
            document17 = EventsHandler.doDocument("Events_P17.xml");
            document17P1S1 = EventsHandler.doDocument("Events_P17P1S1.xml");
            document18 = EventsHandler.doDocument("Events_P18.xml");
            document181TO2K = EventsHandler.doDocument("Events_P181TO2K.xml");
            document1730K = EventsHandler.doDocument("Events_P1730K.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Document getDocument15() {
        return document15;
    }

    private static Document getDocument16() {
        return document16;
    }

    private static Document getDocument17() {
        return document17;
    }

    private static Document getDocument17P1S1() {
        return document17P1S1;
    }

    private static Document getDocument18() {
        return document18;
    }

    private static Document getDocument181TO2K() {
        return document181TO2K;
    }

    private static Document getDocument1730K() {
        return document1730K;
    }

    public static Document getDocumentByProdid(String prodid) {
        if (prodid.equals("P15") || prodid.equals("P20")) {
            return document15;
        }
        if (prodid.equals("P16")) {
            return document16;
        }
        if (prodid.equals("P17") || prodid.equals("P175K")) {
            return document17;
        }
        if (prodid.equals("P17P1S1")) {
            return document17P1S1;
        }
        if (prodid.equals("P18")) {
            return document18;
        }
        if (prodid.equals("P1812K") || prodid.equals("P1834K")) {
            return document181TO2K;
        }
        if (prodid.equals("P1730K")) {
            return document1730K;
        }
        return document16;
    }

    public static List<Element> getP15AllEvent() {
        List list = document15.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getP16AllEvent() {
        List list = document16.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getP17AllEvent() {
        List list = document17.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getP17P1S1AllEvent() {
        List list = document17P1S1.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getP18AllEvent() {
        List list = document18.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getP181TO2KAllEvent() {
        List list = document181TO2K.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getP1730KAllEvent() {
        List list = document1730K.getRootElement().elements("event");
        return list;
    }

    public static List<Element> getAllEvent(String protocol) {
        List<Element> list = null;
        list = protocol.equals("P16") ? EventsHandler.getP16AllEvent() : (protocol.equals("P15") || protocol.equals("P20") ? EventsHandler.getP15AllEvent() : (protocol.equals("P17") || protocol.equals("P175K") ? EventsHandler.getP17AllEvent() : (protocol.equals("P17P1S1") ? EventsHandler.getP17P1S1AllEvent() : (protocol.equals("P18") ? EventsHandler.getP18AllEvent() : (protocol.equals("P1812K") || protocol.equals("P1834K") ? EventsHandler.getP181TO2KAllEvent() : (protocol.equals("P1730K") ? EventsHandler.getP1730KAllEvent() : EventsHandler.getP16AllEvent()))))));
        return list;
    }

    private static Document doDocument(String fileName) {
        Document document;
        block15: {
            document = null;
            SAXReader reader = new SAXReader();
            File fileExt = null;
            try {
                fileExt = new File(String.valueOf(XML_PATH) + fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fileExt != null && fileExt.exists() && fileExt.isFile()) {
                FileInputStream fisExt = null;
                try {
                    try {
                        fisExt = new FileInputStream(fileExt);
                        document = reader.read((InputStream)fisExt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (fisExt == null) break block15;
                        try {
                            fisExt.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (fisExt != null) {
                        try {
                            fisExt.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return document;
    }

    public static EventData getEventById(String prodid, String eventId) {
        String eventName = "";
        int eventLevel = 0;
        if (prodid.equalsIgnoreCase("P16")) {
            eventName = EventsHandler.getEventname(document16, eventId);
            eventLevel = EventsHandler.getEventLevel(document16, eventId);
        } else if (prodid.equalsIgnoreCase("P15") || prodid.equalsIgnoreCase("P20")) {
            eventName = EventsHandler.getEventname(document15, eventId);
            eventLevel = EventsHandler.getEventLevel(document15, eventId);
        } else if (prodid.equalsIgnoreCase("P17") || prodid.equalsIgnoreCase("P175K")) {
            eventName = EventsHandler.getEventname(document17, eventId);
            eventLevel = EventsHandler.getEventLevel(document17, eventId);
        } else if (prodid.equalsIgnoreCase("P17P1S1")) {
            eventName = EventsHandler.getEventname(document17P1S1, eventId);
            eventLevel = EventsHandler.getEventLevel(document17P1S1, eventId);
        } else if (prodid.equalsIgnoreCase("P18")) {
            eventName = EventsHandler.getEventname(document18, eventId);
            eventLevel = EventsHandler.getEventLevel(document18, eventId);
        } else if (prodid.equalsIgnoreCase("P1812K") || prodid.equalsIgnoreCase("P1834K")) {
            eventName = EventsHandler.getEventname(document181TO2K, eventId);
            eventLevel = EventsHandler.getEventLevel(document181TO2K, eventId);
        } else if (prodid.equals("P1730K")) {
            eventName = EventsHandler.getEventname(document1730K, eventId);
            eventLevel = EventsHandler.getEventLevel(document1730K, eventId);
        } else {
            eventName = EventsHandler.getEventname(document16, eventId);
            eventLevel = EventsHandler.getEventLevel(document16, eventId);
        }
        EventData eventData = new EventData();
        eventData.setEventId(eventId);
        eventData.setEventLevel(eventLevel);
        eventData.setEventName(eventName);
        return eventData;
    }

    public static int getEventLevel(Document document, String eventId) {
        Element eventEle = (Element)document.selectSingleNode("//event[@id='" + eventId + "']");
        String level = eventEle.attributeValue("level");
        return Integer.parseInt(level);
    }

    public static String getEventname(Document document, String eventId) {
        Element eventEle = (Element)document.selectSingleNode("//event[@id='" + eventId + "']");
        String language = "en_US";
        try {
            ConfigureTools.wrapProperties(GlobalVariables.globalConfig);
            language = GlobalVariables.globalConfig.getLanguage();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String name = null;
        name = language.equals("en_US") ? eventEle.attributeValue("enName") : (language.equals("zh_CN") ? eventEle.attributeValue("name") : (language.equals("fr_FR") ? eventEle.attributeValue("frName") : (language.equals("de_DE") ? eventEle.attributeValue("deName") : (language.equals("it_IT") ? eventEle.attributeValue("itName") : (language.equals("pl_PL") ? eventEle.attributeValue("plName") : (language.equals("pt_PT") ? eventEle.attributeValue("ptName") : (language.equals("ru_RU") ? eventEle.attributeValue("rusName") : (language.equals("es_ES") ? eventEle.attributeValue("spName") : (language.equals("uk_UA") ? eventEle.attributeValue("ukrName") : (language.equals("tr_TR") ? eventEle.attributeValue("turName") : (language.equals("zh_TW") ? eventEle.attributeValue("twName") : (language.equals("ja_JP") ? eventEle.attributeValue("jpName") : eventEle.attributeValue("enName")))))))))))));
        return name;
    }

    private static void reocrdEvent(String prodid, String serialno, String eventId, Date trandate) {
        EventCfgDao cfgDao = new EventCfgDao();
        List<Eventcfg> cfgList = cfgDao.queryEventcfg(eventId);
        int i = 0;
        while (i < cfgList.size()) {
            String message;
            EventData eventData;
            Eventcfg cfg;
            block15: {
                EventDataRecord eventdata;
                EventRecordDao eventDao;
                cfg = cfgList.get(i);
                if (cfg.getAction() == 1 && !(eventDao = new EventRecordDao()).alreadyInsert(eventdata = new EventDataRecord(prodid, serialno, eventId, trandate))) {
                    eventDao.insertEvent(eventdata);
                }
                if (cfg.getAction() == 2) {
                    String port = "38694";
                    try {
                        port = GlobalVariables.globalConfig.getUdpPort();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    EventData eventData2 = EventsHandler.getEventById(prodid, eventId);
                    String message2 = eventData2.getEventName();
                    UdpClient udpClient = null;
                    try {
                        try {
                            udpClient = new UdpClient("localhost", port);
                            String eventDescription = "(Event:[" + serialno + "] [" + VolUtil.getFormatTimestamp(trandate) + "] " + message2 + "13";
                            udpClient.send(eventDescription);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (udpClient != null) {
                                udpClient.disconnect();
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (udpClient != null) {
                            udpClient.disconnect();
                        }
                        throw throwable;
                    }
                    if (udpClient != null) {
                        udpClient.disconnect();
                    }
                }
            }
            if (cfg.getAction() == 3) {
                eventData = EventsHandler.getEventById(prodid, eventId);
                message = eventData.getEventName();
                SendEmailThread sendEmailUtil = new SendEmailThread(serialno, DateUtils.getFormatTimestamp(trandate), message, cfg.getReceive());
                sendEmailUtil.start();
            }
            if (cfg.getAction() == 4) {
                eventData = EventsHandler.getEventById(prodid, eventId);
                message = eventData.getEventName();
                SendSMSThread sendSMSUtil = new SendSMSThread(serialno, DateUtils.getFormatTimestamp(trandate), message, cfg.getReceive());
                sendSMSUtil.start();
            }
            ++i;
        }
    }

    public static void handleEvent(String prodid, String serialno, Date trandate, String eventId) {
        if (!(prodid == null || "".equals(prodid) || serialno == null || "".equals(serialno) || eventId == null || "".equals(eventId) || trandate == null)) {
            EventsHandler.reocrdEvent(prodid, serialno, eventId, trandate);
        }
    }

    public static String getFaultString(String prodid, String str) {
        String faultString = "";
        faultString = prodid.equals("P16") ? EventsHandler.getEventname(EventsHandler.getDocument16(), str) : (prodid.equals("P17") || prodid.equals("P175K") ? EventsHandler.getEventname(EventsHandler.getDocument17(), str) : (prodid.equals("P17P1S1") ? EventsHandler.getEventname(EventsHandler.getDocument17P1S1(), str) : (prodid.equals("P18") ? EventsHandler.getEventname(EventsHandler.getDocument18(), str) : (prodid.equals("P1812K") || prodid.equals("P1834K") ? EventsHandler.getEventname(EventsHandler.getDocument181TO2K(), str) : (prodid.equals("P20") ? EventsHandler.getEventname(EventsHandler.getDocument15(), str) : (prodid.equals("P1730K") ? EventsHandler.getEventname(EventsHandler.getDocument1730K(), str) : EventsHandler.getEventname(EventsHandler.getDocument15(), str)))))));
        return faultString;
    }

    public static List getEventList() {
        List<Element> list15 = EventsHandler.getP15AllEvent();
        List<Element> list16 = EventsHandler.getP16AllEvent();
        List<Element> list17 = EventsHandler.getP17AllEvent();
        List<Element> list173TO4K = EventsHandler.getP17P1S1AllEvent();
        List<Element> list18 = EventsHandler.getP18AllEvent();
        List<Element> list181TO2K = EventsHandler.getP181TO2KAllEvent();
        List<Element> list1730K = EventsHandler.getP1730KAllEvent();
        ArrayList<List<Element>> eventList = new ArrayList<List<Element>>();
        eventList.add(list15);
        eventList.add(list16);
        eventList.add(list17);
        eventList.add(list173TO4K);
        eventList.add(list18);
        eventList.add(list181TO2K);
        eventList.add(list1730K);
        return eventList;
    }
}

