/*
 * Decompiled with CFR 0.152.
 */
package usb;

import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.socket.SystemTrayUDPClient;
import cn.com.voltronic.solar.system.ShutdownInterface;
import cn.com.voltronic.solar.util.UPSCmdutils;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import usb.IUSBComm;

public class MacUSBRemote
implements ShutdownInterface,
IUSBComm {
    private static SystemTrayUDPClient client;
    private ReentrantLock lock = new ReentrantLock();
    private int useCRC = 0;

    public MacUSBRemote() {
        client = new SystemTrayUDPClient("localhost", 33656);
        this.startUSBSRVTest();
    }

    public void startUSBSRVTest() {
        boolean success = false;
        try {
            String result = "";
            client.send("TEST".getBytes());
            result = client.receiveString().trim();
            if (result.equals("(ACK")) {
                success = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!success) {
            this.startUpUSBServer();
        }
    }

    @Override
    public String sendCommand(String userId, String command) {
        this.lock.lock();
        String result = "";
        try {
            if (userId.trim().length() == 0) {
                return "";
            }
            try {
                String cmd = UPSCmdutils.cmdtoString(userId, command, this.useCRC);
                client.send(cmd.getBytes());
                byte[] bytes = client.receive();
                StringBuffer sb = new StringBuffer();
                byte ch = 0;
                if (bytes != null) {
                    int i = 0;
                    while (i < bytes.length) {
                        ch = bytes[i];
                        if (ch == 13) break;
                        sb.append((char)ch);
                        ++i;
                    }
                    result = sb.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public String findUSBDevices() {
        this.lock.lock();
        String result = "";
        this.startUSBSRVTest();
        try {
            try {
                String cmd = "findUSBDevices";
                Thread.sleep(500L);
                client.send(cmd.getBytes());
                result = client.receiveString().trim();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public void shutdownOS() {
        this.lock.lock();
        try {
            try {
                this.startUSBSRVTest();
                String cmd = "shutdownOS";
                client.send(cmd.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void beep(int time) {
        this.lock.lock();
        try {
            try {
                this.startUSBSRVTest();
                String cmd = UPSCmdutils.actiontoString("beep", "3");
                client.send(cmd.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void suspendOS() {
        this.lock.lock();
        try {
            try {
                this.startUSBSRVTest();
                String cmd = "suspendOS";
                client.send(cmd.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void closeUSBPort(String usbID) {
        this.lock.lock();
        try {
            if (usbID.trim().length() == 0) {
                return;
            }
            try {
                this.startUSBSRVTest();
                String cmd = UPSCmdutils.actiontoString("closeUSBPort", usbID);
                client.send(cmd.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitMacServ() {
        SystemTrayUDPClient systemTrayUDPClient = client;
        synchronized (systemTrayUDPClient) {
            String cmd = "EXIT";
            try {
                client.send(cmd.getBytes());
                Debug.debug("EXIT", "EXIT");
                Thread.sleep(5000L);
                this.startUSBSRVTest();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean setUseCRC(int paramInt) {
        this.useCRC = paramInt;
        return true;
    }

    private void startUpUSBServer() {
        try {
            String file = String.valueOf(System.getProperty("user.dir")) + File.separator + "lib" + File.separator + "usbserver";
            Runtime.getRuntime().exec(file);
            Thread.sleep(1500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

