/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AnnotationBeanWiringInfoResolver
implements BeanWiringInfoResolver {
    public BeanWiringInfo resolveWiringInfo(Object object) {
        Assert.notNull((Object)object, (String)"Bean instance must not be null");
        Configurable configurable = object.getClass().getAnnotation(Configurable.class);
        return configurable != null ? this.buildWiringInfo(object, configurable) : null;
    }

    protected BeanWiringInfo buildWiringInfo(Object object, Configurable configurable) {
        if (!Autowire.NO.equals((Object)configurable.autowire())) {
            return new BeanWiringInfo(configurable.autowire().value(), configurable.dependencyCheck());
        }
        String string = !"".equals(configurable.value()) ? configurable.value() : this.getDefaultBeanName(object);
        return new BeanWiringInfo(string);
    }

    protected String getDefaultBeanName(Object object) {
        return ClassUtils.getUserClass((Object)object).getName();
    }
}

